/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.r3startup.impl1.dispatcher;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.CommunicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.event.ClusterEventListener;
import com.sap.engine.frame.cluster.message.ListenerAlreadyRegisteredException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.frame.container.monitor.ServiceMonitor;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.services.r3startup.Message;
import com.sap.engine.services.r3startup.R3Notifier;
import com.sap.engine.services.r3startup.SocketListener;
import com.sap.engine.services.r3startup.dispatcher.SocketThread;
import com.sap.engine.services.r3startup.shellcmd.SendActiveCommand;
import com.sap.engine.services.r3startup.shellcmd.SendInActiveCommand;
import com.sap.engine.services.r3startup.shellcmd.SendInvalidateEtagCommand;
import com.sap.engine.services.r3startup.shellcmd.SendInvalidateURLCommand;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.util.HashSet;
import java.util.Properties;

public class R3StartupService
implements CommunicationServiceFrame,
ContainerEventListener,
ClusterEventListener,
MessageListener,
SocketListener,
R3Notifier {
    private static final String port_key = "Port";
    private static final String type_key = "Type";
    private static final String type_http = "http";
    private static final String type_ssl = "ssl";
    private CommunicationServiceContext csc;
    private static Location location = null;
    private static Category category = null;
    private SocketThread r3socket = null;
    private Socket communicationSocket = null;
    private int http_port = -1;
    private int https_port = -1;
    private int loadBalance;
    private HashMapIntObject elements = null;
    private ShellInterface shell = null;
    private int count;
    private int activeCount;
    private boolean inactiveFlag;
    private boolean inSoftShutdown = false;
    private ClusterElement currentElement = null;

    public void start(CommunicationServiceContext csc) throws ServiceException {
        this.currentElement = csc.getClusterContext().getClusterMonitor().getCurrentParticipant();
        Properties props = csc.getServiceState().getProperties();
        location = Location.getLocation((String)this.getClass().getName());
        category = Category.SYS_SERVER;
        String connectionPort = SystemProperties.getProperty((String)"CONNECT_PORT");
        if (connectionPort == null) {
            connectionPort = props.getProperty("CONNECT_PORT");
        }
        if (connectionPort == null) {
            category.logT(500, location, "Error occurred while reading property 'CONNECT_PORT'. It may be missing or having a non-integer value. J2EE dispatcher may not be able to connect to the R/3 dispatcher. Please try to restore or correct this property and then restart the service.");
            throw new ServiceException("Necessary property is missing !!! ---> CONNECT_PORT");
        }
        try {
            this.loadBalance = this.count = Integer.parseInt(props.getProperty("elements"));
        }
        catch (Exception e) {
            category.logT(500, location, "Error occurred while reading property 'elements' from the r3startup service settings. It may be missing or having a non-integer value. Please try to restore or correct this property and then restart the service.");
            throw new ServiceException("Necessary property is missing !!! ---> Elements");
        }
        try {
            this.elements = new HashMapIntObject();
            this.loadElements(props, this.count);
        }
        catch (Exception e) {
            category.logT(500, location, "Error occurred while reading settings for the installed cluster elements: " + e.getMessage() + ". Please check if " + "'element_NO_id' and 'element_NO_dir' are present and well " + "formed");
            throw new ServiceException("Necessary property is missing !!! ---> element_id");
        }
        location.logT(300, "Connection port is set to : " + connectionPort);
        this.csc = csc;
        this.activeCount = 0;
        this.inactiveFlag = true;
        csc.getClusterContext().getMessageContext().registerListener((MessageListener)this);
        this.initializeR3Socket(connectionPort);
        csc.getContainerContext().getObjectRegistry().registerInterface((Object)this);
        int mask = 196;
        HashSet<String> names = new HashSet<String>(2);
        names.add("shell");
        names.add(type_http);
        csc.getServiceState().registerContainerEventListener(mask, names, (ContainerEventListener)this);
        try {
            csc.getServiceState().registerClusterEventListener((ClusterEventListener)this);
        }
        catch (ListenerAlreadyRegisteredException e) {
            e.printStackTrace();
        }
    }

    private void loadElements(Properties props, int elementNumber) {
        int i = 0;
        while (i < elementNumber) {
            this.elements.put(Integer.parseInt(props.getProperty("element_" + i + "_id")), (Object)props.getProperty("element_" + i + "_dir"));
            ++i;
        }
    }

    public void stop() {
        this.csc.getContainerContext().getObjectRegistry().unregisterInterface();
        this.csc.getClusterContext().getMessageContext().unregisterListener();
        this.csc.getServiceState().unregisterContainerEventListener();
        this.csc.getServiceState().unregisterClusterEventListener();
        if (!this.inSoftShutdown) {
            try {
                this.sendInactive();
                this.r3socket.close();
                this.r3socket = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void containerStarted() {
    }

    public void beginContainerStop() {
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
        if (serviceName.equals(type_http)) {
            try {
                ServiceMonitor httpServiceMonitor = this.csc.getContainerContext().getSystemMonitor().getService(type_http);
                String propValue = httpServiceMonitor.getProperty("Ports");
                this.sendHTTPPort(Integer.parseInt(this.determinePort(type_http, propValue)));
                this.sendHTTPSPort(Integer.parseInt(this.determinePort(type_ssl, propValue)));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String determinePort(String portType, String portsPropValue) {
        int b = -1;
        int e = -1;
        String s = null;
        String v = null;
        String port = null;
        while ((b = portsPropValue.indexOf(40, e + 1)) > -1 && (e = portsPropValue.indexOf(41, b + 1)) > -1) {
            s = portsPropValue.substring(b + 1, e);
            v = this.getValue(s, type_key);
            if (!v.equals(portType)) continue;
            port = this.getValue(s, port_key);
        }
        return port;
    }

    private String getValue(String data, String key) {
        int i = 0;
        int j = 0;
        while ((i = data.indexOf(key + ":", j)) > -1) {
            if (i == 0 || Character.isWhitespace(data.charAt(i - 1)) || data.charAt(i - 1) == ',') break;
            j += key.length() + 1;
        }
        if (i > -1) {
            j = data.indexOf(44, i += key.length() + 1);
            if (j == -1) {
                j = data.length();
            }
            return data.substring(i, j);
        }
        return null;
    }

    public void serviceNotStarted(String serviceName) {
    }

    public void beginServiceStop(String serviceName) {
    }

    public void serviceStopped(String serviceName) {
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("shell")) {
            this.shell = (ShellInterface)interfaceImpl;
            Command[] coms = new Command[]{new SendActiveCommand(this.r3socket), new SendInActiveCommand(this.r3socket), new SendInvalidateURLCommand(this.r3socket), new SendInvalidateEtagCommand(this.r3socket)};
        }
    }

    public boolean setServiceProperty(String key, String value) {
        return false;
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        return false;
    }

    public void interfaceNotAvailable(String interfaceName) {
        if (interfaceName.equals("shell")) {
            this.shell = null;
        }
    }

    public void markForShutdown(long timeout) {
    }

    public void elementJoin(ClusterElement clusterElement) {
    }

    public void elementLoss(ClusterElement clusterElement) {
        HashMapIntObject hashMapIntObject = this.elements;
        synchronized (hashMapIntObject) {
            int elementID = clusterElement.getClusterId();
            if (this.elements.containsKey(elementID)) {
                --this.activeCount;
            }
        }
    }

    public void elementStateChanged(ClusterElement element, byte oldState) {
        if (element.getState() != 3) {
            return;
        }
        HashMapIntObject hashMapIntObject = this.elements;
        synchronized (hashMapIntObject) {
            if (this.elements.containsKey(element.getClusterId())) {
                ++this.activeCount;
                if (this.activeCount == this.count && this.inactiveFlag) {
                    this.inactiveFlag = false;
                    this.sendActive();
                }
            }
        }
    }

    public void receive(int clusterId, int messageType, byte[] body, int offset, int length) {
    }

    public MessageAnswer receiveWait(int clusterId, int messageType, byte[] body, int offset, int length) {
        return null;
    }

    public void noop() {
        location.logT(300, "NOOP command received from R/3 dispatcher.");
    }

    public void hardShutdown() {
    }

    public void softShutdown() {
    }

    private void initializeR3Socket(String connectionPort) {
        try {
            if (this.communicationSocket == null) {
                String address = this.currentElement.getAddress().getHostAddress();
                this.communicationSocket = new Socket(address, Integer.parseInt(connectionPort));
                location.logT(300, "Communication socket to R/3 dispatcher opened on localhost.");
            }
            this.r3socket = new SocketThread(this.communicationSocket, this);
            this.r3socket.start();
            ServiceMonitor httpServiceMonitor = this.csc.getContainerContext().getSystemMonitor().getService(type_http);
            if (httpServiceMonitor != null) {
                String propValue = httpServiceMonitor.getProperty("Ports");
                this.sendHTTPPort(Integer.parseInt(this.determinePort(type_http, propValue)));
                this.sendHTTPSPort(Integer.parseInt(this.determinePort(type_ssl, propValue)));
            }
            this.sendLoadBalance(this.loadBalance);
        }
        catch (Exception e) {
            category.logT(600, location, "Couldn't complete initial communication!" + Message.LINE_SEPARATOR + "Exception is : " + e.getMessage());
        }
    }

    public boolean invalidateEtag(String name) {
        if (this.r3socket == null) {
            return false;
        }
        try {
            this.r3socket.sendMessage(Message.encodeInvalidateEtag(name));
        }
        catch (IOException exc) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            exc.printStackTrace(out);
            out.flush();
            location.logT(500, "Couldn't send INVALIDATE_ETAG to R/3 dispatcher. Exception is : " + sw.toString());
            return false;
        }
        location.logT(300, "J2EE Engine sent INVALIDATE_ETAG=" + name + " to R/3 dispatcher.");
        return true;
    }

    public boolean invalidateURL(String url) {
        if (this.r3socket == null) {
            return false;
        }
        try {
            this.r3socket.sendMessage(Message.encodeInvalidateURL(url));
        }
        catch (IOException exc) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            exc.printStackTrace(out);
            out.flush();
            location.logT(500, "Couldn't send INVALIDATE_URL to R/3 dispatcher. Exception is : " + sw.toString());
            return false;
        }
        location.logT(300, "J2EE Engine sent INVALIDATE_URL=" + url + " to R/3 dispatcher.");
        return true;
    }

    public boolean sendActive() {
        if (this.r3socket == null) {
            return false;
        }
        try {
            this.r3socket.sendMessage(Message.encodeActive());
        }
        catch (IOException exc) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            exc.printStackTrace(out);
            out.flush();
            location.logT(500, "Couldn't send ACTIVE to R/3 dispatcher. Exception is : " + sw.toString());
            return false;
        }
        location.logT(300, "J2EE Engine sent ACTIVE to R/3 dispatcher.");
        return true;
    }

    public boolean sendInactive() {
        if (this.r3socket == null) {
            return false;
        }
        try {
            this.r3socket.sendMessage(Message.encodeInactive());
        }
        catch (IOException exc) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            exc.printStackTrace(out);
            out.flush();
            location.logT(500, "Couldn't send INACTIVE to R/3 dispatcher. Exception is : " + sw.toString());
            return false;
        }
        location.logT(300, "J2EE Engine sent INACTIVE to R/3 dispatcher.");
        return true;
    }

    public boolean sendLoadBalance(int loadBalance) {
        if (this.r3socket == null) {
            return false;
        }
        try {
            this.r3socket.sendMessage(Message.encodeLB(loadBalance));
        }
        catch (IOException exc) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            exc.printStackTrace(out);
            out.flush();
            location.logT(500, "Couldn't send LB to R/3 dispatcher. Exception is : " + sw.toString());
            return false;
        }
        location.logT(300, "J2EE Engine sent LB=" + loadBalance + " to R/3 dispatcher.");
        return true;
    }

    public synchronized boolean sendHTTPPort(int port) {
        if (port == this.http_port) {
            return true;
        }
        this.http_port = port;
        if (this.r3socket == null) {
            return false;
        }
        try {
            this.r3socket.sendMessage(Message.encodeHTTPPort(port));
        }
        catch (IOException exc) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            exc.printStackTrace(out);
            out.flush();
            location.logT(500, "Couldn't send HTTP_PORT to R/3 dispatcher. Exception is : " + sw.toString());
            return false;
        }
        location.logT(300, "J2EE Engine sent HTTP_PORT=" + port + " to R/3 dispatcher.");
        return true;
    }

    public boolean sendHTTPSPort(int port) {
        if (port == this.https_port) {
            return true;
        }
        this.https_port = port;
        if (this.r3socket == null) {
            return false;
        }
        try {
            this.r3socket.sendMessage(Message.encodeHTTPSPort(port));
        }
        catch (IOException exc) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            exc.printStackTrace(out);
            out.flush();
            location.logT(500, "Couldn't send HTTPS_PORT to R/3 dispatcher. Exception is : " + sw.toString());
            return false;
        }
        location.logT(300, "J2EE Engine sent HTTPS_PORT=" + port + " to R/3 dispatcher.");
        return true;
    }

    public static Location getLog() {
        return location;
    }

    public static Category getCategory() {
        return category;
    }
}

