/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.r3startup.impl0.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.services.r3startup.Message;
import com.sap.engine.services.r3startup.PIDManager;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Properties;

public final class R3StartupService
implements ApplicationServiceFrame,
MessageListener {
    private int pid = -1;
    private int clusterID = -1;
    private boolean running = false;
    private Properties props = null;
    private ApplicationServiceContext serviceContext = null;
    private static Location location = null;
    private static Category category = null;

    public void start(ApplicationServiceContext serviceContext) throws ServiceException {
        Properties properties = serviceContext.getServiceState().getProperties();
        location = Location.getLocation((String)this.getClass().getName());
        category = Category.SYS_SERVER;
        if (this.props != null) {
            this.running = true;
            this.changeProperties(properties);
            return;
        }
        String pidsFileName = properties.getProperty("PIDsLogFileName");
        if (pidsFileName == null) {
            category.logT(500, location, "Error occurred while reading property 'PIDsLogFileName' from the r3startup service settings. If this property is not set properly, the dispatcher will not be able to control this server node. Please try to restore this property and then restart the service.");
            throw new ServiceException("Necessary property is missing !!! ---> PIDsLogFileName");
        }
        try {
            this.pid = PIDManager.getPid();
            location.logT(300, "Current process id is : " + this.pid);
            this.clusterID = serviceContext.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
            PIDManager.logEntry(new RandomAccessFile(pidsFileName, "rw"), this.clusterID, this.pid);
        }
        catch (Exception e) {
            category.logT(500, location, "Unable to start the R3startup service!" + Message.LINE_SEPARATOR + "Exception is : " + e.getMessage());
            throw new ServiceException(e.getMessage());
        }
        serviceContext.getClusterContext().getMessageContext().registerListener((MessageListener)this);
        this.serviceContext = serviceContext;
        this.props = properties;
        this.running = true;
    }

    public boolean changeProperties(Properties properties) {
        if (!this.running || ((Hashtable)this.props).equals(properties)) {
            return true;
        }
        try {
            String pidsFileName = properties.getProperty("PIDsLogFileName");
            if (!this.props.getProperty("PIDsLogFileName").equals(pidsFileName)) {
                PIDManager.logEntry(new RandomAccessFile(pidsFileName, "rw"), this.clusterID, this.pid);
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            e.printStackTrace(out);
            out.flush();
            location.logT(500, "Unable to change the properties of r3startup service!" + Message.LINE_SEPARATOR + "Exception is : " + sw.toString());
            return false;
        }
        location.logT(300, "R3startup service properties have been changed.");
        this.props = properties;
        return true;
    }

    public void stop() {
        this.running = false;
        this.serviceContext.getClusterContext().getMessageContext().unregisterListener();
    }

    public void receive(int clusterId, int messageType, byte[] body, int offset, int length) {
        location.logT(300, "SOFTSHUTDOWN command received from r3startup service on cluster element " + clusterId + ".");
        this.serviceContext.getCoreContext().getCoreMonitor().shutDown();
    }

    public MessageAnswer receiveWait(int clusterId, int messageType, byte[] body, int offset, int length) {
        return null;
    }
}

