/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.r3startup.impl0.dispatcher;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.CommunicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.event.ClusterEventListener;
import com.sap.engine.frame.cluster.message.ListenerAlreadyRegisteredException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.frame.container.monitor.ServiceMonitor;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.configuration.ConfigurationHandler;
import com.sap.engine.frame.core.configuration.ConfigurationLockedException;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.lib.util.ArrayInt;
import com.sap.engine.lib.util.EnumerationInt;
import com.sap.engine.lib.util.HashMapIntMultiObject;
import com.sap.engine.lib.util.IntHashHolder;
import com.sap.engine.lib.util.IntHashHolderImpl;
import com.sap.engine.services.r3startup.Message;
import com.sap.engine.services.r3startup.PIDManager;
import com.sap.engine.services.r3startup.R3Notifier;
import com.sap.engine.services.r3startup.SocketListener;
import com.sap.engine.services.r3startup.dispatcher.NullInputStreamThread;
import com.sap.engine.services.r3startup.dispatcher.SocketThread;
import com.sap.engine.services.r3startup.shellcmd.SendActiveCommand;
import com.sap.engine.services.r3startup.shellcmd.SendInActiveCommand;
import com.sap.engine.services.r3startup.shellcmd.SendInvalidateEtagCommand;
import com.sap.engine.services.r3startup.shellcmd.SendInvalidateURLCommand;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.net.Socket;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;

public final class R3StartupService
implements CommunicationServiceFrame,
ContainerEventListener,
ClusterEventListener,
MessageListener,
SocketListener,
R3Notifier {
    private CommunicationServiceContext csc;
    private Properties props;
    private String workingDir = null;
    private SocketThread r3socket = null;
    private Socket communicationSocket = null;
    private int pid;
    private int count;
    private int http_port = -1;
    private int https_port = -1;
    private int loadBalance;
    private Object[] elementProps = new Object[2];
    private HashMapIntMultiObject elements = null;
    private int activeCount;
    private boolean inactiveFlag;
    private String pidsFileName = null;
    private boolean inSoftShutdown = false;
    private int shutdownTimeout = 0;
    private ArrayInt shutdownSynchronizer = null;
    private ShellInterface shell = null;
    private int commandsID = -1;
    private static final byte[] SHUTDOWN_MSG = new byte[0];
    private static Location location = null;
    private static Category category = null;
    private ConfigurationHandler cfgHandler = null;
    private ClusterElement currentElement = null;

    public void start(CommunicationServiceContext csc) throws ServiceException {
        Properties props;
        block20: {
            this.currentElement = csc.getClusterContext().getClusterMonitor().getCurrentParticipant();
            props = csc.getServiceState().getProperties();
            location = Location.getLocation((String)this.getClass().getName());
            category = Category.SYS_SERVER;
            this.pidsFileName = props.getProperty("PIDsLogFileName");
            if (this.pidsFileName == null) {
                category.logT(500, location, "Error occurred while reading property 'PIDsLogFileName' from the r3startup service settings. If this property is not set properly, the dispatcher will not be able to control the server nodes. Please try to restore this property and then restart the service.");
                throw new ServiceException("Necessary property is missing !!! ---> PIDsLogFileName");
            }
            try {
                this.count = Integer.parseInt(props.getProperty("elements"));
                this.loadBalance = this.count < 10 ? this.count * 100 : 900 + this.count;
            }
            catch (Exception e) {
                category.logT(500, location, "Error occurred while reading property 'elements' from the r3startup service settings. It may be missing or having a non-integer value. Please try to restore or correct this property and then restart the service.");
                throw new ServiceException("Necessary property is missing !!! ---> Elements");
            }
            try {
                this.shutdownTimeout = Integer.parseInt(props.getProperty("ServerTimeoutAtSoftShutdown", "60"));
            }
            catch (Exception exc) {
                category.logT(500, location, "Error occurred while reading property 'ServerTimeoutAtSoftShutdown' from the r3startup service settings. It may be having a non-integer value. Please try to correct this property and then restart the service.");
            }
            String connectionPort = SystemProperties.getProperty((String)"CONNECT_PORT");
            if (connectionPort == null) {
                connectionPort = props.getProperty("CONNECT_PORT");
            }
            if (connectionPort == null) {
                category.logT(500, location, "Error occurred while reading property 'CONNECT_PORT'. It may be missing or having a non-integer value. J2EE dispatcher may not be able to connect to the R/3 dispatcher. Please try to restore or correct this property and then restart the service.");
                throw new ServiceException("Necessary property is missing !!! ---> CONNECT_PORT");
            }
            location.logT(300, "Connection port was set to " + connectionPort);
            this.csc = csc;
            this.activeCount = 0;
            this.inactiveFlag = true;
            this.shutdownSynchronizer = new ArrayInt();
            this.workingDir = csc.getServiceState().getWorkingDirectoryName();
            this.elements = new HashMapIntMultiObject(this.count, 2, 0.75f, 2, (IntHashHolder)new IntHashHolderImpl());
            csc.getClusterContext().getMessageContext().registerListener((MessageListener)this);
            this.initializeR3Socket(connectionPort);
            if (props.getProperty("KILL_OLD_SERVER_PIDS", "YES").toUpperCase().equals("YES")) {
                try {
                    RandomAccessFile pidLog = new RandomAccessFile(this.pidsFileName, "rw");
                    String entry = null;
                    while ((entry = pidLog.readLine()) != null) {
                        try {
                            location.logT(300, "Killing process of old server -> " + entry);
                            PIDManager.killEntry(entry);
                        }
                        catch (Exception exc) {
                            location.logT(500, "The server's process" + entry + "could not be " + "killed due to " + exc.getMessage() + ". Please, stop it manually.");
                            if (!SystemProperties.getBoolean((String)"debug")) continue;
                            exc.printStackTrace();
                        }
                    }
                    pidLog.setLength(0L);
                    pidLog.close();
                }
                catch (IOException ioe) {
                    location.logT(500, "Error occurred while reading " + this.pidsFileName + " during the killing of the " + "server node processes. The problem is " + ioe.getMessage());
                    if (!SystemProperties.getBoolean((String)"debug")) break block20;
                    ioe.printStackTrace();
                }
            }
        }
        csc.getContainerContext().getObjectRegistry().registerInterface((Object)this);
        int mask = 196;
        HashSet<String> names = new HashSet<String>(2);
        names.add("shell");
        names.add("http");
        csc.getServiceState().registerContainerEventListener(mask, names, (ContainerEventListener)this);
        this.cfgHandler = csc.getCoreContext().getConfigurationHandlerFactory().getConfigurationHandler();
        try {
            csc.getServiceState().registerClusterEventListener((ClusterEventListener)this);
        }
        catch (ListenerAlreadyRegisteredException e) {
            category.logT(300, location, "Exception occurred while executing impl0.dispatcher.R3StartupService.start(): " + e.getMessage());
        }
        int i = 0;
        while (i < this.count) {
            int elementID;
            String elementDir = null;
            try {
                elementID = Integer.parseInt(props.getProperty("element_" + i + "_id"));
                elementDir = props.getProperty("element_" + i + "_dir");
            }
            catch (Exception e) {
                location.logT(500, "Error occurred while reading 'element_" + i + "_id' or 'element_" + i + "_dir'" + "property from the r3startup service settings. " + "It may be missing. Please try to restore " + "this property and then restart the service.");
                this.stop();
                throw new ServiceException("Necessary service property is missing or invalid !!! ---> element_" + i + "_id or element_" + i + "_dir");
            }
            try {
                this.startElement(elementID, elementDir);
            }
            catch (Exception exc) {
                StringWriter sw = new StringWriter();
                PrintWriter out = new PrintWriter(sw);
                exc.printStackTrace(out);
                out.flush();
                location.logT(500, "Error occurred while starting server " + elementID + ". due to: " + sw.toString());
                this.stop();
                throw new ServiceException("Couldn't start server " + elementID + ". Exception is : " + sw.toString());
            }
            ++i;
        }
        this.props = props;
    }

    public void stop() {
        if (this.shell != null) {
            this.shell.unregisterCommands(this.commandsID);
        }
        this.csc.getContainerContext().getObjectRegistry().unregisterInterface();
        this.csc.getClusterContext().getMessageContext().unregisterListener();
        this.csc.getServiceState().unregisterContainerEventListener();
        this.csc.getServiceState().unregisterClusterEventListener();
        if (!this.inSoftShutdown) {
            try {
                this.sendInactive();
                this.r3socket.close();
                this.r3socket = null;
            }
            catch (Exception e) {
                category.logT(300, location, "Exception occurred while executing impl0.dispatcher.R3StartupService.stop(): " + e.getMessage());
            }
            this.stopElements();
        }
    }

    public void containerStarted() {
    }

    public void beginContainerStop() {
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
        if (serviceName.equals("http")) {
            try {
                ServiceMonitor httpServiceMonitor = this.csc.getContainerContext().getSystemMonitor().getService("http");
                String propValue = httpServiceMonitor.getProperty("Ports");
                this.sendHTTPPort(Integer.parseInt(this.determinePort("http", propValue)));
                this.sendHTTPSPort(Integer.parseInt(this.determinePort("ssl", propValue)));
            }
            catch (Exception e) {
                category.logT(300, location, "Exception occurred while executing impl0.dispatcher.R3StartupService.serviceStarted(...): " + e.getMessage());
            }
        }
    }

    private String determinePort(String portType, String portsPropValue) {
        int index = portsPropValue.indexOf(",Type:" + portType);
        if (index == -1) {
            return null;
        }
        return portsPropValue.substring(index - 5, index);
    }

    public void serviceNotStarted(String serviceName) {
    }

    public void beginServiceStop(String serviceName) {
    }

    public void serviceStopped(String serviceName) {
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("shell")) {
            this.shell = (ShellInterface)interfaceImpl;
            Command[] coms = new Command[]{new SendActiveCommand(this.r3socket), new SendInActiveCommand(this.r3socket), new SendInvalidateURLCommand(this.r3socket), new SendInvalidateEtagCommand(this.r3socket)};
            this.commandsID = this.shell.registerCommands(coms);
        }
    }

    public boolean setServiceProperty(String key, String value) {
        return false;
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        return false;
    }

    public void interfaceNotAvailable(String interfaceName) {
        if (interfaceName.equals("shell")) {
            this.shell = null;
            this.commandsID = -1;
        }
    }

    public void markForShutdown(long timeout) {
    }

    public void elementJoin(ClusterElement clusterElement) {
    }

    public void elementLoss(ClusterElement clusterElement) {
        HashMapIntMultiObject hashMapIntMultiObject = this.elements;
        synchronized (hashMapIntMultiObject) {
            int elementID = clusterElement.getClusterId();
            if (this.elements.seek(elementID)) {
                PIDManager.clearEntry(this.pidsFileName, elementID);
                --this.activeCount;
                if (this.inSoftShutdown) {
                    this.shutdownSynchronizer.remove(elementID);
                    this.elements.remove(elementID);
                    if (this.activeCount == 0) {
                        this.elements.notify();
                    }
                } else {
                    ((Process)this.elements.get(1)).destroy();
                    if (this.activeCount == 0 && !this.inactiveFlag) {
                        this.inactiveFlag = true;
                        this.sendInactive();
                    }
                    try {
                        this.startElement(elementID, (String)this.elements.get(0));
                    }
                    catch (Exception exc) {
                        StringWriter sw = new StringWriter();
                        PrintWriter out = new PrintWriter(sw);
                        exc.printStackTrace(out);
                        out.flush();
                        location.logT(500, "Error occurred while starting server  " + elementID + " due to " + sw.toString());
                    }
                }
            }
        }
    }

    public void elementStateChanged(ClusterElement element, byte oldState) {
        if (element.getState() != 3) {
            return;
        }
        HashMapIntMultiObject hashMapIntMultiObject = this.elements;
        synchronized (hashMapIntMultiObject) {
            if (this.elements.seek(element.getClusterId())) {
                ++this.activeCount;
                if (this.activeCount == this.count && this.inactiveFlag) {
                    this.inactiveFlag = false;
                    this.sendActive();
                }
            }
        }
    }

    public void receive(int clusterId, int messageType, byte[] body, int offset, int length) {
    }

    public MessageAnswer receiveWait(int clusterId, int messageType, byte[] body, int offset, int length) {
        return null;
    }

    public void noop() {
        location.logT(300, "NOOP command received from R/3 dispatcher.");
    }

    public void hardShutdown() {
        HashMapIntMultiObject hashMapIntMultiObject = this.elements;
        synchronized (hashMapIntMultiObject) {
            category.logT(300, location, "HARDSHUTDOWN command received from R/3 dispatcher.The cluster node processes will be killed by the J2EE dispatcher and the connection will be closed.");
            this.r3socket.close();
            this.killElements();
            System.exit(0);
        }
    }

    public void softShutdown() {
        HashMapIntMultiObject hashMapIntMultiObject = this.elements;
        synchronized (hashMapIntMultiObject) {
            if (this.inSoftShutdown) {
                return;
            }
            this.inSoftShutdown = true;
        }
        category.logT(300, location, "SOFTSHUTDOWN command received from R/3 dispatcher.The cluster nodes will be shut down by J2EE dispatcher by sending them SHUTDOWN message.");
        this.sendInactive();
        if (this.r3socket != null) {
            this.r3socket.close();
            this.r3socket = null;
        }
        this.stopElements();
        this.csc.getCoreContext().getCoreMonitor().shutDown();
    }

    private void stopElements() {
        HashMapIntMultiObject hashMapIntMultiObject = this.elements;
        synchronized (hashMapIntMultiObject) {
            MessageContext msgContext = this.csc.getClusterContext().getMessageContext();
            EnumerationInt keys = this.elements.keys();
            while (keys.hasMoreElements()) {
                int elementID = keys.nextElement();
                try {
                    msgContext.send(elementID, 0, SHUTDOWN_MSG, 0, 0);
                }
                catch (ClusterException ce) {
                    this.shutdownSynchronizer.add(elementID);
                }
            }
            try {
                this.elements.wait(this.shutdownTimeout * 500);
                if (this.activeCount == 0) {
                    return;
                }
            }
            catch (InterruptedException intr) {
                category.logT(300, location, "Exception occurred while executing impl0.dispatcher.R3StartupService.stopElements(): " + intr.getMessage());
                this.killElements();
            }
            keys = this.shutdownSynchronizer.elements();
            while (keys.hasMoreElements()) {
                try {
                    msgContext.send(keys.nextElement(), 0, SHUTDOWN_MSG, 0, 0);
                }
                catch (ClusterException ce) {
                    // empty catch block
                }
            }
            try {
                this.elements.wait(this.shutdownTimeout * 500);
            }
            catch (InterruptedException intr) {
                category.logT(300, location, "Exception occurred while executing impl0.dispatcher.R3StartupService.stopElements(): " + intr.getMessage());
            }
            this.killElements();
        }
    }

    private void killElements() {
        Enumeration elmnts = this.elements.elements(1);
        while (elmnts.hasMoreElements()) {
            ((Process)elmnts.nextElement()).destroy();
        }
    }

    private void startElement(int elementID, String elementDir) throws IOException, ConfigurationException, ConfigurationLockedException, InterruptedException {
        location.logT(300, "Starting server " + elementID + ", situated in " + elementDir + " directory.");
        String[] bootstrap = this.prepareBootstrapCommand();
        String[] command = this.prepareStartupCommand("ID" + elementID);
        String bootstrapCmd = bootstrap[0];
        String cmd = command[0];
        int i = 1;
        while (i < bootstrap.length) {
            bootstrapCmd = bootstrapCmd + " " + bootstrap[i];
            ++i;
        }
        int i2 = 1;
        while (i2 < command.length) {
            cmd = cmd + " " + command[i2];
            ++i2;
        }
        location.logT(300, "Executing : " + bootstrapCmd + Message.LINE_SEPARATOR);
        Process bootstrapProcess = null;
        bootstrapProcess = Runtime.getRuntime().exec(bootstrapCmd, null, new File(elementDir));
        new NullInputStreamThread(bootstrapProcess.getInputStream(), new PrintStream(new FileOutputStream(elementDir + File.separator + "bootstrap.log"))).start();
        bootstrapProcess.waitFor();
        location.logT(300, "Executing : " + cmd + Message.LINE_SEPARATOR);
        Process process = null;
        HashMapIntMultiObject hashMapIntMultiObject = this.elements;
        synchronized (hashMapIntMultiObject) {
            process = Runtime.getRuntime().exec(command, null, new File(elementDir));
            this.elementProps[0] = elementDir;
            this.elementProps[1] = process;
            this.elements.put(elementID, this.elementProps);
        }
        try {
            PrintStream stream = new PrintStream(new FileOutputStream(this.workingDir + File.separatorChar + elementID + "_output"), true);
            new NullInputStreamThread(process.getInputStream(), stream).start();
            stream = new PrintStream(new FileOutputStream(this.workingDir + File.separatorChar + elementID + "_error"), true);
            new NullInputStreamThread(process.getErrorStream(), stream).start();
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            e.printStackTrace(out);
            out.flush();
            location.logT(400, "Unable to create the stream files for server " + elementID + ". Exception is : " + sw.toString());
        }
    }

    private String[] prepareBootstrapCommand() throws ConfigurationException, ConfigurationLockedException {
        Properties bootstrapProps = new Properties();
        Configuration bootstrapConfig = this.cfgHandler.openConfiguration("cluster_data/bootstrap/jvm", 0);
        bootstrapProps = bootstrapConfig.getPropertySheetInterface().getProperties();
        String[] command = new String[]{"java", "-classpath " + bootstrapProps.getProperty("java.class.path"), bootstrapProps.getProperty("java.parameters"), bootstrapProps.getProperty("java.main.class"), bootstrapProps.getProperty("java.main.class.parameters")};
        this.cfgHandler.closeConfiguration(bootstrapConfig);
        return command;
    }

    private String[] prepareStartupCommand(String elementId) throws ConfigurationException, ConfigurationLockedException {
        Properties elementProps = new Properties();
        Configuration elementConfig = this.cfgHandler.openConfiguration("cluster_data/server/" + elementId + "/" + "element-info", 0);
        Configuration globalConfig = this.cfgHandler.openConfiguration("cluster_data/server/cfg/element-info", 0);
        Properties localProps = elementConfig.getPropertySheetInterface().getProperties();
        Properties globalProps = globalConfig.getPropertySheetInterface().getProperties();
        this.mergeProperties(elementProps, globalProps);
        this.mergeProperties(elementProps, localProps);
        StringTokenizer javaParams = new StringTokenizer(elementProps.getProperty("java.parameters").replace('\\', File.separatorChar).replace(';', File.pathSeparatorChar), " ");
        StringTokenizer bootParams = new StringTokenizer(elementProps.getProperty("java.main.class.parameters").replace('\\', File.separatorChar).replace(';', File.pathSeparatorChar), " ");
        int counter = 0;
        String[] command = new String[9 + javaParams.countTokens() + bootParams.countTokens()];
        command[counter++] = elementProps.getProperty("java.path").replace('\\', File.separatorChar).replace(';', File.pathSeparatorChar) + File.separator + "bin" + File.separator + "java";
        command[counter++] = "-classpath";
        command[counter++] = elementProps.getProperty("java.class.path").replace('\\', File.separatorChar).replace(';', File.pathSeparatorChar);
        command[counter++] = "-Xmx" + elementProps.getProperty("java.max.heap.size", "64") + "M";
        command[counter++] = "-Dmemory.manager=" + elementProps.getProperty("java.max.heap.size", "64") + "M";
        while (javaParams.hasMoreTokens()) {
            command[counter++] = javaParams.nextToken();
        }
        command[counter++] = "-DSAPMYNAME=" + SystemProperties.getProperty((String)"SAPMYNAME", (String)"");
        command[counter++] = "-DSAPPROFILE=" + SystemProperties.getProperty((String)"SAPPROFILE", (String)"");
        command[counter++] = "-Dredirect.input=true";
        command[counter++] = elementProps.getProperty("java.main.class");
        while (bootParams.hasMoreTokens()) {
            command[counter++] = bootParams.nextToken();
        }
        this.cfgHandler.closeConfiguration(elementConfig);
        this.cfgHandler.closeAllConfigurations();
        return command;
    }

    private void mergeProperties(Properties permanentProps, Properties newProps) {
        String mainClass;
        String heap;
        String classPath;
        String javaPath;
        String params;
        String javaParams = newProps.getProperty("java.parameters");
        if (javaParams != null) {
            permanentProps.setProperty("java.parameters", javaParams.replace('\\', File.separatorChar).replace(';', File.pathSeparatorChar));
        }
        if ((params = newProps.getProperty("java.main.class.parameters")) != null) {
            permanentProps.setProperty("java.main.class.parameters", params.replace('\\', File.separatorChar).replace(';', File.pathSeparatorChar));
        }
        if ((javaPath = newProps.getProperty("java.path")) != null) {
            permanentProps.setProperty("java.path", javaPath.replace('\\', File.separatorChar).replace(';', File.pathSeparatorChar));
        }
        if ((classPath = newProps.getProperty("java.class.path")) != null) {
            permanentProps.setProperty("java.class.path", classPath.replace('\\', File.separatorChar).replace(';', File.pathSeparatorChar));
        }
        if ((heap = newProps.getProperty("java.max.heap.size", "64")) != null) {
            permanentProps.setProperty("java.max.heap.size", heap);
        }
        if ((mainClass = newProps.getProperty("java.main.class")) != null) {
            permanentProps.setProperty("java.main.class", mainClass);
        }
    }

    private void initializeR3Socket(String connectionPort) {
        try {
            if (this.communicationSocket == null) {
                this.pid = PIDManager.getPid();
                location.logT(300, "Current process id is : " + this.pid);
                String address = this.currentElement.getAddress().getHostAddress();
                this.communicationSocket = new Socket(address, Integer.parseInt(connectionPort));
                category.logT(300, location, "Communication socket to R/3 dispatcher opened on localhost.");
            }
            this.r3socket = new SocketThread(this.communicationSocket, this);
            this.r3socket.start();
            if (this.http_port == -1 && !this.sendPid(this.pid)) {
                throw new Exception("IOException while sending PID to R/3 dispatcher!!!");
            }
            ServiceMonitor httpServiceMonitor = this.csc.getContainerContext().getSystemMonitor().getService("http");
            if (httpServiceMonitor != null) {
                String propValue = httpServiceMonitor.getProperty("Ports");
                this.sendHTTPPort(Integer.parseInt(this.determinePort("http", propValue)));
                this.sendHTTPSPort(Integer.parseInt(this.determinePort("ssl", propValue)));
            }
            this.sendLoadBalance(this.loadBalance);
        }
        catch (Exception e) {
            category.logT(600, location, "Couldn't complete initial communication!" + Message.LINE_SEPARATOR + "Exception is : " + e.getMessage());
            this.softShutdown();
        }
    }

    public boolean invalidateEtag(String name) {
        if (this.r3socket == null) {
            return false;
        }
        try {
            this.r3socket.sendMessage(Message.encodeInvalidateEtag(name));
        }
        catch (IOException exc) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            exc.printStackTrace(out);
            out.flush();
            location.logT(500, "Couldn't send INVALIDATE_ETAG to R/3 dispatcher. Exception is : " + sw.toString());
            return false;
        }
        location.logT(300, "J2EE Engine sent INVALIDATE_ETAG=" + name + " to R/3 dispatcher.");
        return true;
    }

    public boolean invalidateURL(String url) {
        if (this.r3socket == null) {
            return false;
        }
        try {
            this.r3socket.sendMessage(Message.encodeInvalidateURL(url));
        }
        catch (IOException exc) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            exc.printStackTrace(out);
            out.flush();
            location.logT(500, "Couldn't send INVALIDATE_URL to R/3 dispatcher. Exception is : " + sw.toString());
            return false;
        }
        location.logT(300, "J2EE Engine sent INVALIDATE_URL=" + url + " to R/3 dispatcher.");
        return true;
    }

    public boolean sendActive() {
        if (this.r3socket == null) {
            return false;
        }
        try {
            this.r3socket.sendMessage(Message.encodeActive());
        }
        catch (IOException exc) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            exc.printStackTrace(out);
            out.flush();
            location.logT(500, "Couldn't send ACTIVE to R/3 dispatcher. Exception is : " + sw.toString());
            return false;
        }
        location.logT(300, "J2EE Engine sent ACTIVE to R/3 dispatcher.");
        return true;
    }

    public boolean sendInactive() {
        if (this.r3socket == null) {
            return false;
        }
        try {
            this.r3socket.sendMessage(Message.encodeInactive());
        }
        catch (IOException exc) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            exc.printStackTrace(out);
            out.flush();
            location.logT(500, "Couldn't send INACTIVE to R/3 dispatcher. Exception is : " + sw.toString());
            return false;
        }
        location.logT(300, "J2EE Engine sent INACTIVE to R/3 dispatcher.");
        return true;
    }

    public boolean sendLoadBalance(int loadBalance) {
        if (this.r3socket == null) {
            return false;
        }
        try {
            this.r3socket.sendMessage(Message.encodeLB(loadBalance));
        }
        catch (IOException exc) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            exc.printStackTrace(out);
            out.flush();
            location.logT(500, "Couldn't send LB to R/3 dispatcher. Exception is : " + sw.toString());
            return false;
        }
        location.logT(300, "J2EE Engine sent LB=" + loadBalance + " to R/3 dispatcher.");
        return true;
    }

    public synchronized boolean sendHTTPPort(int port) {
        if (port == this.http_port) {
            return true;
        }
        this.http_port = port;
        if (this.r3socket == null) {
            return false;
        }
        try {
            this.r3socket.sendMessage(Message.encodeHTTPPort(port));
        }
        catch (IOException exc) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            exc.printStackTrace(out);
            out.flush();
            location.logT(500, "Couldn't send HTTP_PORT to R/3 dispatcher. Exception is : " + sw.toString());
            return false;
        }
        location.logT(300, "J2EE Engine sent HTTP_PORT=" + port + " to R/3 dispatcher.");
        return true;
    }

    public boolean sendHTTPSPort(int port) {
        if (port == this.https_port) {
            return true;
        }
        this.https_port = port;
        if (this.r3socket == null) {
            return false;
        }
        try {
            this.r3socket.sendMessage(Message.encodeHTTPSPort(port));
        }
        catch (IOException exc) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            exc.printStackTrace(out);
            out.flush();
            location.logT(500, "Couldn't send HTTPS_PORT to R/3 dispatcher. Exception is : " + sw.toString());
            return false;
        }
        location.logT(300, "J2EE Engine sent HTTPS_PORT=" + port + " to R/3 dispatcher.");
        return true;
    }

    private boolean sendPid(int pid) {
        if (this.r3socket == null) {
            return false;
        }
        try {
            this.r3socket.sendMessage(Message.encodePID(pid));
        }
        catch (IOException exc) {
            StringWriter sw = new StringWriter();
            PrintWriter out = new PrintWriter(sw);
            exc.printStackTrace(out);
            out.flush();
            location.logT(500, "Couldn't send PID to R/3 dispatcher. Exception is : " + sw.toString());
            return false;
        }
        location.logT(300, "J2EE Engine sent PID=" + pid + " to R/3 dispatcher.");
        return true;
    }

    public static Location getLog() {
        return location;
    }

    public static Category getCategory() {
        return category;
    }
}

