/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.r3startup.dispatcher;

import com.sap.engine.services.r3startup.Message;
import com.sap.engine.services.r3startup.SocketListener;
import com.sap.engine.services.r3startup.impl1.dispatcher.R3StartupService;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SocketThread
extends Thread {
    private SocketListener listener;
    private Socket socket;
    private BufferedInputStream in;
    private OutputStream out;
    private boolean running = true;
    private boolean sapStartup;

    public SocketThread(Socket socket, SocketListener listener) throws IOException {
        this.listener = listener;
        try {
            this.socket = socket;
            this.in = new BufferedInputStream(socket.getInputStream());
            this.out = socket.getOutputStream();
            String sapStartupValue = System.getProperty("SAPSTARTUP");
            if (sapStartupValue == null) {
                sapStartupValue = System.getProperty("SAPSTART");
            }
            this.sapStartup = sapStartupValue != null && sapStartupValue.equals("1");
        }
        catch (IOException e) {
            if (!this.sapStartup) {
                com.sap.engine.services.r3startup.impl0.dispatcher.R3StartupService.getCategory().logT(500, com.sap.engine.services.r3startup.impl0.dispatcher.R3StartupService.getLog(), "Error occurred while trying to connect to R/3 dispatcher. The communication streams could not be created. Please check if the R/3 dispatcher is running.");
            } else {
                R3StartupService.getCategory().logT(500, R3StartupService.getLog(), "Error occurred while trying to connect to R/3 dispatcher. The communication streams could not be created. Please check if the R/3 dispatcher is running.");
            }
            throw e;
        }
    }

    public void sendMessage(byte[] message) throws IOException {
        this.out.write(message, 0, message.length);
        this.out.flush();
    }

    public void sendMessage(String message) throws IOException {
        this.sendMessage(Message.encode(message));
    }

    public synchronized void close() {
        this.running = false;
    }

    private byte[] read(InputStream in, int len) throws Exception {
        byte[] bytes = new byte[len];
        int index = 0;
        while (index < bytes.length) {
            int count = in.read(bytes, index, bytes.length - index);
            if (count == -1) {
                return null;
            }
            index += count;
        }
        return bytes;
    }

    public void run() {
        block12: {
            try {
                while (this.running) {
                    byte[] b4 = this.read(this.in, 4);
                    if (b4 == null) {
                        throw new Exception("Bad message header format! Socket closed!");
                    }
                    int length = Message.decodeHeader(b4);
                    byte[] messageBytes = this.read(this.in, length);
                    if (messageBytes == null) {
                        throw new Exception("Bad message! Socket closed!");
                    }
                    String message = Message.decodeUTF8(messageBytes);
                    if (message.equalsIgnoreCase("NOOP")) {
                        this.listener.noop();
                        continue;
                    }
                    if (message.equalsIgnoreCase("HARDSHUTDOWN")) {
                        this.listener.hardShutdown();
                        continue;
                    }
                    if (!message.equalsIgnoreCase("SOFTSHUTDOWN")) continue;
                    this.listener.softShutdown();
                }
            }
            catch (Exception e) {
                if (!this.sapStartup) {
                    com.sap.engine.services.r3startup.impl0.dispatcher.R3StartupService.getCategory().logT(500, com.sap.engine.services.r3startup.impl0.dispatcher.R3StartupService.getLog(), "Error occurred while reading message from R/3 dispatcher. The J2EE engine will be shut down. Please check if the R/3 dispatcher is running and then restart the J2EE engine.");
                } else {
                    R3StartupService.getCategory().logT(500, R3StartupService.getLog(), "Error occurred while reading message from R/3 dispatcher. The J2EE engine will be shut down. Please check if the R/3 dispatcher is running and then restart the J2EE engine.");
                }
                this.listener.softShutdown();
                try {
                    this.in.close();
                    this.out.close();
                    this.socket.close();
                }
                catch (IOException ioexc) {
                    if (!this.sapStartup) {
                        com.sap.engine.services.r3startup.impl0.dispatcher.R3StartupService.getCategory().logT(500, com.sap.engine.services.r3startup.impl0.dispatcher.R3StartupService.getLog(), "Error occurred while closing the connection to R/3 dispatcher during the shutdown of J2EE engine. Please kill the J2EE dispatcher and server node processes manually if necessary.");
                        break block12;
                    }
                    R3StartupService.getCategory().logT(500, R3StartupService.getLog(), "Error occurred while closing the connection to R/3 dispatcher during the shutdown of J2EE engine. Please kill the J2EE dispatcher and server node processes manually if necessary.");
                }
            }
        }
    }
}

