/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.r3startup;

import com.sap.engine.lib.io.MemoryRandomAccessFile;
import com.sap.engine.services.r3startup.Message;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;

public final class PIDManager {
    public static final String PID_DELIMITER = " : ";
    private static int pid = -1;
    private static Location location = null;
    private static Category category = null;
    static /* synthetic */ Class class$com$sap$engine$services$r3startup$PIDManager;

    public static int getPid() {
        if (pid == -1) {
            Thread pidThread = new Thread(){

                public void run() {
                    pid = PIDManager.getNativePid();
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        try {
                            this.notify();
                            this.wait();
                        }
                        catch (Exception e) {
                            category.logT(300, location, "Exception occurred while executing PIDManager.getPid(): " + e.getMessage());
                        }
                    }
                }
            };
            pidThread.setDaemon(true);
            Thread thread = pidThread;
            synchronized (thread) {
                pidThread.start();
                try {
                    pidThread.wait();
                }
                catch (Exception e) {
                    category.logT(300, location, "Exception occurred while executing PIDManager.getPid(): " + e.getMessage());
                }
            }
        }
        return pid;
    }

    private static native int getNativePid();

    public static native boolean killPid(int var0);

    public static boolean killEntry(String entry) {
        StringTokenizer tokens = new StringTokenizer(entry, PID_DELIMITER);
        tokens.nextToken();
        return PIDManager.killPid(Integer.parseInt(tokens.nextToken()));
    }

    public static void logEntry(RandomAccessFile file, int cid, int pid) throws IOException {
        file.seek(file.length());
        file.writeBytes(cid + PID_DELIMITER + pid + Message.LINE_SEPARATOR);
    }

    public static void clearEntry(String file, int cid) {
        try {
            MemoryRandomAccessFile oldRAF = new MemoryRandomAccessFile(file, "r");
            RandomAccessFile newRAF = new RandomAccessFile(file, "rw");
            newRAF.setLength(0L);
            String entry = null;
            while ((entry = oldRAF.readLine()) != null) {
                if (Integer.parseInt(new StringTokenizer(entry, PID_DELIMITER).nextToken()) == cid) continue;
                newRAF.writeBytes(entry + Message.LINE_SEPARATOR);
            }
            oldRAF.close();
            newRAF.close();
        }
        catch (IOException exc) {
            category.logT(300, location, "Exception occurred while executing PIDManager.clearEntry(...): " + exc.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        System.loadLibrary("pidmanager");
        location = Location.getLocation((String)(class$com$sap$engine$services$r3startup$PIDManager == null ? (class$com$sap$engine$services$r3startup$PIDManager = PIDManager.class$("com.sap.engine.services.r3startup.PIDManager")) : class$com$sap$engine$services$r3startup$PIDManager).getName());
        category = Category.SYS_SERVER;
    }
}

