/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.r3startup;

public class Message {
    public static final String HTTP_PORT = "HTTP_PORT";
    public static final String HTTPS_PORT = "HTTPS_PORT";
    public static final String LB = "LB";
    public static final String PID = "PID";
    public static final String ACTIVE = "ACTIVE";
    public static final String INACTIVE = "INACTIVE";
    public static final String NOOP = "NOOP";
    public static final String HARDSHUTDOWN = "HARDSHUTDOWN";
    public static final String SOFTSHUTDOWN = "SOFTSHUTDOWN";
    public static final String INVALIDATE_ETAG = "INVALIDATE_ETAG";
    public static final String INVALIDATE_URL = "INVALIDATE_URL";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static int decodeHeader(byte[] bytes) {
        int length = 0;
        length += bytes[0] & 0x7F;
        length <<= 8;
        length += bytes[1] < 0 ? bytes[1] + 256 : bytes[1];
        length <<= 8;
        length += bytes[2] < 0 ? bytes[2] + 256 : bytes[2];
        length <<= 8;
        return length += bytes[3] < 0 ? bytes[3] + 256 : bytes[3];
    }

    public static String decode(byte[] bytes) {
        return Message.decodeUTF8(bytes, 4);
    }

    public static byte[] encode(String message) {
        int length = 0;
        int i = 0;
        while (i < message.length()) {
            length = message.charAt(i) == '\u0000' ? (length += 2) : (message.charAt(i) < '\u0080' ? ++length : (message.charAt(i) < '\u0800' ? (length += 2) : (length += 3)));
            ++i;
        }
        byte[] result = new byte[length + 4];
        result[3] = (byte)length;
        result[2] = (byte)(length >>= 8);
        result[1] = (byte)(length >>= 8);
        result[0] = (byte)(length >>= 8);
        int offset = 4;
        int i2 = 0;
        while (i2 < message.length()) {
            if (message.charAt(i2) == '\u0000') {
                result[offset++] = -64;
                result[offset++] = -128;
            } else if (message.charAt(i2) < '\u0080') {
                result[offset++] = (byte)message.charAt(i2);
            } else if (message.charAt(i2) < '\u0800') {
                result[offset++] = (byte)(192 + (message.charAt(i2) >> 6));
                result[offset++] = (byte)(128 + (message.charAt(i2) & 0x3F));
            } else {
                result[offset++] = (byte)(224 + (message.charAt(i2) >> 12));
                result[offset++] = (byte)(128 + (message.charAt(i2) >> 6 & 0x3F));
                result[offset++] = (byte)(128 + (message.charAt(i2) & 0x3F));
            }
            ++i2;
        }
        return result;
    }

    public static byte[] encodeHTTPPort(int port) {
        return Message.encode("HTTP_PORT=" + port);
    }

    public static byte[] encodeHTTPSPort(int port) {
        return Message.encode("HTTPS_PORT=" + port);
    }

    public static byte[] encodeLB(int balance) {
        return Message.encode("LB=" + balance);
    }

    public static byte[] encodePID(int processId) {
        return Message.encode("PID=" + processId);
    }

    public static byte[] encodeActive() {
        return Message.encode(ACTIVE);
    }

    public static byte[] encodeInactive() {
        return Message.encode(INACTIVE);
    }

    public static byte[] encodeNoop() {
        return Message.encode(NOOP);
    }

    public static byte[] encodeInvalidateEtag(String name) {
        return Message.encode("INVALIDATE_ETAG=" + name);
    }

    public static byte[] encodeInvalidateURL(String url) {
        return Message.encode("INVALIDATE_URL=" + url);
    }

    public static String decodeUTF8(byte[] bytes) {
        return Message.decodeUTF8(bytes, 0);
    }

    private static String decodeUTF8(byte[] bytes, int offset) {
        String result = new String();
        while (offset < bytes.length) {
            int c;
            if ((bytes[offset] & 0x80) == 0) {
                result = result + (char)bytes[offset++];
                continue;
            }
            if ((bytes[offset] & 0xE0) == 192) {
                c = bytes[offset++] & 0x1F;
                c <<= 6;
                result = result + (char)(c += bytes[offset++] & 0x3F);
                continue;
            }
            c = bytes[offset++] & 0xF;
            c <<= 6;
            c += bytes[offset++] & 0x3F;
            c <<= 6;
            result = result + (char)(c += bytes[offset++] & 0x3F);
        }
        return result;
    }

    public static String decodeUTF8(byte[] bytes, int offset, int length) {
        String result = new String();
        length += offset;
        while (offset < length) {
            int c;
            if ((bytes[offset] & 0x80) == 0) {
                result = result + (char)bytes[offset++];
                continue;
            }
            if ((bytes[offset] & 0xE0) == 192) {
                c = bytes[offset++] & 0x1F;
                c <<= 6;
                result = result + (char)(c += bytes[offset++] & 0x3F);
                continue;
            }
            c = bytes[offset++] & 0xF;
            c <<= 6;
            c += bytes[offset++] & 0x3F;
            c <<= 6;
            result = result + (char)(c += bytes[offset++] & 0x3F);
        }
        return result;
    }
}

