/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt.pool;

import com.sap.engine.lib.xsl.xslt.XSLException;
import com.sap.engine.lib.xsl.xslt.XSLVarEval;

public final class XSLVarEvalPool {
    private int initialSize;
    private int resizeStep = 100;
    private int pos;
    private XSLVarEval[] arrayOfObjects;

    public int getUsed() {
        return this.arrayOfObjects.length - this.pos - 1;
    }

    public int getPos() {
        return this.pos;
    }

    public void releasePool() {
        this.pos = this.arrayOfObjects.length - 1;
    }

    public XSLVarEvalPool(int initSize, int step) throws XSLException {
        if (step < 1 || initSize < 1) {
            throw new IllegalArgumentException("Wrong value of initialSize or resizeStep parameter");
        }
        this.initialSize = initSize;
        this.resizeStep = step;
        this.arrayOfObjects = new XSLVarEval[this.initialSize];
        for (int i = 0; i < this.initialSize; ++i) {
            this.arrayOfObjects[i] = new XSLVarEval();
        }
        this.pos = this.initialSize - 1;
    }

    public XSLVarEval getObject() throws XSLException {
        if (this.pos < 0) {
            this.autoResize();
        }
        return this.arrayOfObjects[this.pos--];
    }

    public void releaseObject(XSLVarEval obj) {
        if (this.pos < this.arrayOfObjects.length - 1) {
            ++this.pos;
            this.arrayOfObjects[this.pos] = obj;
        }
    }

    public void setResizeStep(int step) {
        if (step < 1) {
            throw new IllegalArgumentException("Wrong value of resizeStep parameter");
        }
        this.resizeStep = step;
    }

    public int getResizeStep() {
        return this.resizeStep;
    }

    public void setInitialSize(int initSize) {
        if (initSize < 1) {
            throw new IllegalArgumentException("Wrong value of initSize parameter");
        }
        this.initialSize = initSize;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void release() {
        for (int i = 0; i < this.pos; ++i) {
            this.arrayOfObjects[i] = null;
        }
    }

    public void forceShrink() throws XSLException {
        int usedElements = this.arrayOfObjects.length - this.pos - 1;
        if (usedElements >= this.initialSize) {
            if (this.pos >= 0) {
                this.arrayOfObjects = new XSLVarEval[usedElements];
                this.pos = -1;
            }
        } else if (this.arrayOfObjects.length != this.initialSize) {
            XSLVarEval[] tempArr = new XSLVarEval[this.initialSize];
            int newPos = this.initialSize - usedElements - 1;
            if (newPos <= this.pos) {
                System.arraycopy(this.arrayOfObjects, 0, tempArr, 0, newPos + 1);
            } else {
                if (this.pos >= 0) {
                    System.arraycopy(this.arrayOfObjects, 0, tempArr, 0, this.pos + 1);
                }
                for (int i = this.pos + 1; i < newPos; ++i) {
                    tempArr[i] = new XSLVarEval();
                }
            }
            this.arrayOfObjects = tempArr;
            this.pos = newPos;
        }
    }

    private void autoResize() throws XSLException {
        int i;
        XSLVarEval[] tempArr = new XSLVarEval[this.arrayOfObjects.length + this.resizeStep];
        for (i = 0; i < this.resizeStep; ++i) {
            tempArr[i] = new XSLVarEval();
        }
        for (i = 0; i < this.arrayOfObjects.length; ++i) {
            tempArr[i + this.resizeStep] = this.arrayOfObjects[i];
        }
        this.arrayOfObjects = tempArr;
        this.pos = this.resizeStep - 1;
        this.resizeStep *= 2;
    }

    public void check() throws Exception {
        for (int i = 0; i < this.arrayOfObjects.length; ++i) {
            for (int j = i + 1; j < this.arrayOfObjects.length; ++j) {
                if (this.arrayOfObjects[i] != this.arrayOfObjects[j]) continue;
                throw new Exception("they are equal:" + i + "," + j + " " + this.arrayOfObjects[i] + ", " + this.arrayOfObjects[j]);
            }
        }
    }

    public void releaseAllObjects() {
        this.pos = this.arrayOfObjects.length - 1;
    }
}

