/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt.output;

import com.sap.engine.lib.xml.parser.handlers.EncodingHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Encoding;
import com.sap.engine.lib.xsl.xpath.StaticInteger;
import com.sap.engine.lib.xsl.xslt.output.DocHandlerSerializer;
import com.sap.engine.lib.xsl.xslt.output.OutputException;
import com.sap.engine.lib.xsl.xslt.output.OutputIOException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;

public final class Encoder {
    protected DocHandlerSerializer owner = null;
    protected static final String LINE_SEPARATOR = "\n";
    protected Writer writer = null;
    protected OutputStream stream = null;
    protected static final String CDATA_BEGIN = "<![CDATA[";
    protected static final String CDATA_END = "]]>";
    protected static final String CDATA_END_BEGIN = "]]><![CDATA[";
    protected boolean escapingDisabled = false;
    private byte[] bufwritebyte = new byte[20000];
    private char[] bufwritechar = new char[20000];
    private byte[] convarr = new byte[10];
    private int bufwriteidx = 0;
    private EncodingHandler encodingHandler = new EncodingHandler();
    private Encoding encoding = this.encodingHandler.getEncoding(new CharArray("UTF-8"));
    private CharArray chTempOutRef = new CharArray();
    private static final String[] CH_TO_ENT_TEXT = new String[256];

    private void init() {
    }

    protected void init(Writer writer, String enc) throws OutputException {
        this.init();
        this.bufwriteidx = 0;
        this.setWriter(writer);
        this.encoding = this.encodingHandler.getEncoding(new CharArray(enc));
        if (this.encoding == null) {
            this.encoding = this.encodingHandler.getEncoding(EncodingHandler.UTF8);
        }
    }

    public void init(OutputStream outputStream, String enc) {
        this.init();
        this.bufwriteidx = 0;
        this.stream = outputStream;
        if (enc != null) {
            this.encoding = this.encodingHandler.getEncoding(new CharArray(enc));
        }
        if (this.encoding == null) {
            this.encoding = this.encodingHandler.getEncoding(EncodingHandler.UTF8);
        }
    }

    public void init(OutputStream out) {
        this.init(out, null);
    }

    protected void setWriter(Writer writer) {
        this.writer = writer;
    }

    protected String getEncodingName() {
        return this.encoding.getName().toString();
    }

    private void bufferWrite(int b) throws IOException {
        if (this.bufwriteidx == this.bufwritebyte.length) {
            if (this.stream != null) {
                this.stream.write(this.bufwritebyte);
            } else {
                this.writer.write(this.bufwritechar);
            }
            this.bufwriteidx = 0;
        }
        if (this.stream != null) {
            this.bufwritebyte[this.bufwriteidx++] = (byte)b;
        } else {
            this.bufwritechar[this.bufwriteidx++] = (char)b;
        }
    }

    private void bufferWriteStream(int b) throws IOException {
        if (this.bufwriteidx == this.bufwritebyte.length) {
            this.stream.write(this.bufwritebyte);
            this.bufwriteidx = 0;
        }
        this.bufwritebyte[this.bufwriteidx++] = (byte)b;
    }

    public void out(char ch) throws OutputException {
        try {
            this.bufferWrite((byte)ch);
        }
        catch (IOException e) {
            throw new OutputIOException(e);
        }
    }

    public Encoder enableOutputEscaping() {
        this.escapingDisabled = false;
        return this;
    }

    public Encoder disableOutputEscaping() {
        this.escapingDisabled = true;
        return this;
    }

    public Encoder out(char[] ch, int start, int length) throws OutputException {
        for (int i = 0; i < length; ++i) {
            this.makeDefaultEncodingCheck(ch[start + i]);
        }
        return this;
    }

    public Encoder out(String s) throws OutputException {
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            this.makeDefaultEncodingCheck(s.charAt(i));
        }
        return this;
    }

    private void makeDefaultEncodingCheck(char ch) throws OutputException {
        try {
            if (this.stream != null) {
                this.makeDefaultEncodingCheckStream(ch);
            } else {
                this.bufferWrite(ch);
            }
        }
        catch (Exception e) {
            throw new OutputException(e);
        }
    }

    private void makeDefaultEncodingCheckStream(char ch) throws OutputException {
        block9: {
            try {
                if (ch < '\u0080') {
                    this.bufferWriteStream((byte)ch);
                    break block9;
                }
                int len = this.encoding.reverseEncode(this.convarr, ch);
                if (len == -1) {
                    this.outCharRefDec(ch);
                    break block9;
                }
                block1 : switch (len) {
                    case 1: {
                        this.bufferWrite(this.convarr[0]);
                        break block9;
                    }
                    case 2: {
                        this.bufferWrite(this.convarr[0]);
                        this.bufferWrite(this.convarr[1]);
                        break block9;
                    }
                    default: {
                        int i = 0;
                        while (i < len) {
                            this.bufferWrite(this.convarr[i]);
                            ++i;
                            break block1;
                        }
                        break block9;
                    }
                }
                {
                    continue;
                    break;
                }
            }
            catch (IOException e) {
                throw new OutputException(e);
            }
        }
    }

    public void outEscaped(char ch) throws OutputException {
        if (this.escapingDisabled) {
            this.makeDefaultEncodingCheck(ch);
            return;
        }
        if (ch < '\u00ff' && CH_TO_ENT_TEXT[ch] != null) {
            this.out(CH_TO_ENT_TEXT[ch]);
            return;
        }
        this.makeDefaultEncodingCheck(ch);
    }

    public Encoder outEscaped(CharArray ca) throws OutputException {
        return this.outEscaped(ca.getData(), ca.getOffset(), ca.length());
    }

    public Encoder outEscaped(String s) throws OutputException {
        if (this.escapingDisabled) {
            return this.out(s);
        }
        if (this.stream != null) {
            for (int i = 0; i < s.length(); ++i) {
                char ch = s.charAt(i);
                try {
                    if (CH_TO_ENT_TEXT[ch] != null) {
                        this.out(CH_TO_ENT_TEXT[ch]);
                        continue;
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    // empty catch block
                }
                this.makeDefaultEncodingCheckStream(ch);
            }
            return this;
        }
        for (int i = 0; i < s.length(); ++i) {
            this.outEscaped(s.charAt(i));
        }
        return this;
    }

    public void outAttribute(String attrib, char delimiter) throws OutputException {
        int len = attrib.length();
        for (int i = 0; i < len; ++i) {
            char ch = attrib.charAt(i);
            this.outAttribChar(ch, delimiter);
        }
    }

    private void outAttribChar(char ch, char delimiter) throws OutputException {
        switch (ch) {
            case '\'': {
                if (delimiter == '\'') {
                    this.out("&apos;");
                    break;
                }
                this.out('\'');
                break;
            }
            case '\"': {
                if (delimiter == '\"') {
                    this.out("&quot;");
                    break;
                }
                this.out('\"');
                break;
            }
            case '&': {
                this.out("&amp;");
                break;
            }
            case '<': {
                this.out("&lt;");
                break;
            }
            case '>': {
                this.out(">");
                break;
            }
            case '\t': {
                this.out("&#x9;");
                break;
            }
            case '\n': {
                this.out("&#xA;");
                break;
            }
            case '\r': {
                this.out("&#xD;");
                break;
            }
            default: {
                this.makeDefaultEncodingCheck(ch);
            }
        }
    }

    public Encoder outAttribute(CharArray ca, char delimiter) throws OutputException {
        char[] data = ca.getData();
        int offset = ca.getOffset();
        int end = offset + ca.length();
        for (int i = offset; i < end; ++i) {
            char ch = data[i];
            this.outAttribChar(ch, delimiter);
        }
        return this;
    }

    public Encoder outEscaped(char[] ch, int start, int length) throws OutputException {
        if (this.escapingDisabled) {
            return this.out(ch, start, length);
        }
        int end = start + length;
        for (int i = start; i < end; ++i) {
            this.outEscaped(ch[i]);
        }
        return this;
    }

    public Encoder out(CharArray ca) throws OutputException {
        return this.out(ca.getData(), ca.getOffset(), ca.length());
    }

    public Encoder outDirect(char[] ch, int start, int len) throws OutputException {
        try {
            for (int i = start; i < len; ++i) {
                this.bufferWrite((byte)ch[i]);
            }
            return this;
        }
        catch (Exception e) {
            throw new OutputException(e);
        }
    }

    public Encoder outDirect(CharArray ca) throws OutputException {
        return this.outDirect(ca.getData(), ca.getOffset(), ca.getSize());
    }

    protected Encoder outCDATA(char[] ch, int start, int length) throws OutputException {
        this.out(CDATA_BEGIN);
        if (length < 3) {
            this.out(ch, start, length);
        } else {
            char prev2 = ch[start];
            char prev = ch[start + 1];
            this.outEscaped(prev2);
            this.outEscaped(prev);
            int end = start + length;
            for (int i = start + 2; i < end; ++i) {
                char curr = ch[i];
                if (prev2 == ']' && prev == ']' && curr == '>') {
                    this.out(CDATA_END_BEGIN);
                }
                this.outEscaped(curr);
                prev2 = prev;
                prev = curr;
            }
        }
        this.out(CDATA_END);
        return this;
    }

    protected Encoder outln() throws OutputException {
        return this.out(LINE_SEPARATOR);
    }

    protected Encoder outSpace(int x) throws OutputException {
        for (int i = 0; i < x; ++i) {
            this.out(' ');
        }
        return this;
    }

    protected Encoder outCharRefHex(char ch) throws OutputException {
        this.out("&#x");
        this.out(Integer.toHexString(ch));
        this.out(';');
        return this;
    }

    protected Encoder outCharRefDec(char ch) throws OutputException {
        this.out("&#");
        this.out(StaticInteger.intToCharArray(ch, this.chTempOutRef));
        this.out(';');
        return this;
    }

    protected Encoder outHTMLAttribute(CharArray s, boolean uriflag) throws OutputException {
        char[] data = s.getData();
        int size = s.length();
        int off = s.getOffset();
        int totsize = size + off;
        for (int i = off; i < totsize; ++i) {
            boolean showEscaped = true;
            if (data[i] == '<') {
                showEscaped = false;
            }
            if (i + 1 < totsize && data[i] == '&' && data[i + 1] == '{') {
                showEscaped = false;
            }
            if (showEscaped) {
                if (uriflag && data[i] > '\u0080') {
                    this.outCharRefHex(data[i]);
                    continue;
                }
                if (uriflag && data[i] == ' ') {
                    this.out("%20");
                    continue;
                }
                this.outEscaped(data[i]);
                continue;
            }
            this.out(data[i]);
        }
        return this;
    }

    public Encoder flush() throws OutputIOException {
        try {
            if (this.stream != null) {
                this.stream.write(this.bufwritebyte, 0, this.bufwriteidx);
            } else {
                this.writer.write(this.bufwritechar, 0, this.bufwriteidx);
                this.writer.flush();
            }
            this.bufwriteidx = 0;
        }
        catch (IOException e) {
            throw new OutputIOException(e);
        }
        return this;
    }

    public void close() throws OutputIOException {
        try {
            this.flush();
            if (this.stream != null) {
                this.stream.close();
            } else if (this.writer != null) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new OutputIOException(e);
        }
    }

    protected void setOwner(DocHandlerSerializer owner) {
        this.owner = owner;
    }

    protected DocHandlerSerializer getOwner() {
        return this.owner;
    }

    protected boolean isEscapingEnabled() {
        return !this.escapingDisabled;
    }

    protected void setEscaping(boolean b) {
        this.escapingDisabled = !b;
    }

    static {
        Encoder.CH_TO_ENT_TEXT[13] = "&#xD;";
        Encoder.CH_TO_ENT_TEXT[38] = "&amp;";
        Encoder.CH_TO_ENT_TEXT[60] = "&lt;";
        Encoder.CH_TO_ENT_TEXT[62] = "&gt;";
    }
}

