/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.handlers.EncodingHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Encoding;
import com.sap.engine.lib.xsl.xslt.InternalAttribute;
import com.sap.engine.lib.xsl.xslt.InternalAttributeList;
import com.sap.engine.lib.xsl.xslt.XSLException;
import com.sap.engine.lib.xsl.xslt.XSLOutputException;
import com.sap.engine.lib.xsl.xslt.XSLOutputNode;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Stack;
import org.xml.sax.ContentHandler;

public final class XSLOutputProcessor {
    static final byte TEXT_OUTPUT = 1;
    static final byte HTML_OUTPUT = 2;
    static final byte XML_OUTPUT = 3;
    public static final byte IO_ERROR = 0;
    public static final byte PROCESSING_ALREADY_STARTED_ERROR = 1;
    public static final byte NO_OUTPUTSTREAM_SPECIFIED_ERROR = 2;
    public static final byte INVALID_XML_ERROR = 3;
    private byte outputmode = (byte)3;
    private boolean dochasstarted = false;
    private boolean hasprefixmapping = false;
    private boolean emptyel = false;
    private boolean firstelement = false;
    private OutputStream xsloutstream = null;
    private Writer xslwriter = null;
    private ContentHandler xslhandler = null;
    private String version = "1.0";
    private boolean bProcessAttributeValueTemplate = false;
    private CharArray chAttributeValueProcessing = new CharArray(100);
    private static final CharArray caEmpty = new CharArray();
    private static final CharArray OT = new CharArray("<");
    private static final CharArray SP = new CharArray(" ");
    private static final CharArray EQ = new CharArray("=");
    private static final CharArray ETN = new CharArray(">\n");
    private static final CharArray ETS = new CharArray("/>");
    private static final CharArray CH_ENDTAG_STD = new CharArray("</");
    private static final CharArray CH_GT_NL = new CharArray(">\n");
    private static final CharArray CH_COMMENT_START = new CharArray("<!--");
    private static final CharArray CH_PISTART = new CharArray("<?");
    private static final CharArray CH_PIEND_NL = new CharArray("?>\n");
    private static final CharArray CH_COMMENT_END = new CharArray("-->");
    private static final CharArray CH_PI_DISABLE_OUTPUT_ESCAPING = new CharArray("javax.xml.transform.disable-output-escaping");
    private static final CharArray CH_PI_ENABLE_OUTPUT_ESCAPING = new CharArray("javax.xml.transform.enable-output-escaping");
    private static final CharArray CH_SPACE = new CharArray(" ");
    private static final CharArray chHtmlMetaAfterHead = new CharArray("<meta content='text/html; charset=utf-8' http-equiv='Content-Type'/>");
    private CharArray normalizeCarr = new CharArray(100);
    private CharArray attcarr = new CharArray(100);
    private DocHandler dochandler = null;
    private Stack attributeValueChStack = new Stack();
    private EncodingHandler encodingHandler = new EncodingHandler();
    private Encoding encoding = this.encodingHandler.getEncoding(new CharArray("utf-8"));
    private boolean bDisableEscapingOverload = false;
    private Stack startedElementStack = new Stack();
    private Stack emptyelStack = new Stack();
    private byte[] bufwrite = new byte[2000];
    private int bufwriteidx = 0;
    private byte[] convarr = new byte[10];
    private boolean bStartedElement = false;
    private InternalAttributeList iattList = new InternalAttributeList();

    public void reuse() {
        this.bufwriteidx = 0;
        this.xsloutstream = null;
        this.xslwriter = null;
        this.xslhandler = null;
        this.dochasstarted = false;
        this.hasprefixmapping = false;
        this.emptyel = false;
        this.firstelement = false;
        this.xsloutstream = null;
        this.xslwriter = null;
        this.xslhandler = null;
        this.bProcessAttributeValueTemplate = false;
        this.chAttributeValueProcessing.clear();
        this.attributeValueChStack.clear();
    }

    public void clearAttributeValueProcessing() {
        this.bProcessAttributeValueTemplate = false;
        this.startedElementStack.clear();
        this.emptyelStack.clear();
        this.bStartedElement = false;
        this.emptyel = false;
    }

    public void setDocHandler(DocHandler dochandler) {
        this.dochandler = dochandler;
    }

    public void setByteStream(OutputStream stream) throws XSLOutputException {
        if (this.dochasstarted) {
            throw new XSLOutputException(1);
        }
        this.xsloutstream = stream;
    }

    public void setCharacterStream(Writer writer) throws XSLOutputException {
        if (this.dochasstarted) {
            throw new XSLOutputException(1);
        }
        this.xslwriter = writer;
    }

    public void setContentHandler(ContentHandler handler) throws XSLOutputException {
        if (this.dochasstarted) {
            throw new XSLOutputException(1);
        }
        this.xslhandler = handler;
    }

    public void setOutputMode(XSLOutputNode node) {
        String mode = node.getMethod();
        if (mode.equals("xml")) {
            this.outputmode = (byte)3;
        } else if (mode.equals("text")) {
            this.outputmode = 1;
        } else if (mode.equals("html")) {
            this.outputmode = (byte)2;
        }
        this.version = node.getVersion();
        if (this.version == null) {
            this.version = "1.0";
        }
        this.encoding = this.encodingHandler.getEncoding(new CharArray(node.getEncoding()));
        if (this.encoding == null) {
            this.encoding = this.encodingHandler.getEncoding(new CharArray("utf-8"));
        }
    }

    private void bufferWrite(byte b) throws IOException {
        if (this.bufwriteidx == this.bufwrite.length) {
            this.xsloutstream.write(this.bufwrite);
            this.bufwriteidx = 0;
        }
        this.bufwrite[this.bufwriteidx++] = b;
    }

    private void dowrite(CharArray w) throws XSLOutputException {
        try {
            if (this.bProcessAttributeValueTemplate) {
                this.chAttributeValueProcessing.append(w);
            } else {
                if (this.xsloutstream != null) {
                    int o = w.getOffset();
                    int l = w.length() + o;
                    char[] ddd = w.getData();
                    for (int i = o; i < l; ++i) {
                        this.bufferWrite((byte)ddd[i]);
                    }
                }
                if (this.xslwriter != null) {
                    this.xslwriter.write(w.getData(), w.getOffset(), w.getSize());
                }
            }
        }
        catch (IOException e) {
            throw new XSLOutputException(0, e.toString());
        }
    }

    private void dowrite(char w) throws XSLOutputException {
        try {
            if (this.bProcessAttributeValueTemplate) {
                this.chAttributeValueProcessing.append(w);
            } else {
                if (this.xsloutstream != null) {
                    this.bufferWrite((byte)w);
                }
                if (this.xslwriter != null) {
                    this.xslwriter.write(w);
                }
            }
        }
        catch (IOException e) {
            throw new XSLOutputException(0, e.toString());
        }
    }

    public void startAttributeValueProcessing(CharArray charr) {
        if (charr != null) {
            this.bProcessAttributeValueTemplate = true;
            charr.clear();
            this.chAttributeValueProcessing = charr;
            this.attributeValueChStack.push(charr);
        }
        this.startedElementStack.push(this.bStartedElement ? Boolean.TRUE : Boolean.FALSE);
        this.emptyelStack.push(this.emptyel ? Boolean.TRUE : Boolean.FALSE);
        this.bStartedElement = false;
        this.emptyel = false;
    }

    public void stopAttributeValueProcessing() {
        this.stopAttributeValueProcessing(true);
    }

    public void stopAttributeValueProcessing(boolean chstack) {
        if (chstack) {
            this.attributeValueChStack.pop();
            if (!this.attributeValueChStack.empty()) {
                this.chAttributeValueProcessing = (CharArray)this.attributeValueChStack.peek();
            } else {
                this.bProcessAttributeValueTemplate = false;
            }
        }
        this.bStartedElement = (Boolean)this.startedElementStack.pop();
        this.emptyel = (Boolean)this.emptyelStack.pop();
    }

    public void startDocument() throws XSLOutputException {
        try {
            if (this.dochandler != null) {
                this.dochandler.startDocument();
            } else {
                this.dochasstarted = true;
                if (this.xslhandler != null) {
                    this.xslhandler.startDocument();
                }
            }
        }
        catch (Exception e) {
            throw new XSLOutputException(e.toString(), e);
        }
    }

    public void endDocument() throws XSLOutputException {
        try {
            if (this.dochandler != null) {
                this.dochandler.endDocument();
            } else {
                if (this.xsloutstream != null) {
                    this.xsloutstream.write(this.bufwrite, 0, this.bufwriteidx);
                    this.xsloutstream.close();
                }
                if (this.xslwriter != null) {
                    this.xslwriter.close();
                }
                if (this.xslhandler != null) {
                    this.xslhandler.endDocument();
                }
            }
        }
        catch (Exception e) {
            throw new XSLOutputException(0, e);
        }
    }

    private CharArray normalize(CharArray s) throws XSLOutputException {
        this.normalizeCarr.clear();
        int len = s != null ? s.getSize() : 0;
        char[] data = s.getData();
        char ch = '\u0000';
        block5: for (int i = s.getOffset(); i < len; ++i) {
            ch = data[i];
            if (ch == '<' || ch == '>' || ch == '&' || ch > '\u007f' || ch < '\u0000') {
                switch (ch) {
                    case '<': {
                        this.normalizeCarr.append("&lt;");
                        break;
                    }
                    case '>': {
                        this.normalizeCarr.append("&gt;");
                        break;
                    }
                    case '&': {
                        this.normalizeCarr.append("&amp;");
                        break;
                    }
                    default: {
                        int enclen = this.encoding.reverseEncode(this.convarr, ch);
                        for (int j = 0; j < enclen; ++j) {
                            this.normalizeCarr.append((char)this.convarr[j]);
                        }
                        continue block5;
                    }
                }
                continue;
            }
            this.normalizeCarr.append(ch);
        }
        return this.normalizeCarr;
    }

    public void addAttribute(CharArray uri, CharArray prefix, CharArray qname, CharArray localName, CharArray value) throws XSLException {
        if (this.dochandler != null && !this.bProcessAttributeValueTemplate) {
            this.iattList.addAttribute(uri, prefix, qname, localName, value);
        } else if (this.xsloutstream != null || this.xslwriter != null || this.bProcessAttributeValueTemplate) {
            this.dowrite(SP);
            this.dowrite(this.outputmode == 2 ? localName : qname);
            this.dowrite(EQ);
            this.attcarr.clear();
            char usequot = '\"';
            if (value.indexOf('\'') == -1) {
                usequot = '\'';
            }
            this.dowrite(usequot);
            this.dowrite(value);
            this.dowrite(usequot);
            this.dowrite(this.attcarr);
        }
    }

    public void startElement0() throws XSLException {
        try {
            if (this.dochandler != null && !this.bProcessAttributeValueTemplate && this.iattList != null) {
                for (int i = 0; i < this.iattList.size(); ++i) {
                    InternalAttribute ia = this.iattList.get(i);
                    this.dochandler.addAttribute(ia.uri, ia.prefix, ia.localName, ia.qname, "CDATA", ia.value);
                }
                this.iattList.clear();
            }
        }
        catch (Exception e) {
            throw new XSLException("Error while sending attributes to DocHandler", e);
        }
    }

    public void startElement(CharArray namespaceuri, CharArray localname, CharArray qname, InternalAttributeList attr) throws XSLOutputException {
        try {
            if (this.bStartedElement) {
                if (this.dochandler != null && !this.bProcessAttributeValueTemplate) {
                    this.startElement0();
                    this.dochandler.startElementEnd(false);
                }
                this.bStartedElement = false;
            }
            this.bStartedElement = true;
            if (this.dochandler != null && !this.bProcessAttributeValueTemplate) {
                this.dochandler.startElementStart(namespaceuri, localname, qname);
                if (attr != null) {
                    this.iattList.copy(attr);
                }
            } else if (this.bProcessAttributeValueTemplate) {
                if (this.outputmode != 2 && localname.equalsIgnoreCase("html")) {
                    this.outputmode = (byte)2;
                }
                if (this.emptyel) {
                    this.dowrite(ETN);
                    this.emptyel = false;
                }
                this.dowrite(OT);
                this.dowrite(this.outputmode == 2 ? localname : qname);
                for (int i = 0; attr != null && i < attr.getLength(); ++i) {
                    this.addAttribute(attr.getAttr((int)i).uri, attr.getAttr((int)i).prefix, attr.getAttr((int)i).qname, attr.getAttr((int)i).localName, attr.getAttr((int)i).value);
                }
                this.emptyel = true;
                if (this.outputmode == 2 && localname.equalsIgnoreCase("head")) {
                    this.dowrite(ETN);
                    this.emptyel = false;
                    this.dowrite(chHtmlMetaAfterHead);
                }
            }
        }
        catch (Exception e) {
            throw new XSLOutputException("Error writing output.", e);
        }
    }

    public void endElement(CharArray namespaceuri, CharArray localname, CharArray qname) throws XSLOutputException {
        try {
            if (this.dochandler != null && !this.bProcessAttributeValueTemplate) {
                if (this.bStartedElement) {
                    this.startElement0();
                    this.dochandler.startElementEnd(true);
                }
                this.dochandler.endElement(namespaceuri, localname, qname, this.bStartedElement);
                this.bStartedElement = false;
            } else if (this.bProcessAttributeValueTemplate) {
                if (this.emptyel) {
                    this.dowrite(ETS);
                    this.emptyel = false;
                } else {
                    this.dowrite(CH_ENDTAG_STD);
                    this.dowrite(this.outputmode == 2 ? localname : qname);
                    this.dowrite(ETN);
                }
                this.bStartedElement = false;
            }
        }
        catch (Exception e) {
            throw new XSLOutputException(0, e);
        }
    }

    public void characters(CharArray cdata, boolean disableOutputEscaping) throws XSLOutputException {
        try {
            if (this.bProcessAttributeValueTemplate) {
                if (!disableOutputEscaping && this.outputmode != 1 && !this.bDisableEscapingOverload) {
                    cdata = this.normalize(cdata);
                }
                if (this.emptyel && cdata.getSize() > 0) {
                    this.dowrite(ETN);
                    this.emptyel = false;
                }
                this.dowrite(cdata);
            } else if (this.dochandler != null) {
                if (this.bStartedElement && cdata.getSize() > 0) {
                    this.startElement0();
                    this.dochandler.startElementEnd(false);
                    this.bStartedElement = false;
                }
                if (disableOutputEscaping) {
                    this.dochandler.onPI(CH_PI_DISABLE_OUTPUT_ESCAPING, caEmpty);
                }
                this.dochandler.charData(cdata, true);
                if (disableOutputEscaping) {
                    this.dochandler.onPI(CH_PI_ENABLE_OUTPUT_ESCAPING, caEmpty);
                }
            } else {
                if (!disableOutputEscaping && this.outputmode != 1) {
                    cdata = this.normalize(cdata);
                }
                if (this.emptyel && cdata.getSize() > 0) {
                    this.dowrite(ETN);
                    this.emptyel = false;
                }
                this.dowrite(cdata);
            }
        }
        catch (Exception e) {
            throw new XSLOutputException(0, e);
        }
    }

    public void comment(CharArray data) throws XSLOutputException {
        if (this.bProcessAttributeValueTemplate) {
            throw new XSLOutputException("Comment while processing content of an AttributeValueTemplate or attribute value");
        }
        try {
            if (this.dochandler != null) {
                if (this.bStartedElement) {
                    this.startElement0();
                    this.dochandler.startElementEnd(false);
                    this.bStartedElement = false;
                }
                this.dochandler.onComment(data);
            } else {
                if (this.outputmode == 1) {
                    return;
                }
                if (this.xsloutstream != null || this.xslwriter != null) {
                    if (this.emptyel) {
                        this.dowrite(CH_GT_NL);
                        this.emptyel = false;
                    }
                    this.dowrite(CH_COMMENT_START);
                    this.dowrite(data);
                    this.dowrite(CH_COMMENT_END);
                }
            }
        }
        catch (Exception e) {
            throw new XSLOutputException(0, e);
        }
    }

    public void processingInstruction(CharArray target, CharArray data) throws XSLOutputException {
        try {
            if (this.dochandler != null) {
                if (this.bStartedElement) {
                    this.startElement0();
                    this.dochandler.startElementEnd(false);
                    this.bStartedElement = false;
                }
                this.dochandler.onPI(target, data);
            } else {
                if (this.outputmode == 1) {
                    return;
                }
                if (this.xsloutstream != null || this.xslwriter != null) {
                    if (this.emptyel) {
                        this.dowrite(CH_GT_NL);
                        this.emptyel = false;
                    }
                    this.dowrite(CH_PISTART);
                    this.dowrite(target);
                    this.dowrite(CH_SPACE);
                    this.dowrite(data);
                    if (this.outputmode == 2) {
                        this.dowrite(CH_GT_NL);
                    } else {
                        this.dowrite(CH_PIEND_NL);
                    }
                }
            }
        }
        catch (Exception e) {
            throw new XSLOutputException(0, e);
        }
    }

    public void setDisableOutputEscaping(boolean value) throws XSLException {
        this.bDisableEscapingOverload = value;
    }

    public DocHandler getDocHandler() {
        return this.dochandler;
    }

    public boolean getBProcessAVT() {
        return this.bProcessAttributeValueTemplate;
    }

    public CharArray getChProcessAVT() {
        return this.chAttributeValueProcessing;
    }

    public void setBProcessAVT(boolean bProcessAttributeValueTemplate) {
        this.bProcessAttributeValueTemplate = bProcessAttributeValueTemplate;
    }

    public void setChProcessAVT(CharArray chAttributeValueProcessing) {
        this.chAttributeValueProcessing = chAttributeValueProcessing;
    }
}

