/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.ETObject;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.XNumber;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xslt.XSLContentNode;
import com.sap.engine.lib.xsl.xslt.XSLException;
import com.sap.engine.lib.xsl.xslt.XSLNode;
import com.sap.engine.lib.xsl.xslt.XSLOutputException;
import com.sap.engine.lib.xsl.xslt.XSLOutputProcessor;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XSLNumber
extends XSLContentNode {
    public static final byte LEVEL_DEFAULT = 1;
    public static final byte LEVEL_SINGLE = 1;
    public static final byte LEVEL_MULTIPLE = 2;
    public static final byte LEVEL_ANY = 3;
    public static final byte FORMAT_DEFAULT = 1;
    public static final byte FORMAT_NUMERIC = 1;
    public static final byte FORMAT_ROMAN = 2;
    public static final byte FORMAT_ALPHABETIC = 3;
    public static final boolean WITH_CAPITALS = true;
    public static final byte LETTER_VALUE_ALPHABETIC = 1;
    public static final byte LETTER_VALUE_TRADITIONAL = 2;
    public static final boolean ALPHANUMERIC = true;
    public static final boolean NON_ALPHANUMERIC = false;
    public static final int ROOT_NODE = 0;
    private int rootelement = -1;
    private String value = null;
    private String lettervalue = null;
    private String lang = null;
    private byte level = 1;
    private Vector formattokens;
    private ETObject etcount = null;
    private ETObject etfrom = null;
    private char groupingseparator = (char)32;
    private int groupingsize = 0;
    private boolean separatorspecified = false;
    private boolean sizespecified = false;
    private boolean countspecified = false;
    private boolean fromspecified = false;
    private ETObject eto = null;
    public static final String[] REQPAR = new String[0];
    public static final String[] OPTPAR = new String[]{"level", "count", "from", "value", "format", "lang", "letter-value", "grouping-separator", "grouping-size"};

    private int determineRootElement(XPathContext xcont) {
        int node = xcont.dtm.firstChild[0];
        while (xcont.dtm.nodeType[node] != 1) {
            node = xcont.dtm.nextSibling[node];
        }
        return node;
    }

    public XSLNumber(XSLStylesheet owner, XSLNode parent) throws XSLException {
        super(owner, parent);
    }

    public XSLNumber(XSLStylesheet owner, XSLNode parent, Node content) throws XSLException {
        super(owner, parent, content);
        boolean formatspecified = false;
        NamedNodeMap attribs = content.getAttributes();
        for (int i = 0; i < attribs.getLength(); ++i) {
            Attr att = (Attr)attribs.item(i);
            String attrname = att.getNodeName();
            if (attrname.equals("level")) {
                this.level = 1;
                if (att.getValue().equals("multiple")) {
                    this.level = (byte)2;
                    continue;
                }
                if (!att.getValue().equals("any")) continue;
                this.level = (byte)3;
                continue;
            }
            if (attrname.equals("count")) {
                this.countspecified = true;
                this.etcount = owner.etBuilder.process(new CharArray(att.getValue()));
                continue;
            }
            if (attrname.equals("from")) {
                this.fromspecified = true;
                this.etfrom = owner.etBuilder.process(new CharArray(att.getValue()));
                continue;
            }
            if (attrname.equals("value")) {
                this.value = att.getValue();
                this.eto = owner.etBuilder.process(new CharArray(this.value));
                continue;
            }
            if (attrname.equals("format")) {
                formatspecified = true;
                this.formattokens = new Vector();
                this.splitToAlphanumericTokens(att.getValue(), this.formattokens);
                continue;
            }
            if (attrname.equals("lang")) {
                this.lang = att.getValue();
                continue;
            }
            if (attrname.equals("letter-value")) {
                this.lettervalue = att.getValue();
                continue;
            }
            if (attrname.equals("grouping-separator")) {
                if (att.getValue().length() <= 0) continue;
                this.groupingseparator = att.getValue().charAt(0);
                this.separatorspecified = true;
                continue;
            }
            if (!attrname.equals("grouping-size")) continue;
            try {
                this.groupingsize = new Integer(att.getValue());
                this.sizespecified = true;
                continue;
            }
            catch (NumberFormatException nfe) {
                throw new XSLException("Non-numeric value of 'grouping-size'. ", nfe);
            }
        }
        if (!formatspecified) {
            this.formattokens = new Vector();
            this.formattokens.add(new Alphanumeric());
        }
        this.sizespecified = this.separatorspecified = this.separatorspecified && this.sizespecified;
    }

    private Alphanumeric stringToAlphanumeric(String st) {
        Alphanumeric an = new Alphanumeric();
        char ch = st.charAt(st.length() - 1);
        if (ch == 'a') {
            an.capitals = false;
            an.type = (byte)3;
        } else if (ch == 'A') {
            an.capitals = true;
            an.type = (byte)3;
        } else if (ch == 'i') {
            an.capitals = false;
            an.type = (byte)2;
        } else if (ch == 'I') {
            an.capitals = true;
            an.type = (byte)2;
        } else {
            an.type = 1;
            an.minimallength = st.length();
        }
        return an;
    }

    private void splitToAlphanumericTokens(String fortokenizing, Vector tokens) {
        boolean iscurrentalphanumeric;
        if (fortokenizing == null || fortokenizing != null && fortokenizing.equals("")) {
            Alphanumeric an = new Alphanumeric();
            an.type = 1;
            tokens.add(an);
        }
        boolean islastalphanumeric = iscurrentalphanumeric = Character.isLetterOrDigit(fortokenizing.charAt(0));
        int substrstarts = 0;
        int substrends = 0;
        for (int i = 1; i < fortokenizing.length(); ++i) {
            iscurrentalphanumeric = Character.isLetterOrDigit(fortokenizing.charAt(i));
            if (iscurrentalphanumeric != islastalphanumeric) {
                substrstarts = substrends;
                substrends = i;
                if (islastalphanumeric) {
                    tokens.add(this.stringToAlphanumeric(fortokenizing.substring(substrstarts, substrends)));
                } else {
                    tokens.add(fortokenizing.substring(substrstarts, substrends));
                }
            }
            islastalphanumeric = iscurrentalphanumeric;
        }
        substrstarts = substrends;
        substrends = fortokenizing.length();
        if (islastalphanumeric) {
            tokens.add(this.stringToAlphanumeric(fortokenizing.substring(substrstarts, substrends)));
        } else {
            tokens.add(fortokenizing.substring(substrstarts, substrends));
            if (tokens.size() == 1) {
                tokens.add(0, new Alphanumeric());
            }
        }
    }

    public void process(XPathContext xcont, int node) throws XSLException, XPathException {
        if (this.rootelement == -1) {
            this.rootelement = this.determineRootElement(xcont);
        }
        XSLOutputProcessor oprocessor = this.owner.getOutputProcessor();
        if (!this.countspecified) {
            this.etcount = this.owner.etBuilder.process(xcont.dtm.name[node].toString());
        }
        if (!this.fromspecified) {
            this.etfrom = this.owner.etBuilder.process(xcont.dtm.name[this.rootelement].toString());
        }
        if (this.value != null) {
            XObject xo = this.owner.getXPathProcessor().process(this.eto, xcont, this.varContext);
            XNumber xn = xo.toXNumber();
            this.printSingleOrAny(oprocessor, (int)Math.round(xn.getValue()));
        } else if (this.level == 3) {
            int num = this.calculateAny(this.etcount, this.etfrom, xcont);
            this.printSingleOrAny(oprocessor, num);
        } else if (this.level == 1) {
            int num = this.calculateSingle(this.etcount, this.etfrom, xcont);
            this.printSingleOrAny(oprocessor, num);
        } else if (this.level == 2) {
            int lastalphanumeric;
            boolean hasendstring;
            int[] list = this.calculateMultiple(this.etcount, this.etfrom, xcont);
            int j = 0;
            if (this.formattokens.elementAt(0) instanceof String) {
                ++j;
                oprocessor.characters(new CharArray((String)this.formattokens.elementAt(0)), true);
            }
            if (this.formattokens.elementAt(this.formattokens.size() - 1) instanceof String) {
                hasendstring = true;
                lastalphanumeric = this.formattokens.size() - 2;
            } else {
                hasendstring = false;
                lastalphanumeric = this.formattokens.size() - 1;
            }
            for (int i = 0; i < list.length; ++i) {
                Alphanumeric an = j < this.formattokens.size() - 1 ? (Alphanumeric)this.formattokens.elementAt(j) : (Alphanumeric)this.formattokens.elementAt(lastalphanumeric);
                this.printAlphanumeric(an, list[i], oprocessor);
                ++j;
                if (hasendstring) {
                    if (i == list.length - 1) {
                        oprocessor.characters(new CharArray((String)this.formattokens.elementAt(this.formattokens.size() - 1)), true);
                    } else if (j >= this.formattokens.size() - 1) {
                        if (this.formattokens.size() < 4) {
                            oprocessor.characters(new CharArray("."), false);
                        } else {
                            oprocessor.characters(new CharArray((String)this.formattokens.elementAt(this.formattokens.size() - 3)), true);
                        }
                    } else {
                        oprocessor.characters(new CharArray((String)this.formattokens.elementAt(j)), true);
                    }
                } else if (i < list.length - 1) {
                    if (j >= this.formattokens.size() - 1) {
                        if (this.formattokens.size() < 3) {
                            oprocessor.characters(new CharArray("."), false);
                        } else {
                            oprocessor.characters(new CharArray((String)this.formattokens.elementAt(this.formattokens.size() - 2)), true);
                        }
                    } else {
                        oprocessor.characters(new CharArray((String)this.formattokens.elementAt(j)), true);
                    }
                }
                ++j;
            }
        }
        if (this.getNext() != null) {
            this.getNext().process(xcont, node);
        }
    }

    public void print(String ind) {
    }

    private int[] calculateMultiple(ETObject matchETO, ETObject fromETO, XPathContext basecontext) throws XPathException {
        int i;
        int listlength = this.howManyItems(matchETO, fromETO, basecontext);
        int tempnode = basecontext.node;
        int[] list = new int[listlength];
        XPathContext xcont = new XPathContext();
        xcont.reuse(basecontext);
        for (i = 0; i < listlength; ++i) {
            while (!matchETO.et.match(xcont)) {
                xcont.node = tempnode = xcont.dtm.parent[tempnode];
            }
            list[listlength - i - 1] = tempnode;
            tempnode = basecontext.dtm.parent[tempnode];
        }
        for (i = 0; i < listlength; ++i) {
            int nodenumber = 0;
            tempnode = list[i];
            while (tempnode != -1) {
                if (basecontext.dtm.nodeType[tempnode] == 1) {
                    xcont.reuse(basecontext);
                    xcont.node = tempnode;
                    if (matchETO.et.match(xcont)) {
                        ++nodenumber;
                    }
                }
                xcont.node = tempnode = xcont.dtm.previousSibling[tempnode];
            }
            list[i] = nodenumber;
        }
        return list;
    }

    private int howManyItems(ETObject matchETO, ETObject fromETO, XPathContext basecontext) throws XPathException {
        int count = 0;
        int fromnode = basecontext.node;
        XPathContext xcont = new XPathContext();
        xcont.reuse(basecontext);
        while (!fromETO.et.match(xcont) && fromnode != xcont.dtm.parent[this.rootelement]) {
            if (matchETO.et.match(xcont)) {
                ++count;
            }
            xcont.node = fromnode = xcont.dtm.parent[fromnode];
        }
        return count;
    }

    private int calculateSingle(ETObject matchETO, ETObject fromETO, XPathContext basecontext) throws XPathException {
        int fromnode = basecontext.node;
        XPathContext xcont = new XPathContext();
        xcont.reuse(basecontext);
        while (!matchETO.et.match(xcont) && fromnode != xcont.dtm.parent[this.rootelement]) {
            xcont.node = fromnode = xcont.dtm.parent[fromnode];
        }
        if (fromnode == xcont.dtm.parent[this.rootelement]) {
            return -1;
        }
        int countnode = xcont.node;
        while (!fromETO.et.match(xcont) && countnode != fromnode) {
            xcont.node = countnode = xcont.dtm.parent[countnode];
        }
        int nodecount = 1;
        while (xcont.dtm.previousSibling[countnode] != -1) {
            xcont.node = countnode = xcont.dtm.previousSibling[countnode];
            if (xcont.dtm.nodeType[countnode] != 1 || !matchETO.et.match(xcont)) continue;
            ++nodecount;
        }
        return nodecount;
    }

    private int calculateAny(ETObject matchETO, ETObject fromETO, XPathContext basecontext) throws XPathException {
        int node;
        int nodecount = 0;
        XPathContext xcont = new XPathContext();
        xcont.reuse(basecontext);
        for (int i = node = xcont.node; i >= this.rootelement; --i) {
            if (xcont.dtm.nodeType[i] != 1) continue;
            xcont.node = i;
            if (fromETO.et.match(xcont)) {
                return nodecount;
            }
            if (!matchETO.et.match(xcont)) continue;
            ++nodecount;
        }
        return nodecount;
    }

    private String intToRoman(int i, boolean capitals) {
        String st;
        block29: {
            st = "";
            if (i == 0) {
                return "0";
            }
            if (i >= 4000) break block29;
            if (capitals) {
                while (i >= 1000) {
                    st = st + "M";
                    i -= 1000;
                }
                if (i >= 900) {
                    st = st + "CM";
                    i -= 900;
                }
                if (i >= 500) {
                    st = st + "D";
                    i -= 500;
                }
                if (i >= 400) {
                    st = st + "CD";
                    i -= 400;
                }
                while (i >= 100) {
                    st = st + "C";
                    i -= 100;
                }
                if (i >= 90) {
                    st = st + "XC";
                    i -= 90;
                }
                if (i >= 50) {
                    st = st + "L";
                    i -= 50;
                }
                if (i >= 40) {
                    st = st + "XL";
                    i -= 40;
                }
                while (i >= 10) {
                    st = st + "X";
                    i -= 10;
                }
                if (i == 9) {
                    st = st + "IX";
                    i = 0;
                }
                if (i >= 5) {
                    st = st + "V";
                    i -= 5;
                }
                if (i == 4) {
                    st = st + "IV";
                    i = 0;
                }
                while (i >= 1) {
                    st = st + "I";
                    --i;
                }
            } else {
                while (i >= 1000) {
                    st = st + "m";
                    i -= 1000;
                }
                if (i >= 900) {
                    st = st + "cm";
                    i -= 900;
                }
                if (i >= 500) {
                    st = st + "d";
                    i -= 500;
                }
                if (i >= 400) {
                    st = st + "cd";
                    i -= 400;
                }
                while (i >= 100) {
                    st = st + "c";
                    i -= 100;
                }
                if (i >= 90) {
                    st = st + "xc";
                    i -= 90;
                }
                if (i >= 50) {
                    st = st + "l";
                    i -= 50;
                }
                if (i >= 40) {
                    st = st + "xl";
                    i -= 40;
                }
                while (i >= 10) {
                    st = st + "x";
                    i -= 10;
                }
                if (i == 9) {
                    st = st + "ix";
                    i = 0;
                }
                if (i >= 5) {
                    st = st + "v";
                    i -= 5;
                }
                if (i == 4) {
                    st = st + "iv";
                    i = 0;
                }
                while (i >= 1) {
                    st = st + "i";
                    --i;
                }
            }
        }
        return st;
    }

    private String intToLetter(int i, boolean capitals) {
        String st;
        if (i == 0) {
            st = "0";
        } else {
            st = "";
            char ref = '\u0000';
            ref = capitals ? (char)'A' : 'a';
            if (--i == 0) {
                return ref + "";
            }
            while (i > 0) {
                int j = i % 26;
                st = (char)(ref + j) + st;
                i /= 26;
            }
        }
        return st;
    }

    private void printSingleOrAny(XSLOutputProcessor oprocessor, int num) throws XSLOutputException {
        if (num >= 0) {
            int i = 0;
            if (this.formattokens.elementAt(0) instanceof String) {
                ++i;
                oprocessor.characters(new CharArray((String)this.formattokens.elementAt(0)), true);
            }
            Alphanumeric an = (Alphanumeric)this.formattokens.elementAt(i);
            this.printAlphanumeric(an, num, oprocessor);
            if (this.formattokens.size() > ++i && this.formattokens.elementAt(this.formattokens.size() - 1) instanceof String) {
                oprocessor.characters(new CharArray((String)this.formattokens.elementAt(this.formattokens.size() - 1)), true);
            }
        }
    }

    private void printAlphanumeric(Alphanumeric an, int num, XSLOutputProcessor oprocessor) throws XSLOutputException {
        if (an.type == 2) {
            oprocessor.characters(new CharArray(this.intToRoman(num, an.capitals)), true);
        } else if (an.type == 3) {
            oprocessor.characters(new CharArray(this.intToLetter(num, an.capitals)), true);
        } else {
            String number = new Integer(num).toString();
            if (number.length() < an.minimallength) {
                CharArray zero = new CharArray("0");
                for (int j = 1; j <= an.minimallength - number.length(); ++j) {
                    oprocessor.characters(zero, true);
                }
            }
            oprocessor.characters(new CharArray(number), true);
        }
    }

    public String[] getRequiredParams() {
        return REQPAR;
    }

    public String[] getOptionalParams() {
        return OPTPAR;
    }

    private class Alphanumeric {
        boolean capitals;
        byte type = 1;
        int minimallength = 1;

        private Alphanumeric() {
        }
    }
}

