/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.xml.dom.TextImpl;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xslt.XSLAttribute;
import com.sap.engine.lib.xsl.xslt.XSLException;
import com.sap.engine.lib.xsl.xslt.XSLNode;
import com.sap.engine.lib.xsl.xslt.XSLStylesheet;
import java.util.StringTokenizer;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class XSLAttributeSet
extends XSLNode {
    private String name = null;
    protected Vector attributeSets = new Vector();
    protected Vector attrs = new Vector();
    public static final String[] REQPAR = new String[]{"name"};
    public static final String[] OPTPAR = new String[]{"use-attribute-sets"};

    public XSLAttributeSet(XSLStylesheet owner) throws XSLException {
        super(owner, null);
    }

    public XSLAttributeSet(XSLStylesheet owner, Element el) throws XSLException {
        super(owner, null);
        this.name = el.getAttribute("name");
        if (el.getAttribute("use-attribute-sets") != null) {
            StringTokenizer tok = new StringTokenizer(el.getAttribute("use-attribute-sets"), " \n\r\t");
            while (tok.hasMoreElements()) {
                this.attributeSets.add(owner.getAttributeSet(tok.nextToken()));
            }
        }
        for (int i = 0; i < this.attributeSets.size(); ++i) {
            XSLAttributeSet xslattrset = (XSLAttributeSet)this.attributeSets.get(i);
            Vector v = xslattrset.getAttributes();
            for (int j = 0; j < v.size(); ++j) {
                XSLAttribute xslattr = (XSLAttribute)v.get(j);
                xslattr.setProcessByElement();
                int b = this.findXSLAttribute(this.attrs, xslattr);
                if (b > -1) {
                    this.attrs.set(b, xslattr);
                    continue;
                }
                this.attrs.add(xslattr);
            }
        }
        NodeList nl = el.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            XSLAttribute xslattr;
            int b;
            if (nl.item(i).getNodeType() == 3 && !((TextImpl)nl.item(i)).isWhiteSpace()) {
                throw new XSLException("Text nodes are not allowed in Attribute-set definition");
            }
            if (nl.item(i).getNodeType() == 1) {
                if (nl.item(i).getNamespaceURI() == null || !nl.item(i).getNamespaceURI().equals("http://www.w3.org/1999/XSL/Transform") || nl.item(i).getLocalName() == null || !nl.item(i).getLocalName().equals("attribute")) {
                    throw new XSLException("Only 'attribute' nodes from the XSL-namespace are allowed in attribute-set definition");
                }
            } else if (nl.item(i).getNodeType() != 1) continue;
            if ((b = this.findXSLAttribute(this.attrs, xslattr = new XSLAttribute(owner, (XSLNode)this, (Element)nl.item(i)))) > -1) {
                this.attrs.set(b, xslattr);
                continue;
            }
            this.attrs.add(xslattr);
        }
    }

    public Vector getAttributes() {
        return this.attrs;
    }

    public String getName() {
        return this.name;
    }

    public void process(XPathContext xcont, int node) throws XSLException, XPathException {
        this.getFirst().process(xcont, node);
        for (int i = 0; i < this.attributeSets.size(); ++i) {
            this.owner.getAttributeSet((String)this.attributeSets.get(i)).process(xcont, node);
        }
    }

    public void print(String ind) {
        System.out.println(ind + "#XSLAttributeSet  name = " + this.name);
        if (this.getFirst() != null) {
            this.getFirst().print(ind + "  ");
        }
        if (this.getNext() != null) {
            this.getNext().print(ind);
        }
    }

    public String[] getRequiredParams() {
        return REQPAR;
    }

    public String[] getOptionalParams() {
        return OPTPAR;
    }
}

