/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xslt;

import com.sap.engine.lib.xml.SystemProperties;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class CommandLine {
    public static void printUsage() {
        System.out.println(" XSLT engine.");
        System.out.println();
        System.out.println("Usage: xslt (<parameter> | <option>)*");
        System.out.println("");
        System.out.println("Parameters:");
        System.out.println("        [-xml] <filename_or_url>                      (required)");
        System.out.println("        [-xsl] <filename_or_url>                      (optional)");
        System.out.println("        [-out] <filename_or_url>                      (optional)");
        System.out.println("        If you do not specify the -xml -xsl or -out prefixes then this order is assumed");
        System.out.println("");
        System.out.println("Options:");
        System.out.println("        -indent");
        System.out.println("        -omitxmldecl");
        System.out.println("        -encoding <name_of_encoding>");
        System.out.println("        -version <name_of_version>");
        System.out.println("        -method  ( xml | text | html | dump )");
        System.out.println("        -cdata   ( <name_of_element> )*  [ -endcdata ]");
        System.out.println("        -P<name>=<value>                              (set the specified <value> to the <name> parameter )");
        System.out.println("        -apache                                       (run with Apache's Xalan transformer)");
        System.out.println("        -other   <TransformerFactory_class_name>      (run with other implementations)");
    }

    public static void main(String[] args) throws TransformerException, IOException, ClassNotFoundException {
        String s;
        StreamResult result;
        String xml = null;
        String xsl = null;
        String out = null;
        Properties p = new Properties();
        Properties params = new Properties();
        boolean useApache = false;
        String other = null;
        try {
            for (int i = 0; i < args.length; ++i) {
                String s2 = args[i];
                if (s2.equals("-xml")) {
                    xml = args[++i];
                    continue;
                }
                if (s2.equals("-xsl")) {
                    xsl = args[++i];
                    continue;
                }
                if (s2.equals("-out")) {
                    out = args[++i];
                    continue;
                }
                if (s2.equals("-indent")) {
                    p.setProperty("indent", "yes");
                    continue;
                }
                if (s2.equals("-omitxmldecl")) {
                    p.setProperty("omit-xml-declaration", "yes");
                    continue;
                }
                if (s2.equals("-version")) {
                    p.setProperty("version", args[++i]);
                    continue;
                }
                if (s2.equals("-encoding")) {
                    p.setProperty("encoding", args[++i]);
                    continue;
                }
                if (s2.equals("-method")) {
                    p.setProperty("method", args[++i]);
                    continue;
                }
                if (s2.equals("-cdata")) {
                    ++i;
                    String u = "";
                    while (i < args.length && !args[i].equals("-endcdata")) {
                        u = u + args[i] + ' ';
                        ++i;
                    }
                    p.setProperty("cdata-section-elements", u);
                    continue;
                }
                if (s2.equals("-other")) {
                    other = args[++i];
                    continue;
                }
                if (s2.equals("-apache")) {
                    useApache = true;
                    continue;
                }
                if (s2.startsWith("-P")) {
                    int equalsIndex = s2.indexOf("=");
                    String name = s2.substring(2, equalsIndex);
                    String value = s2.substring(equalsIndex + 1);
                    params.setProperty(name, value);
                    continue;
                }
                if (xml == null) {
                    xml = s2;
                    continue;
                }
                if (xsl == null) {
                    xsl = s2;
                    continue;
                }
                if (out == null) {
                    out = s2;
                    continue;
                }
                CommandLine.printUsage();
                return;
            }
        }
        catch (RuntimeException e) {
            CommandLine.printUsage();
            return;
        }
        if (other != null) {
            SystemProperties.setProperty("javax.xml.transform.TransformerFactory", other);
        } else if (!useApache) {
            SystemProperties.setProperty("javax.xml.transform.TransformerFactory", "com.sap.engine.lib.jaxp.TransformerFactoryImpl");
        } else {
            SystemProperties.setProperty("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl");
        }
        StreamResult streamResult = result = out == null ? new StreamResult(System.out) : new StreamResult(out);
        if (xml == null) {
            CommandLine.printUsage();
            return;
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer t = xsl == null ? tf.newTransformer() : tf.newTransformer(new StreamSource(xsl));
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            t.setOutputProperty(s, p.getProperty(s));
        }
        e = params.propertyNames();
        while (e.hasMoreElements()) {
            s = (String)e.nextElement();
            t.setParameter(s, params.getProperty(s));
        }
        try {
            t.transform(new StreamSource(xml), result);
        }
        catch (StackOverflowError e2) {
            System.out.flush();
            System.out.println(e2);
        }
    }
}

