/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath.functions;

import com.sap.engine.lib.xml.dom.NodeListImpl;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.XFunction;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.IntArrayIterator;
import com.sap.engine.lib.xsl.xpath.xobjects.XBoolean;
import com.sap.engine.lib.xsl.xpath.xobjects.XJavaObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XNumber;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XObjectFactory;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.w3c.dom.Node;

public final class JLBFunction
implements XFunction {
    private XPathContext currentContext = null;
    private Class className = null;
    private String functionName = null;
    private Class theClass = null;
    private boolean checked = false;
    private Method[] methods = null;
    private Constructor[] constructors = null;
    private Method theMethod;
    private Constructor theConstructor;
    private boolean isConstructor;
    private DTM dtm;
    private static final String[] numericTypes = new String[]{"double", "float", "long", "int", "short", "byte", "java.lang.Double", "java.lang.Long", "java.lang.Integer", "java.lang.Short", "java.lang.Byte"};

    public JLBFunction(Class className, String functionName) throws XPathException {
        try {
            this.className = className;
            this.functionName = this.hyphenTrimmer(functionName);
            this.init();
        }
        catch (ClassNotFoundException e) {
            throw new XPathException(e.toString(), e);
        }
    }

    public boolean confirmArgumentTypes(XObject[] a) {
        int i;
        int length = this.isConstructor ? this.constructors.length : this.methods.length;
        double[] efforts = new double[length];
        double minEffort = Double.POSITIVE_INFINITY;
        int position = -1;
        for (i = 0; i < length; ++i) {
            efforts[i] = !this.isConstructor ? this.evaluateEffort(a, this.methods[i]) : this.evaluateEffort(a, this.constructors[i]);
        }
        for (i = 0; i < efforts.length; ++i) {
            if (!(efforts[i] < minEffort)) continue;
            minEffort = efforts[i];
            position = i;
        }
        if (minEffort == Double.POSITIVE_INFINITY) {
            return false;
        }
        for (i = 0; i < efforts.length; ++i) {
            if (efforts[i] != minEffort || i == position) continue;
            return false;
        }
        if (!this.isConstructor) {
            this.theMethod = this.methods[position];
        } else {
            this.theConstructor = this.constructors[position];
        }
        return true;
    }

    public XObject execute(XObject[] a, XPathContext context) throws XPathException {
        this.currentContext = context;
        if (this.confirmArgumentTypes(a)) {
            try {
                Object result = null;
                if (!this.isConstructor) {
                    if (Modifier.isStatic(this.theMethod.getModifiers())) {
                        result = this.theMethod.invoke(null, this.prepareArguments(a, this.theMethod));
                    } else {
                        XObject[] arguments = new XObject[a.length - 1];
                        for (int i = 0; i < arguments.length; ++i) {
                            arguments[i] = a[i + 1];
                        }
                        result = this.theMethod.invoke(((XJavaObject)a[0]).getObject(), this.prepareArguments(arguments, this.theMethod));
                    }
                } else {
                    try {
                        result = this.theConstructor.newInstance(this.prepareArguments(a, this.theConstructor));
                    }
                    catch (InstantiationException i) {
                        throw new XPathException(i.toString(), i);
                    }
                }
                if (result instanceof Double) {
                    return context.getXFactCurrent().getXNumber((Double)result);
                }
                if (result instanceof Float) {
                    return context.getXFactCurrent().getXNumber(((Float)result).floatValue());
                }
                if (result instanceof Integer) {
                    return context.getXFactCurrent().getXNumber((Integer)result);
                }
                if (result instanceof Short) {
                    return context.getXFactCurrent().getXNumber(((Short)result).shortValue());
                }
                if (result instanceof Byte) {
                    return context.getXFactCurrent().getXNumber(((Byte)result).byteValue());
                }
                if (result instanceof Long) {
                    return context.getXFactCurrent().getXNumber(((Long)result).longValue());
                }
                if (result instanceof Character) {
                    return context.getXFactCurrent().getXNumber(((Character)result).charValue());
                }
                if (result == null) {
                    return context.getXFactCurrent().getXJavaObject(null);
                }
                if (result instanceof Void) {
                    return context.getXFactCurrent().getXNodeSet(context.dtm);
                }
                if (result instanceof String) {
                    return context.getXFactCurrent().getXString((String)result);
                }
                if (result instanceof Boolean) {
                    return context.getXFactCurrent().getXBoolean((Boolean)result);
                }
                XObjectFactory xof = context.getXFactCurrent();
                return xof.getXJavaObject(result);
            }
            catch (IllegalAccessException i) {
                i.printStackTrace();
                return null;
            }
            catch (InvocationTargetException i) {
                i.printStackTrace();
                return null;
            }
        }
        throw new XPathException("confirmArgumentTypes failed!!");
    }

    public String getFunctionName() {
        return this.functionName;
    }

    private void init() throws ClassNotFoundException {
        this.theClass = this.className;
        Vector<Executable> v = new Vector<Executable>();
        if (this.functionName.equals("new")) {
            int i;
            this.isConstructor = true;
            Constructor<?>[] all = this.theClass.getConstructors();
            for (i = 0; i < all.length; ++i) {
                this.checked = true;
                v.add(all[i]);
            }
            if (v.size() < 1) {
                throw new ClassNotFoundException("Class doesn't have a public constructor!");
            }
            this.constructors = new Constructor[v.size()];
            for (i = 0; i < this.constructors.length; ++i) {
                this.constructors[i] = (Constructor)v.get(i);
            }
        } else {
            int i;
            this.isConstructor = false;
            Method[] all = this.theClass.getMethods();
            for (i = 0; i < all.length; ++i) {
                if (!all[i].getName().equals(this.functionName)) continue;
                this.checked = true;
                v.add(all[i]);
            }
            if (v.size() < 1) {
                throw new ClassNotFoundException("Class doesn't have appropriate method!");
            }
            this.methods = new Method[v.size()];
            for (i = 0; i < this.methods.length; ++i) {
                this.methods[i] = (Method)v.get(i);
            }
        }
    }

    private boolean areMatching(XObject[] a, Method m) {
        Class<?>[] types = m.getParameterTypes();
        if (Modifier.isStatic(m.getModifiers())) {
            return a.length == types.length;
        }
        return a.length == types.length + 1;
    }

    private boolean areMatching(XObject[] a, Constructor c) {
        Class<?>[] types = c.getParameterTypes();
        return a.length == types.length;
    }

    private Object[] prepareArguments(XObject[] a, AccessibleObject m) throws XPathException {
        Class<?>[] parameters = null;
        Object[] result = new Object[a.length];
        parameters = m instanceof Method ? ((Method)m).getParameterTypes() : ((Constructor)m).getParameterTypes();
        for (int i = 0; i < parameters.length; ++i) {
            result[i] = this.convert(a[i], parameters[i]);
        }
        return result;
    }

    private Object convert(XObject from, Class to) throws XPathException {
        int xtype = from.getType();
        String type = to.getName();
        switch ((short)xtype) {
            case 2: {
                String s = from.toString();
                if ((type.equals("char") || type.equals("java.lang.Character")) && s.length() == 1) {
                    return new Character(s.charAt(0));
                }
                if (this.contains(numericTypes, type)) {
                    return this.convert(from.toXNumber(), to);
                }
                if (type.equals("boolean") || type.equals("java.lang.Boolean")) {
                    return this.convert(from.toXBoolean(), to);
                }
                if (type.equals("java.lang.String") || type.equals("java.lang.Object")) {
                    return s;
                }
                throw new XPathException("Incompatible types !@#!");
            }
            case 1: {
                XNumber xnumb = (XNumber)from;
                double d = xnumb.getValue();
                if (type.equals("double") || type.equals("java.lang.Double") || type.equals("java.lang.Object")) {
                    return new Double(d);
                }
                if (type.equals("float") || type.equals("java.lang.Float")) {
                    return new Float((float)d);
                }
                if (type.equals("long") || type.equals("java.lang.Long")) {
                    return new Long((long)d);
                }
                if (type.equals("int") || type.equals("java.lang.Integer")) {
                    return new Integer((int)d);
                }
                if (type.equals("short") || type.equals("java.lang.Short")) {
                    return new Short((short)d);
                }
                if (type.equals("char") || type.equals("java.lang.Character")) {
                    return new Character((char)d);
                }
                if (type.equals("byte") || type.equals("java.lang.Byte")) {
                    return new Byte((byte)d);
                }
                if (type.equals("boolean") || type.equals("java.lang.Boolean")) {
                    return this.convert(from.toXBoolean(), to);
                }
                if (type.equals("java.lang.String")) {
                    return this.convert(from.toXString(), to);
                }
                throw new XPathException("Incompatible types !@#!");
            }
            case 3: {
                XBoolean xbool = (XBoolean)from;
                boolean b = xbool.getValue();
                if (type.equals("boolean") || type.equals("java.lang.Boolean") || type.equals("java.lang.Object")) {
                    return new Boolean(b);
                }
                if (type.equals("java.lang.String")) {
                    return this.convert(from.toXString(), to);
                }
                if (this.contains(numericTypes, type)) {
                    return this.convert(from.toXNumber(), to);
                }
                throw new XPathException("Incompatible types !@#!");
            }
            case 6: {
                XJavaObject xobj = (XJavaObject)from;
                Object o = xobj.getObject();
                if (to.isInstance(o)) {
                    return o;
                }
                if (type.equals("java.lang.String")) {
                    return o.toString();
                }
                if (type.equals("char") || type.equals("java.lang.Character")) {
                    return this.convert(from.toXString(), to);
                }
                if (this.contains(numericTypes, type)) {
                    return this.convert(from.toXNumber(), to);
                }
                throw new XPathException("Trying to convert form XNodeSet to : " + type);
            }
            case 4: {
                XNodeSet xn = (XNodeSet)from;
                this.dtm = this.currentContext.dtm;
                this.dtm.initializeDOM();
                if (type.equals("org.w3c.dom.NodeList")) {
                    NodeListImpl nl = new NodeListImpl();
                    IntArrayIterator in = xn.iterator();
                    while (in.hasNext()) {
                        int i = in.next();
                        Node nod = this.dtm.domtree[i];
                        nl.add(nod);
                    }
                    return nl;
                }
                IntArrayIterator in = xn.iterator();
                int i = in.next();
                Node n = this.dtm.domtree[i];
                if (!to.isAssignableFrom(n.getClass())) break;
                return n;
            }
        }
        throw new XPathException("Trying to convert form XNodeSet to : " + type);
    }

    private double evaluateEffort(XObject[] a, Method m) {
        boolean isStatic = Modifier.isStatic(m.getModifiers());
        if (!this.areMatching(a, m)) {
            return Double.POSITIVE_INFINITY;
        }
        double sum = 0.0;
        Class<?>[] types = m.getParameterTypes();
        if (!isStatic) {
            if (a[0].getType() == 6) {
                XJavaObject xobj = (XJavaObject)a[0];
                Object o = xobj.getObject();
                if (this.theClass.isInstance(o)) {
                    for (int i = 0; i < a.length - 1; ++i) {
                        sum += this.effort(a[i + 1], types[i]);
                    }
                    return sum;
                }
                return Double.POSITIVE_INFINITY;
            }
            return Double.POSITIVE_INFINITY;
        }
        for (int i = 0; i < a.length; ++i) {
            sum += this.effort(a[i], types[i]);
        }
        return sum;
    }

    private double evaluateEffort(XObject[] a, Constructor c) {
        if (!this.areMatching(a, c)) {
            return Double.POSITIVE_INFINITY;
        }
        double sum = 0.0;
        Class<?>[] types = c.getParameterTypes();
        for (int i = 0; i < a.length; ++i) {
            sum += this.effort(a[i], types[i]);
        }
        return sum;
    }

    private double effort(XObject from, Class to) {
        int xtype = from.getType();
        String type = to.getName();
        switch ((short)xtype) {
            case 3: {
                if (type.equals("boolean")) {
                    return 0.0;
                }
                if (type.equals("java.lang.Boolean")) {
                    return 0.0;
                }
                if (type.equals("byte")) {
                    return 3.0;
                }
                if (type.equals("java.lang.Byte")) {
                    return 4.0;
                }
                if (type.equals("char")) {
                    return Double.POSITIVE_INFINITY;
                }
                if (type.equals("java.lang.Character")) {
                    return Double.POSITIVE_INFINITY;
                }
                if (type.equals("double")) {
                    return 3.0;
                }
                if (type.equals("java.lang.Double")) {
                    return 4.0;
                }
                if (type.equals("float")) {
                    return 3.0;
                }
                if (type.equals("java.lang.Float")) {
                    return 4.0;
                }
                if (type.equals("int")) {
                    return 3.0;
                }
                if (type.equals("java.lang.Integer")) {
                    return 4.0;
                }
                if (type.equals("long")) {
                    return 3.0;
                }
                if (type.equals("java.lang.Long")) {
                    return 4.0;
                }
                if (type.equals("short")) {
                    return 3.0;
                }
                if (type.equals("java.lang.Short")) {
                    return 4.0;
                }
                if (type.equals("java.lang.String")) {
                    return 2.0;
                }
                return 1.0;
            }
            case 1: {
                if (type.equals("boolean")) {
                    return 14.0;
                }
                if (type.equals("java.lang.Boolean")) {
                    return 15.0;
                }
                if (type.equals("byte")) {
                    return 12.0;
                }
                if (type.equals("java.lang.Byte")) {
                    return 13.0;
                }
                if (type.equals("char")) {
                    return 10.0;
                }
                if (type.equals("java.lang.Character")) {
                    return 11.0;
                }
                if (type.equals("double")) {
                    return 0.0;
                }
                if (type.equals("java.lang.Double")) {
                    return 1.0;
                }
                if (type.equals("float")) {
                    return 2.0;
                }
                if (type.equals("java.lang.Float")) {
                    return 3.0;
                }
                if (type.equals("int")) {
                    return 6.0;
                }
                if (type.equals("java.lang.Integer")) {
                    return 7.0;
                }
                if (type.equals("long")) {
                    return 4.0;
                }
                if (type.equals("java.lang.Long")) {
                    return 5.0;
                }
                if (type.equals("short")) {
                    return 8.0;
                }
                if (type.equals("java.lang.Short")) {
                    return 9.0;
                }
                if (type.equals("java.lang.String")) {
                    return 16.0;
                }
                return 17.0;
            }
            case 2: {
                if (type.equals("boolean")) {
                    return 6.0;
                }
                if (type.equals("java.lang.Boolean")) {
                    return 7.0;
                }
                if (type.equals("byte")) {
                    return 4.0;
                }
                if (type.equals("java.lang.Byte")) {
                    return 5.0;
                }
                if (type.equals("char")) {
                    return 2.0;
                }
                if (type.equals("java.lang.Character")) {
                    return 3.0;
                }
                if (type.equals("double")) {
                    return 4.0;
                }
                if (type.equals("java.lang.Double")) {
                    return 5.0;
                }
                if (type.equals("float")) {
                    return 4.0;
                }
                if (type.equals("java.lang.Float")) {
                    return 5.0;
                }
                if (type.equals("int")) {
                    return 4.0;
                }
                if (type.equals("java.lang.Integer")) {
                    return 5.0;
                }
                if (type.equals("long")) {
                    return 4.0;
                }
                if (type.equals("java.lang.Long")) {
                    return 3.0;
                }
                if (type.equals("short")) {
                    return 4.0;
                }
                if (type.equals("java.lang.Short")) {
                    return 5.0;
                }
                if (type.equals("java.lang.String")) {
                    return 0.0;
                }
                return 1.0;
            }
            case 6: {
                if (type.equals("boolean")) {
                    return Double.POSITIVE_INFINITY;
                }
                if (type.equals("java.lang.Boolean")) {
                    return Double.POSITIVE_INFINITY;
                }
                if (type.equals("byte")) {
                    return 4.0;
                }
                if (type.equals("java.lang.Byte")) {
                    return 5.0;
                }
                if (type.equals("char")) {
                    return 2.0;
                }
                if (type.equals("java.lang.Character")) {
                    return 3.0;
                }
                if (type.equals("double")) {
                    return 4.0;
                }
                if (type.equals("java.lang.Double")) {
                    return 5.0;
                }
                if (type.equals("float")) {
                    return 4.0;
                }
                if (type.equals("java.lang.Float")) {
                    return 5.0;
                }
                if (type.equals("int")) {
                    return 4.0;
                }
                if (type.equals("java.lang.Integer")) {
                    return 5.0;
                }
                if (type.equals("long")) {
                    return 4.0;
                }
                if (type.equals("java.lang.Long")) {
                    return 3.0;
                }
                if (type.equals("short")) {
                    return 4.0;
                }
                if (type.equals("java.lang.Short")) {
                    return 5.0;
                }
                if (type.equals("java.lang.String")) {
                    return 1.0;
                }
                XJavaObject xobj = (XJavaObject)from;
                Object o = xobj.getObject();
                return to.isInstance(o) ? 0.0 : Double.POSITIVE_INFINITY;
            }
            case 4: {
                if (type.equals("org.w3c.dom.NodeList")) {
                    return 0.0;
                }
                if (type.equals("org.w3c.dom.Node")) {
                    return 1.0;
                }
                return Double.POSITIVE_INFINITY;
            }
        }
        return Double.POSITIVE_INFINITY;
    }

    private String hyphenTrimmer(String source) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < source.length(); ++i) {
            if (source.charAt(i) != '-') {
                result.append(source.charAt(i));
                continue;
            }
            if (i == source.length() - 1) break;
            if (source.charAt(i + 1) == '-') continue;
            result.append(Character.toUpperCase(source.charAt(i + 1)));
            ++i;
        }
        return result.toString();
    }

    private boolean contains(String[] arr, String what) {
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].equals(what)) continue;
            return true;
        }
        return false;
    }
}

