/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import com.sap.engine.lib.xsl.xpath.IntVector;
import com.sap.engine.lib.xsl.xpath.Symbols;
import com.sap.engine.lib.xsl.xpath.XPathException;
import java.util.Arrays;
import java.util.Vector;

public final class XPathTokenizer {
    private static final char[][] TWO_CHARACTER_TOKENS = new char[][]{{'!', '='}, {'<', '='}, {'>', '='}};
    private String expression;
    private char[] e = new char[100];
    private int index;
    private static int[] h1 = new int[255];

    private int h1get(char ch) {
        if (ch < '\u0000' || ch >= h1.length) {
            return -1;
        }
        return h1[ch];
    }

    public void process(String s, Vector rs, IntVector rt, IntVector pos) throws XPathException {
        this.tokenize(s, rs, rt, pos);
    }

    private void tokenize(String expressionString, Vector vs, IntVector vt, IntVector pos) throws XPathException {
        this.expression = expressionString;
        int l = expressionString.length();
        if (this.e.length < l + 1) {
            this.e = new char[l + 10];
        }
        expressionString.getChars(0, l, this.e, 0);
        this.e[l] = 32;
        this.index = 0;
        vs.clear();
        vt.clear();
        pos.clear();
        while (this.index < l) {
            char ch = this.e[this.index];
            char ch1 = this.e[this.index + 1];
            int oldIndex = this.index++;
            if (Symbols.isWhitespace(ch)) continue;
            pos.add(this.index);
            if (Symbols.isInitialCharForQName(ch)) {
                this.skipQName();
                vs.addElement(this.expression.substring(oldIndex, this.index));
                vt.add(5);
                continue;
            }
            if (ch == '.' && ch1 == '.') {
                vs.addElement("..");
                vt.add(22);
                this.index += 2;
                continue;
            }
            if (ch == ':' && ch1 == ':') {
                vs.addElement("::");
                vt.add(18);
                this.index += 2;
                continue;
            }
            if (ch == '/' && ch1 == '/') {
                vs.addElement("//");
                vt.add(23);
                this.index += 2;
                continue;
            }
            if (this.isTwoCharacterToken(ch, ch1)) {
                vs.addElement("" + ch + ch1);
                vt.add(0);
                this.index += 2;
                continue;
            }
            if (ch == '/') {
                vs.addElement("/");
                vt.add(24);
                ++this.index;
                continue;
            }
            if (ch == '.' && Symbols.isDigit(ch1)) {
                this.index += 2;
                this.skipDigits();
                vs.addElement(this.expression.substring(oldIndex, this.index));
                vt.add(1);
                continue;
            }
            if (Symbols.isDigit(ch)) {
                this.skipDigits();
                if (this.e[this.index] == '.' && Symbols.isDigit(this.expression.charAt(this.index + 1))) {
                    this.index += 2;
                    this.skipDigits();
                }
                vs.addElement(this.expression.substring(oldIndex, this.index));
                vt.add(1);
                continue;
            }
            if (ch == '\"' || ch == '\'') {
                int p = this.expression.indexOf(ch, this.index + 1);
                if (p == -1) {
                    throw new XPathException("Literal started at position " + this.index + " in the query has not been closed");
                }
                vs.addElement(this.expression.substring(this.index, p + 1));
                vt.add(6);
                this.index = p + 1;
                continue;
            }
            int a = this.h1get(ch);
            if (a != -1) {
                vs.addElement(String.valueOf(ch));
                vt.add(a);
                ++this.index;
                continue;
            }
            throw new XPathException("Character not allowed in XPath, '" + ch + "'");
        }
        vs.addElement("");
        vt.add(100);
        pos.add(l);
    }

    private void skipDigits() {
        char ch;
        while (Symbols.isDigit(ch = this.e[this.index])) {
            ++this.index;
        }
    }

    private void skipQName() {
        this.skipNCName();
        if (this.e[this.index] == ':') {
            char ch1 = this.e[this.index + 1];
            if (Symbols.isInitialCharForQName(ch1)) {
                ++this.index;
                this.skipNCName();
            } else if (ch1 == '*') {
                this.index += 2;
            }
        }
    }

    private void skipNCName() {
        char ch;
        while (Symbols.isCharForQName(ch = this.e[this.index])) {
            ++this.index;
        }
        return;
    }

    private boolean isTwoCharacterToken(char a, char b) {
        for (int i = 0; i < TWO_CHARACTER_TOKENS.length; ++i) {
            if (TWO_CHARACTER_TOKENS[i][0] != a || TWO_CHARACTER_TOKENS[i][1] != b) continue;
            return true;
        }
        return false;
    }

    static {
        Arrays.fill(h1, -1);
        XPathTokenizer.h1[40] = 13;
        XPathTokenizer.h1[41] = 14;
        XPathTokenizer.h1[91] = 15;
        XPathTokenizer.h1[93] = 16;
        XPathTokenizer.h1[46] = 21;
        XPathTokenizer.h1[64] = 20;
        XPathTokenizer.h1[44] = 17;
        XPathTokenizer.h1[124] = 0;
        XPathTokenizer.h1[43] = 0;
        XPathTokenizer.h1[45] = 0;
        XPathTokenizer.h1[61] = 0;
        XPathTokenizer.h1[60] = 0;
        XPathTokenizer.h1[62] = 0;
        XPathTokenizer.h1[42] = 0;
        XPathTokenizer.h1[36] = 19;
    }
}

