/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.FDBigInt;

public final class StaticDouble {
    boolean isExceptional;
    boolean isNegative;
    int decExponent;
    char[] digits;
    char[] digbuf = new char[100];
    int nDigits;
    int bigIntExp;
    int bigIntNBits;
    boolean mustSetRoundDir = false;
    int roundDir;
    static final long signMask = Long.MIN_VALUE;
    static final long expMask = 0x7FF0000000000000L;
    static final long fractMask = 0xFFFFFFFFFFFFFL;
    static final int expShift = 52;
    static final int expBias = 1023;
    static final long fractHOB = 0x10000000000000L;
    static final long expOne = 0x3FF0000000000000L;
    static final int maxSmallBinExp = 62;
    static final int minSmallBinExp = -21;
    static final int maxDecimalDigits = 15;
    static final int maxDecimalExponent = 308;
    static final int minDecimalExponent = -324;
    static final int bigDecimalExponent = 324;
    static final long highbyte = -72057594037927936L;
    static final long highbit = Long.MIN_VALUE;
    static final long lowbytes = 0xFFFFFFFFFFFFFFL;
    static final int singleSignMask = Integer.MIN_VALUE;
    static final int singleExpMask = 2139095040;
    static final int singleFractMask = 0x7FFFFF;
    static final int singleExpShift = 23;
    static final int singleFractHOB = 0x800000;
    static final int singleExpBias = 127;
    static final int singleMaxDecimalDigits = 7;
    static final int singleMaxDecimalExponent = 38;
    static final int singleMinDecimalExponent = -45;
    static final int intDecimalDigits = 9;
    private static FDBigInt[] b5p;
    private static final double[] small10pow;
    private static final float[] singleSmall10pow;
    private static final double[] big10pow;
    private static final double[] tiny10pow;
    private static final int maxSmallTen;
    private static final int singleMaxSmallTen;
    private static final int[] small5pow;
    private static final long[] long5pow;
    private static final int[] n5bits;
    private static final char[] infinity;
    private static final char[] notANumber;
    private static final char[] zero;

    public StaticDouble reuse(boolean negSign, int decExponent, char[] digits, int n, boolean e) {
        this.isNegative = negSign;
        this.isExceptional = e;
        this.decExponent = decExponent;
        this.digits = digits;
        this.nDigits = n;
        return this;
    }

    private static int countBits(long v) {
        if (v == 0L) {
            return 0;
        }
        while ((v & 0xFF00000000000000L) == 0L) {
            v <<= 8;
        }
        while (v > 0L) {
            v <<= 1;
        }
        int n = 0;
        while ((v & 0xFFFFFFFFFFFFFFL) != 0L) {
            v <<= 8;
            n += 8;
        }
        while (v != 0L) {
            v <<= 1;
            ++n;
        }
        return n;
    }

    private FDBigInt big5pow(int p) {
        if (p < 0) {
            throw new RuntimeException("Assertion botch: negative power of 5");
        }
        if (b5p == null) {
            b5p = new FDBigInt[p + 1];
        } else if (b5p.length <= p) {
            FDBigInt[] t = new FDBigInt[p + 1];
            System.arraycopy(b5p, 0, t, 0, b5p.length);
            b5p = t;
        }
        if (b5p[p] != null) {
            return b5p[p];
        }
        if (p < small5pow.length) {
            StaticDouble.b5p[p] = new FDBigInt(small5pow[p]);
            return StaticDouble.b5p[p];
        }
        if (p < long5pow.length) {
            StaticDouble.b5p[p] = new FDBigInt(long5pow[p]);
            return StaticDouble.b5p[p];
        }
        int q = p >> 1;
        int r = p - q;
        FDBigInt bigq = b5p[q];
        if (bigq == null) {
            bigq = this.big5pow(q);
        }
        if (r < small5pow.length) {
            StaticDouble.b5p[p] = bigq.mult(small5pow[r]);
            return StaticDouble.b5p[p];
        }
        FDBigInt bigr = b5p[r];
        if (bigr == null) {
            bigr = this.big5pow(r);
        }
        StaticDouble.b5p[p] = bigq.mult(bigr);
        return StaticDouble.b5p[p];
    }

    private FDBigInt multPow52(FDBigInt v, int p5, int p2) {
        if (p5 != 0) {
            v = p5 < small5pow.length ? v.mult(small5pow[p5]) : v.mult(this.big5pow(p5));
        }
        if (p2 != 0) {
            v.lshiftMe(p2);
        }
        return v;
    }

    private FDBigInt constructPow52(int p5, int p2) {
        FDBigInt v = new FDBigInt(this.big5pow(p5));
        if (p2 != 0) {
            v.lshiftMe(p2);
        }
        return v;
    }

    private FDBigInt doubleToBigInt(double dval) {
        long lbits = Double.doubleToLongBits(dval) & Long.MAX_VALUE;
        int binexp = (int)(lbits >>> 52);
        lbits &= 0xFFFFFFFFFFFFFL;
        if (binexp > 0) {
            lbits |= 0x10000000000000L;
        } else {
            if (lbits == 0L) {
                throw new RuntimeException("Assertion botch: doubleToBigInt(0.0)");
            }
            ++binexp;
            while ((lbits & 0x10000000000000L) == 0L) {
                lbits <<= 1;
                --binexp;
            }
        }
        int nbits = StaticDouble.countBits(lbits);
        int lowOrderZeros = 53 - nbits;
        this.bigIntExp = (binexp -= 1023) + 1 - nbits;
        this.bigIntNBits = nbits;
        return new FDBigInt(lbits >>>= lowOrderZeros);
    }

    private static double ulp(double dval, boolean subtracting) {
        long lbits = Double.doubleToLongBits(dval) & Long.MAX_VALUE;
        int binexp = (int)(lbits >>> 52);
        if (subtracting && binexp >= 52 && (lbits & 0xFFFFFFFFFFFFFL) == 0L) {
            --binexp;
        }
        double ulpval = binexp > 52 ? Double.longBitsToDouble((long)(binexp - 52) << 52) : (binexp == 0 ? Double.MIN_VALUE : Double.longBitsToDouble(1L << binexp - 1));
        if (subtracting) {
            ulpval = -ulpval;
        }
        return ulpval;
    }

    float stickyRound(double dval) {
        long lbits = Double.doubleToLongBits(dval);
        long binexp = lbits & 0x7FF0000000000000L;
        if (binexp == 0L || binexp == 0x7FF0000000000000L) {
            return (float)dval;
        }
        return (float)Double.longBitsToDouble(lbits += (long)this.roundDir);
    }

    private void developLongDigits(int decExponent, long lvalue, long insignificant) {
        char[] result;
        int digitno;
        char[] digits;
        int ndigits;
        int i = 0;
        while (insignificant >= 10L) {
            insignificant /= 10L;
            ++i;
        }
        if (i != 0) {
            long pow10 = long5pow[i] << i;
            long residue = lvalue % pow10;
            lvalue /= pow10;
            decExponent += i;
            if (residue >= pow10 >> 1) {
                ++lvalue;
            }
        }
        if (lvalue <= Integer.MAX_VALUE) {
            if (lvalue <= 0L) {
                throw new RuntimeException("Assertion botch: value " + lvalue + " <= 0");
            }
            ndigits = 10;
            int ivalue = (int)lvalue;
            digits = this.digbuf;
            digitno = ndigits - 1;
            int c = ivalue % 10;
            ivalue /= 10;
            while (c == 0) {
                ++decExponent;
                c = ivalue % 10;
                ivalue /= 10;
            }
            while (ivalue != 0) {
                digits[digitno--] = (char)(c + 48);
                ++decExponent;
                c = ivalue % 10;
                ivalue /= 10;
            }
            digits[digitno] = (char)(c + 48);
        } else {
            ndigits = 20;
            digits = this.digbuf;
            digitno = ndigits - 1;
            int c = (int)(lvalue % 10L);
            lvalue /= 10L;
            while (c == 0) {
                ++decExponent;
                c = (int)(lvalue % 10L);
                lvalue /= 10L;
            }
            while (lvalue != 0L) {
                digits[digitno--] = (char)(c + 48);
                ++decExponent;
                c = (int)(lvalue % 10L);
                lvalue /= 10L;
            }
            digits[digitno] = (char)(c + 48);
        }
        ndigits -= digitno;
        if (digitno == 0) {
            result = digits;
        } else {
            result = new char[ndigits];
            System.arraycopy(digits, digitno, result, 0, ndigits);
        }
        this.digits = result;
        this.decExponent = decExponent + 1;
        this.nDigits = ndigits;
    }

    private void roundup() {
        int i = this.nDigits - 1;
        char q = this.digits[i];
        if (q == '9') {
            while (q == '9' && i > 0) {
                this.digits[i] = 48;
                q = this.digits[--i];
            }
            if (q == '9') {
                ++this.decExponent;
                this.digits[0] = 49;
                return;
            }
        }
        this.digits[i] = (char)(q + '\u0001');
    }

    public StaticDouble reuse(double d) {
        int nSignificantBits;
        long dBits = Double.doubleToLongBits(d);
        if ((dBits & Long.MIN_VALUE) != 0L) {
            this.isNegative = true;
            dBits ^= Long.MIN_VALUE;
        } else {
            this.isNegative = false;
        }
        int binExp = (int)((dBits & 0x7FF0000000000000L) >> 52);
        long fractBits = dBits & 0xFFFFFFFFFFFFFL;
        if (binExp == 2047) {
            this.isExceptional = true;
            if (fractBits == 0L) {
                this.digits = infinity;
            } else {
                this.digits = notANumber;
                this.isNegative = false;
            }
            this.nDigits = this.digits.length;
            return this;
        }
        this.isExceptional = false;
        if (binExp == 0) {
            if (fractBits == 0L) {
                this.decExponent = 0;
                this.digits = zero;
                this.nDigits = 1;
                return this;
            }
            while ((fractBits & 0x10000000000000L) == 0L) {
                fractBits <<= 1;
                --binExp;
            }
            nSignificantBits = 52 + binExp + 1;
            ++binExp;
        } else {
            fractBits |= 0x10000000000000L;
            nSignificantBits = 53;
        }
        this.dtoa(binExp -= 1023, fractBits, nSignificantBits);
        return this;
    }

    public StaticDouble reuse(float f) {
        int nSignificantBits;
        int fBits = Float.floatToIntBits(f);
        if ((fBits & Integer.MIN_VALUE) != 0) {
            this.isNegative = true;
            fBits ^= Integer.MIN_VALUE;
        } else {
            this.isNegative = false;
        }
        int binExp = (fBits & 0x7F800000) >> 23;
        int fractBits = fBits & 0x7FFFFF;
        if (binExp == 255) {
            this.isExceptional = true;
            if ((long)fractBits == 0L) {
                this.digits = infinity;
            } else {
                this.digits = notANumber;
                this.isNegative = false;
            }
            this.nDigits = this.digits.length;
            return this;
        }
        this.isExceptional = false;
        if (binExp == 0) {
            if (fractBits == 0) {
                this.decExponent = 0;
                this.digits = zero;
                this.nDigits = 1;
                return this;
            }
            while ((fractBits & 0x800000) == 0) {
                fractBits <<= 1;
                --binExp;
            }
            nSignificantBits = 23 + binExp + 1;
            ++binExp;
        } else {
            fractBits |= 0x800000;
            nSignificantBits = 24;
        }
        this.dtoa(binExp -= 127, (long)fractBits << 29, nSignificantBits);
        return this;
    }

    private void dtoa(int binExp, long fractBits, int nSignificantBits) {
        long lowDigitDifference;
        boolean high;
        boolean low;
        int nFractBits = StaticDouble.countBits(fractBits);
        int nTinyBits = Math.max(0, nFractBits - binExp - 1);
        if (binExp <= 62 && binExp >= -21 && nTinyBits < long5pow.length && nFractBits + n5bits[nTinyBits] < 64 && nTinyBits == 0) {
            long halfULP = binExp > nSignificantBits ? 1L << binExp - nSignificantBits - 1 : 0L;
            fractBits = binExp >= 52 ? (fractBits <<= binExp - 52) : (fractBits >>>= 52 - binExp);
            this.developLongDigits(0, fractBits, halfULP);
            return;
        }
        double d2 = Double.longBitsToDouble(0x3FF0000000000000L | fractBits & 0xFFEFFFFFFFFFFFFFL);
        int decExp = (int)Math.floor((d2 - 1.5) * 0.289529654 + 0.176091259 + (double)binExp * 0.301029995663981);
        int B5 = Math.max(0, -decExp);
        int B2 = B5 + nTinyBits + binExp;
        int S5 = Math.max(0, decExp);
        int S2 = S5 + nTinyBits;
        int M5 = B5;
        int M2 = B2 - nSignificantBits;
        fractBits >>>= 53 - nFractBits;
        int common2factor = Math.min(B2 -= nFractBits - 1, S2);
        B2 -= common2factor;
        S2 -= common2factor;
        M2 -= common2factor;
        if (nFractBits == 1) {
            --M2;
        }
        if (M2 < 0) {
            B2 -= M2;
            S2 -= M2;
            M2 = 0;
        }
        this.digits = this.digbuf;
        char[] digits = this.digbuf;
        int ndigit = 0;
        int Bbits = nFractBits + B2 + (B5 < n5bits.length ? n5bits[B5] : B5 * 3);
        int tenSbits = S2 + 1 + (S5 + 1 < n5bits.length ? n5bits[S5 + 1] : (S5 + 1) * 3);
        if (Bbits < 64 && tenSbits < 64) {
            if (Bbits < 32 && tenSbits < 32) {
                int b = (int)fractBits * small5pow[B5] << B2;
                int s = small5pow[S5] << S2;
                int m = small5pow[M5] << M2;
                int tens = s * 10;
                ndigit = 0;
                int q = b / s;
                low = (b = 10 * (b % s)) < (m *= 10);
                boolean bl = high = b + m > tens;
                if (q >= 10) {
                    throw new RuntimeException("Assertion botch: excessivly large digit " + q);
                }
                if (q == 0 && !high) {
                    --decExp;
                } else {
                    digits[ndigit++] = (char)(48 + q);
                }
                if (decExp <= -3 || decExp >= 8) {
                    low = false;
                    high = false;
                }
                while (!low && !high) {
                    q = b / s;
                    b = 10 * (b % s);
                    m *= 10;
                    if (q >= 10) {
                        throw new RuntimeException("Assertion botch: excessivly large digit " + q);
                    }
                    if ((long)m > 0L) {
                        low = b < m;
                        high = b + m > tens;
                    } else {
                        low = true;
                        high = true;
                    }
                    digits[ndigit++] = (char)(48 + q);
                }
                lowDigitDifference = (b << 1) - tens;
            } else {
                long b = fractBits * long5pow[B5] << B2;
                long s = long5pow[S5] << S2;
                long m = long5pow[M5] << M2;
                long tens = s * 10L;
                ndigit = 0;
                int q = (int)(b / s);
                low = (b = 10L * (b % s)) < (m *= 10L);
                boolean bl = high = b + m > tens;
                if (q >= 10) {
                    throw new RuntimeException("Assertion botch: excessivly large digit " + q);
                }
                if (q == 0 && !high) {
                    --decExp;
                } else {
                    digits[ndigit++] = (char)(48 + q);
                }
                if (decExp <= -3 || decExp >= 8) {
                    low = false;
                    high = false;
                }
                while (!low && !high) {
                    q = (int)(b / s);
                    b = 10L * (b % s);
                    m *= 10L;
                    if (q >= 10) {
                        throw new RuntimeException("Assertion botch: excessivly large digit " + q);
                    }
                    if (m > 0L) {
                        low = b < m;
                        high = b + m > tens;
                    } else {
                        low = true;
                        high = true;
                    }
                    digits[ndigit++] = (char)(48 + q);
                }
                lowDigitDifference = (b << 1) - tens;
            }
        } else {
            FDBigInt Bval = this.multPow52(new FDBigInt(fractBits), B5, B2);
            FDBigInt Sval = this.constructPow52(S5, S2);
            FDBigInt Mval = this.constructPow52(M5, M2);
            int shiftBias = Sval.normalizeMe();
            Bval.lshiftMe(shiftBias);
            Mval.lshiftMe(shiftBias);
            FDBigInt tenSval = Sval.mult(10);
            ndigit = 0;
            int q = Bval.quoRemIteration(Sval);
            Mval = Mval.mult(10);
            low = Bval.cmp(Mval) < 0;
            boolean bl = high = Bval.add(Mval).cmp(tenSval) > 0;
            if (q >= 10) {
                throw new RuntimeException("Assertion botch: excessivly large digit " + q);
            }
            if (q == 0 && !high) {
                --decExp;
            } else {
                digits[ndigit++] = (char)(48 + q);
            }
            if (decExp <= -3 || decExp >= 8) {
                low = false;
                high = false;
            }
            while (!low && !high) {
                q = Bval.quoRemIteration(Sval);
                Mval = Mval.mult(10);
                if (q >= 10) {
                    throw new RuntimeException("Assertion botch: excessivly large digit " + q);
                }
                low = Bval.cmp(Mval) < 0;
                high = Bval.add(Mval).cmp(tenSval) > 0;
                digits[ndigit++] = (char)(48 + q);
            }
            if (high && low) {
                Bval.lshiftMe(1);
                lowDigitDifference = Bval.cmp(tenSval);
            } else {
                lowDigitDifference = 0L;
            }
        }
        this.decExponent = decExp + 1;
        this.digits = digits;
        this.nDigits = ndigit;
        if (high) {
            if (low) {
                if (lowDigitDifference == 0L) {
                    if ((digits[this.nDigits - 1] & '\u0001') != 0) {
                        this.roundup();
                    }
                } else if (lowDigitDifference > 0L) {
                    this.roundup();
                }
            } else {
                this.roundup();
            }
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.nDigits + 8);
        if (this.isNegative) {
            result.append('-');
        }
        if (this.isExceptional) {
            result.append(this.digits, 0, this.nDigits);
        } else {
            result.append("0.");
            result.append(this.digits, 0, this.nDigits);
            result.append('e');
            result.append(this.decExponent);
        }
        return new String(result);
    }

    public void doubleToString(double _double, CharArray res) {
        this.reuse(_double);
        res.clear();
        res.assertDataLen(this.nDigits + 10);
        char[] result = res.getData();
        int i = 0;
        if (this.isNegative) {
            result[0] = 45;
            i = 1;
        }
        if (this.isExceptional) {
            System.arraycopy(this.digits, 0, result, i, this.nDigits);
            i += this.nDigits;
        } else if (this.decExponent > 0 && this.decExponent < 8) {
            int charLength = Math.min(this.nDigits, this.decExponent);
            System.arraycopy(this.digits, 0, result, i, charLength);
            i += charLength;
            if (charLength < this.decExponent) {
                charLength = this.decExponent - charLength;
                System.arraycopy(zero, 0, result, i, charLength);
                i += charLength;
                result[i++] = 46;
                result[i++] = 48;
            } else {
                result[i++] = 46;
                if (charLength < this.nDigits) {
                    int t = this.nDigits - charLength;
                    System.arraycopy(this.digits, charLength, result, i, t);
                    i += t;
                } else {
                    result[i++] = 48;
                }
            }
        } else if (this.decExponent <= 0 && this.decExponent >= -4) {
            result[i++] = 48;
            result[i++] = 46;
            if (this.decExponent != 0) {
                System.arraycopy(zero, 0, result, i, -this.decExponent);
                i -= this.decExponent;
            }
            System.arraycopy(this.digits, 0, result, i, this.nDigits);
            i += this.nDigits;
        } else {
            int e;
            result[i++] = this.digits[0];
            result[i++] = 46;
            if (this.nDigits > 1) {
                System.arraycopy(this.digits, 1, result, i, this.nDigits - 1);
                i += this.nDigits - 1;
            } else {
                result[i++] = 48;
            }
            result[i++] = 69;
            if (this.decExponent <= 0) {
                result[i++] = 45;
                e = -this.decExponent + 1;
            } else {
                e = this.decExponent - 1;
            }
            if (e <= 9) {
                result[i++] = (char)(e + 48);
            } else if (e <= 99) {
                result[i++] = (char)(e / 10 + 48);
                result[i++] = (char)(e % 10 + 48);
            } else {
                result[i++] = (char)(e / 100 + 48);
                result[i++] = (char)((e %= 100) / 10 + 48);
                result[i++] = (char)(e % 10 + 48);
            }
        }
        res.setSize(i);
    }

    public double stringToDouble(String in) throws NumberFormatException {
        block31: {
            boolean isNegative = false;
            boolean signSeen = false;
            try {
                in = in.trim();
                int l = in.length();
                if (l == 0) {
                    throw new NumberFormatException("empty String");
                }
                if (l >= this.digbuf.length) {
                    in = in.substring(0, this.digbuf.length - 1);
                    l = in.length();
                }
                int i = 0;
                char c = in.charAt(i);
                switch (c) {
                    case '-': {
                        isNegative = true;
                    }
                    case '+': {
                        ++i;
                        signSeen = true;
                    }
                }
                char[] digits = this.digbuf;
                int nDigits = 0;
                boolean decSeen = false;
                int decPt = 0;
                int nLeadZero = 0;
                int nTrailZero = 0;
                block18: while (i < l) {
                    c = in.charAt(i);
                    switch (c) {
                        case '0': {
                            if (nDigits > 0) {
                                ++nTrailZero;
                                break;
                            }
                            ++nLeadZero;
                            break;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            while (nTrailZero > 0) {
                                digits[nDigits++] = 48;
                                --nTrailZero;
                            }
                            digits[nDigits++] = c;
                            break;
                        }
                        case '.': {
                            if (decSeen) {
                                throw new NumberFormatException("multiple points");
                            }
                            decPt = i;
                            if (signSeen) {
                                --decPt;
                            }
                            decSeen = true;
                            break;
                        }
                        default: {
                            break block18;
                        }
                    }
                    ++i;
                }
                if (nDigits == 0) {
                    digits = zero;
                    nDigits = 1;
                    if (nLeadZero == 0) break block31;
                }
                int decExp = decSeen ? decPt - nLeadZero : nDigits + nTrailZero;
                if (i < l && (c = in.charAt(i)) == 'e' || c == 'E') {
                    int expSign = 1;
                    int expVal = 0;
                    int reallyBig = 0xCCCCCCC;
                    boolean expOverflow = false;
                    switch (in.charAt(++i)) {
                        case '-': {
                            expSign = -1;
                        }
                        case '+': {
                            ++i;
                        }
                    }
                    int expAt = i;
                    block20: while (i < l) {
                        if (expVal >= reallyBig) {
                            expOverflow = true;
                        }
                        c = in.charAt(i++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                expVal = expVal * 10 + (c - 48);
                                continue block20;
                            }
                        }
                        --i;
                        break;
                    }
                    int expLimit = 324 + nDigits + nTrailZero;
                    decExp = expOverflow || expVal > expLimit ? expSign * expLimit : (decExp += expSign * expVal);
                    if (i == expAt) break block31;
                }
                if (i >= l || i == l - 1 && (in.charAt(i) == 'f' || in.charAt(i) == 'F' || in.charAt(i) == 'd' || in.charAt(i) == 'D')) {
                    this.reuse(isNegative, decExp, digits, nDigits, false);
                    return this.doubleValue();
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        throw new NumberFormatException(in);
    }

    public double stringToDouble(CharArray in) throws NumberFormatException {
        block30: {
            boolean isNegative = false;
            boolean signSeen = false;
            try {
                in.trim();
                int l = in.getSize();
                if (l == 0) {
                    throw new NumberFormatException("empty String");
                }
                int i = 0;
                char c = in.charAt(i);
                switch (c) {
                    case '-': {
                        isNegative = true;
                    }
                    case '+': {
                        ++i;
                        signSeen = true;
                    }
                }
                char[] digits = this.digbuf;
                int nDigits = 0;
                boolean decSeen = false;
                int decPt = 0;
                int nLeadZero = 0;
                int nTrailZero = 0;
                block18: while (i < l) {
                    c = in.charAt(i);
                    switch (c) {
                        case '0': {
                            if (nDigits > 0) {
                                ++nTrailZero;
                                break;
                            }
                            ++nLeadZero;
                            break;
                        }
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': {
                            while (nTrailZero > 0) {
                                digits[nDigits++] = 48;
                                --nTrailZero;
                            }
                            digits[nDigits++] = c;
                            break;
                        }
                        case '.': {
                            if (decSeen) {
                                throw new NumberFormatException("multiple points");
                            }
                            decPt = i;
                            if (signSeen) {
                                --decPt;
                            }
                            decSeen = true;
                            break;
                        }
                        default: {
                            break block18;
                        }
                    }
                    ++i;
                }
                if (nDigits == 0) {
                    digits = zero;
                    nDigits = 1;
                    if (nLeadZero == 0) break block30;
                }
                int decExp = decSeen ? decPt - nLeadZero : nDigits + nTrailZero;
                if (i < l && (c = in.charAt(i)) == 'e' || c == 'E') {
                    int expSign = 1;
                    int expVal = 0;
                    int reallyBig = 0xCCCCCCC;
                    boolean expOverflow = false;
                    switch (in.charAt(++i)) {
                        case '-': {
                            expSign = -1;
                        }
                        case '+': {
                            ++i;
                        }
                    }
                    int expAt = i;
                    block20: while (i < l) {
                        if (expVal >= reallyBig) {
                            expOverflow = true;
                        }
                        c = in.charAt(i++);
                        switch (c) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                expVal = expVal * 10 + (c - 48);
                                continue block20;
                            }
                        }
                        --i;
                        break;
                    }
                    int expLimit = 324 + nDigits + nTrailZero;
                    decExp = expOverflow || expVal > expLimit ? expSign * expLimit : (decExp += expSign * expVal);
                    if (i == expAt) break block30;
                }
                if (i >= l || i == l - 1 && (in.charAt(i) == 'f' || in.charAt(i) == 'F' || in.charAt(i) == 'd' || in.charAt(i) == 'D')) {
                    this.reuse(isNegative, decExp, digits, nDigits, false);
                    return this.doubleValue();
                }
            }
            catch (StringIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        throw new NumberFormatException(in.toString());
    }

    public double doubleValue() {
        boolean overvalue;
        double t;
        int j;
        int i;
        int kDigits = Math.min(this.nDigits, 16);
        this.roundDir = 0;
        int iValue = this.digits[0] - 48;
        int iDigits = Math.min(kDigits, 9);
        for (i = 1; i < iDigits; ++i) {
            iValue = iValue * 10 + this.digits[i] - 48;
        }
        long lValue = iValue;
        for (i = iDigits; i < kDigits; ++i) {
            lValue = lValue * 10L + (long)(this.digits[i] - 48);
        }
        double dValue = lValue;
        int exp = this.decExponent - kDigits;
        if (this.nDigits <= 15) {
            if (exp == 0) {
                return this.isNegative ? -dValue : dValue;
            }
            if (exp >= 0) {
                if (exp <= maxSmallTen) {
                    double rValue = dValue * small10pow[exp];
                    if (this.mustSetRoundDir) {
                        double tValue = rValue / small10pow[exp];
                        this.roundDir = tValue == dValue ? 0 : (tValue < dValue ? 1 : -1);
                    }
                    return this.isNegative ? -rValue : rValue;
                }
                int slop = 15 - kDigits;
                if (exp <= maxSmallTen + slop) {
                    double rValue = (dValue *= small10pow[slop]) * small10pow[exp - slop];
                    if (this.mustSetRoundDir) {
                        double tValue = rValue / small10pow[exp - slop];
                        this.roundDir = tValue == dValue ? 0 : (tValue < dValue ? 1 : -1);
                    }
                    return this.isNegative ? -rValue : rValue;
                }
            } else if (exp >= -maxSmallTen) {
                double rValue = dValue / small10pow[-exp];
                double tValue = rValue * small10pow[-exp];
                if (this.mustSetRoundDir) {
                    this.roundDir = tValue == dValue ? 0 : (tValue < dValue ? 1 : -1);
                }
                return this.isNegative ? -rValue : rValue;
            }
        }
        if (exp > 0) {
            if (this.decExponent > 309) {
                return this.isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if ((exp & 0xF) != 0) {
                dValue *= small10pow[exp & 0xF];
            }
            if ((exp >>= 4) != 0) {
                j = 0;
                while (exp > 1) {
                    if ((exp & 1) != 0) {
                        dValue *= big10pow[j];
                    }
                    ++j;
                    exp >>= 1;
                }
                t = dValue * big10pow[j];
                if (Double.isInfinite(t)) {
                    t = dValue / 2.0;
                    if (Double.isInfinite(t *= big10pow[j])) {
                        return this.isNegative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                    }
                    t = Double.MAX_VALUE;
                }
                dValue = t;
            }
        } else if (exp < 0) {
            exp = -exp;
            if (this.decExponent < -325) {
                return this.isNegative ? -0.0 : 0.0;
            }
            if ((exp & 0xF) != 0) {
                dValue /= small10pow[exp & 0xF];
            }
            if ((exp >>= 4) != 0) {
                j = 0;
                while (exp > 1) {
                    if ((exp & 1) != 0) {
                        dValue *= tiny10pow[j];
                    }
                    ++j;
                    exp >>= 1;
                }
                t = dValue * tiny10pow[j];
                if (t == 0.0) {
                    t = dValue * 2.0;
                    if ((t *= tiny10pow[j]) == 0.0) {
                        return this.isNegative ? -0.0 : 0.0;
                    }
                    t = Double.MIN_VALUE;
                }
                dValue = t;
            }
        }
        FDBigInt bigD0 = new FDBigInt(lValue, this.digits, kDigits, this.nDigits);
        exp = this.decExponent - this.nDigits;
        do {
            FDBigInt halfUlp;
            FDBigInt diff;
            int D2;
            int D5;
            int B2;
            int B5;
            FDBigInt bigB = this.doubleToBigInt(dValue);
            if (exp >= 0) {
                B5 = 0;
                B2 = 0;
                D2 = D5 = exp;
            } else {
                B2 = B5 = -exp;
                D5 = 0;
                D2 = 0;
            }
            if (this.bigIntExp >= 0) {
                B2 += this.bigIntExp;
            } else {
                D2 -= this.bigIntExp;
            }
            int Ulp2 = B2;
            int hulpbias = this.bigIntExp + this.bigIntNBits <= -1022 ? this.bigIntExp + 1023 + 52 : 54 - this.bigIntNBits;
            int common2 = Math.min(B2 += hulpbias, Math.min(D2 += hulpbias, Ulp2));
            Ulp2 -= common2;
            bigB = this.multPow52(bigB, B5, B2 -= common2);
            FDBigInt bigD = this.multPow52(new FDBigInt(bigD0), D5, D2 -= common2);
            int cmpResult = bigB.cmp(bigD);
            if (cmpResult > 0) {
                overvalue = true;
                diff = bigB.sub(bigD);
                if (this.bigIntNBits == 1 && this.bigIntExp > -1023 && --Ulp2 < 0) {
                    Ulp2 = 0;
                    diff.lshiftMe(1);
                }
            } else {
                if (cmpResult >= 0) break;
                overvalue = false;
                diff = bigD.sub(bigB);
            }
            if ((cmpResult = diff.cmp(halfUlp = this.constructPow52(B5, Ulp2))) < 0) {
                this.roundDir = overvalue ? -1 : 1;
                break;
            }
            if (cmpResult != 0) continue;
            dValue += 0.5 * StaticDouble.ulp(dValue, overvalue);
            this.roundDir = overvalue ? -1 : 1;
            break;
        } while ((dValue += StaticDouble.ulp(dValue, overvalue)) != 0.0 && dValue != Double.POSITIVE_INFINITY);
        return this.isNegative ? -dValue : dValue;
    }

    public float floatValue() {
        int kDigits = Math.min(this.nDigits, 8);
        int iValue = this.digits[0] - 48;
        for (int i = 1; i < kDigits; ++i) {
            iValue = iValue * 10 + this.digits[i] - 48;
        }
        float fValue = iValue;
        int exp = this.decExponent - kDigits;
        if (this.nDigits <= 7) {
            if (exp == 0) {
                return this.isNegative ? -fValue : fValue;
            }
            if (exp >= 0) {
                if (exp <= singleMaxSmallTen) {
                    return this.isNegative ? -fValue : (fValue *= singleSmall10pow[exp]);
                }
                int slop = 7 - kDigits;
                if (exp <= singleMaxSmallTen + slop) {
                    fValue *= singleSmall10pow[slop];
                    return this.isNegative ? -fValue : (fValue *= singleSmall10pow[exp - slop]);
                }
            } else if (exp >= -singleMaxSmallTen) {
                return this.isNegative ? -fValue : (fValue /= singleSmall10pow[-exp]);
            }
        } else if (this.decExponent >= this.nDigits && this.nDigits + this.decExponent <= 15) {
            long lValue = iValue;
            for (int i = kDigits; i < this.nDigits; ++i) {
                lValue = lValue * 10L + (long)(this.digits[i] - 48);
            }
            double dValue = lValue;
            exp = this.decExponent - this.nDigits;
            fValue = (float)(dValue *= small10pow[exp]);
            return this.isNegative ? -fValue : fValue;
        }
        if (this.decExponent > 39) {
            return this.isNegative ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY;
        }
        if (this.decExponent < -46) {
            return this.isNegative ? -0.0f : 0.0f;
        }
        this.mustSetRoundDir = true;
        double dValue = this.doubleValue();
        return this.stickyRound(dValue);
    }

    static {
        small10pow = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22};
        singleSmall10pow = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f};
        big10pow = new double[]{1.0E16, 1.0E32, 1.0E64, 1.0E128, 1.0E256};
        tiny10pow = new double[]{1.0E-16, 1.0E-32, 1.0E-64, 1.0E-128, 1.0E-256};
        maxSmallTen = small10pow.length - 1;
        singleMaxSmallTen = singleSmall10pow.length - 1;
        small5pow = new int[]{1, 5, 25, 125, 625, 3125, 15625, 78125, 390625, 1953125, 9765625, 48828125, 244140625, 1220703125};
        long5pow = new long[]{1L, 5L, 25L, 125L, 625L, 3125L, 15625L, 78125L, 390625L, 1953125L, 9765625L, 48828125L, 244140625L, 1220703125L, 6103515625L, 30517578125L, 152587890625L, 762939453125L, 3814697265625L, 19073486328125L, 95367431640625L, 476837158203125L, 2384185791015625L, 11920928955078125L, 59604644775390625L, 298023223876953125L, 1490116119384765625L};
        n5bits = new int[]{0, 3, 5, 7, 10, 12, 14, 17, 19, 21, 24, 26, 28, 31, 33, 35, 38, 40, 42, 45, 47, 49, 52, 54, 56, 59, 61};
        infinity = new char[]{'I', 'n', 'f', 'i', 'n', 'i', 't', 'y'};
        notANumber = new char[]{'N', 'a', 'N'};
        zero = new char[]{'0', '0', '0', '0', '0', '0', '0', '0'};
    }
}

