/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.DTMFactory;
import com.sap.engine.lib.xsl.xpath.ETBuilder;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathProcessor;
import com.sap.engine.lib.xsl.xpath.xobjects.IntArrayIterator;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xslt.NamespaceManager;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;

public class Main {
    static final String PATH_FILE = "c:\\test\\a000_xp.txt";

    public static void main(String[] args) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(PATH_FILE)));
        XPathProcessor xpp = null;
        XPathContext xpc = null;
        while (true) {
            System.out.println();
            System.out.println("===========================================================================================================================================================");
            try {
                String q = br.readLine();
                if (q == null || q.startsWith("{end}")) break;
                if (q.startsWith("{file}")) {
                    String xml_filename = q.substring(6).trim();
                    System.out.print("--- Creating DTM through file " + xml_filename);
                    DTM dtm = new DTM();
                    DTMFactory dtmfact = new DTMFactory();
                    dtmfact.initialize(dtm, new NamespaceManager());
                    XMLParser xp = new XMLParser();
                    xp.setNamespaces(true);
                    xp.parse(xml_filename, (DocHandler)dtmfact);
                    xpp = new XPathProcessor(dtm);
                    System.out.println("done");
                    xpc = dtm.getInitialContext();
                    continue;
                }
                if (q.startsWith("{context}")) {
                    q = q.substring(9);
                    XNodeSet xns = (XNodeSet)xpp.process(new ETBuilder().process(q), xpc);
                    xpc.node = xns.firstInDocumentOrder();
                    System.out.println("Context node set to: [" + xpc.node + "]");
                    continue;
                }
                if (q.startsWith("{")) {
                    System.out.println("Unrecognized command, " + q);
                    continue;
                }
                if (q.trim().equals("")) continue;
                System.out.println("XPath query: " + q);
                XObject x = xpp.process(new ETBuilder().process(q), xpc);
                System.out.println("--- Evaluated to: " + x.toXString());
                if (x.getType() != 4) continue;
                System.out.print("Iterating: [");
                IntArrayIterator i = ((XNodeSet)x).sensitiveIterator();
                while (i.hasNext()) {
                    System.out.print(" " + i.next());
                }
                System.out.println(" ]");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

