/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

public class IntVector {
    private int DEFAULT_CAPACITY = 16;
    private int RESIZE_STEP = 32;
    int[] a;
    int n;

    public IntVector() {
        this.a = new int[this.DEFAULT_CAPACITY];
        this.n = 0;
    }

    public IntVector(int initialSize, int resizeStep) {
        this.RESIZE_STEP = resizeStep;
        this.a = new int[initialSize];
        this.n = 0;
    }

    public void resize(int capacity1) {
        int[] a1 = new int[capacity1];
        System.arraycopy(this.a, 0, a1, 0, this.a.length);
        this.a = a1;
        this.RESIZE_STEP *= 2;
    }

    public void resize() {
        this.resize(this.a.length + this.RESIZE_STEP);
    }

    public void add(int x) {
        if (this.n == this.a.length) {
            this.resize();
        }
        this.a[this.n] = x;
        ++this.n;
    }

    public void add(int p, int x) {
        if (this.n == this.a.length) {
            this.resize();
        }
        for (int i = this.n; i > p; --i) {
            this.a[i] = this.a[i - 1];
        }
        this.a[p] = x;
        ++this.n;
    }

    public int elementAt(int index) {
        return this.a[index];
    }

    public void setElement(int index, int value) {
        this.a[index] = value;
    }

    public void clear() {
        this.n = 0;
    }

    public void remove(int p) {
        --this.n;
        for (int i = p; i < this.n; ++i) {
            this.a[i] = this.a[i + 1];
        }
    }

    public int indexOf(int v) {
        for (int i = 0; i < this.n; ++i) {
            if (this.a[i] != v) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(int v) {
        return this.indexOf(v) != -1;
    }

    public void removeElement(int v) {
        int x = this.indexOf(v);
        if (x > -1) {
            this.remove(x);
        }
    }

    public String toString() {
        StringBuffer b = new StringBuffer("[ ");
        for (int i = 0; i < this.n; ++i) {
            b.append(this.a[i]).append(' ');
        }
        return b.append("]").toString();
    }

    public int getCapacity() {
        return this.a.length;
    }

    public int size() {
        return this.n;
    }

    public int get(int i) {
        return this.elementAt(i);
    }
}

