/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import com.sap.engine.lib.xsl.xpath.ETFunction;
import com.sap.engine.lib.xsl.xpath.ETItem;
import com.sap.engine.lib.xsl.xpath.ETLocationStep;
import com.sap.engine.lib.xsl.xpath.ETSlash;
import com.sap.engine.lib.xsl.xpath.IntHashtable;
import com.sap.engine.lib.xsl.xpath.IntVector;
import com.sap.engine.lib.xsl.xpath.Symbols;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.xobjects.IntArrayIterator;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XNumber;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import java.util.Vector;

public final class ETPredicate
implements ETItem {
    public ETItem expression;
    public ETItem filter;
    protected XPathContext c = new XPathContext();
    protected int[] iPerfData = null;
    private IntVector nodelist = new IntVector(50, 50);
    private IntVector nodelistnew = new IntVector(50, 50);
    private IntVector nodelisttmp = null;
    private Vector predlist = null;
    private IntHashtable intHash = null;
    private long linkedContextId = -1L;
    private ETLocationStep nodetest = null;

    protected ETPredicate(ETItem expression, ETItem filter) {
        this.expression = expression;
        this.filter = filter;
    }

    public void print(int indent) {
        Symbols.printSpace(indent);
        System.out.println("ETPredicate");
        this.expression.print(indent + 1);
        this.filter.print(indent + 1);
    }

    public XObject evaluate(XPathContext context) throws XPathException {
        int cnt;
        XObject xo;
        if (context.owner != null) {
            context.owner.freeMem();
        }
        if ((xo = this.expression.evaluate(context)).getType() == 6) {
            xo = xo.toXNodeSet();
        }
        if (xo.getType() != 4) {
            throw new XPathException("Filtered expression must evaluate to a node-set.");
        }
        context.dtm = ((XNodeSet)xo).dtm;
        if (((XNodeSet)xo).size() == 0) {
            return xo;
        }
        XNodeSet r = context.getXFactCurrent().getXNodeSet((XNodeSet)xo);
        xo.close();
        if (this.filter instanceof XNumber) {
            double pDouble = ((XNumber)this.filter).getValue();
            int p = (int)pDouble;
            if ((double)p == pDouble && p > 0 && p <= r.count()) {
                int x = r.getKth(p);
                XNodeSet r1 = context.getXFactCurrent().getXNodeSet(r.dtm, x);
                r.close();
                return r1;
            }
            XNodeSet r1 = context.getXFactCurrent().getXNodeSet(r.dtm);
            r.close();
            return r1;
        }
        this.c.reuse(context);
        this.c.size = cnt = r.count();
        int pos = 0;
        XNodeSet iterNS = context.getXFactCurrent().getXNodeSet(r);
        IntArrayIterator i = iterNS.sensitiveIterator();
        XObject preeval = null;
        if (!this.isExpressionContextSensitive(this.filter)) {
            preeval = this.filter.evaluate(context);
        }
        while (i.hasNext()) {
            int x;
            this.c.position = ++pos;
            this.c.node = x = i.next();
            XObject p = null;
            p = preeval != null ? preeval : this.filter.evaluate(this.c);
            if (p.getType() == 1) {
                if (pos != (int)((XNumber)p).getValue()) {
                    r.mark(i);
                }
            } else if (!p.toXBoolean().getValue()) {
                r.mark(i);
            }
            if (preeval != null) continue;
            p.close();
        }
        if (preeval != null) {
            preeval.close();
        }
        iterNS.close();
        i.close();
        r.setForward(true);
        r.compact();
        return r;
    }

    private boolean evalFilter(XPathContext context, XObject p, int pos) throws XPathException {
        context.getXFactCurrent().releaseXObject(p);
        if (p.getType() == 1) {
            return this.c.position == (int)((XNumber)p).getValue();
        }
        return p.toXBoolean().getValue();
    }

    public boolean match(XPathContext context) throws XPathException {
        boolean res = this.expression.match(context);
        if (res) {
            int rrr;
            if (this.linkedContextId != context.contextId) {
                this.intHash = null;
            }
            this.nodelist.clear();
            if (this.intHash == null) {
                this.linkedContextId = context.contextId;
                this.intHash = new IntHashtable(101);
                this.predlist = new Vector();
                this.predlist.clear();
                ETItem curex = this.expression;
                while (!(curex instanceof ETLocationStep)) {
                    if (curex instanceof ETPredicate) {
                        this.predlist.add(((ETPredicate)curex).filter);
                        curex = ((ETPredicate)curex).expression;
                        continue;
                    }
                    if (curex instanceof ETSlash) {
                        curex = ((ETSlash)curex).right;
                        continue;
                    }
                    throw new XPathException("Could not match expression '" + this.expression + "' because of unsuppoted pattern types");
                }
                this.nodetest = (ETLocationStep)curex;
                this.predlist.add(this.filter);
            }
            if ((rrr = this.intHash.get(context.node)) > -1) {
                return rrr != 0;
            }
            int matchNode = context.node;
            int parentNode = context.dtm.parent[matchNode];
            int n = context.dtm.firstChild[parentNode];
            while (n != -1) {
                this.c.reuse(context);
                this.c.node = n;
                if (this.nodetest.match(this.c)) {
                    this.nodelist.add(n);
                }
                n = context.dtm.nextSibling[n];
            }
            this.c.reuse(context);
            for (int ip = 0; ip < this.predlist.size(); ++ip) {
                ETItem f = (ETItem)this.predlist.get(ip);
                this.c.size = this.nodelist.size();
                for (int i = 0; i < this.c.size; ++i) {
                    this.c.position = i + 1;
                    this.c.node = this.nodelist.get(i);
                    if (this.evalFilter(context, f.evaluate(this.c), this.c.position)) {
                        this.nodelistnew.add(this.c.node);
                        this.intHash.put(this.c.node, 1);
                        continue;
                    }
                    this.intHash.put(this.c.node, 0);
                }
                if (this.nodelistnew.indexOf(matchNode) == -1) {
                    return false;
                }
                this.nodelisttmp = this.nodelist;
                this.nodelist = this.nodelistnew;
                this.nodelistnew = this.nodelisttmp;
                this.nodelistnew.clear();
            }
            this.c.position = this.nodelist.indexOf(matchNode) + 1;
            return this.c.position != 0;
        }
        return false;
    }

    public boolean isExpressionContextSensitive(ETItem et) throws XPathException {
        if (et instanceof ETSlash) {
            ETSlash ets = (ETSlash)et;
            if (ets.isUnary) {
                return false;
            }
            if (ets.right instanceof ETLocationStep) {
                return this.isExpressionContextSensitive(ets.left);
            }
            return true;
        }
        if (et instanceof ETLocationStep) {
            return true;
        }
        if (et instanceof ETPredicate) {
            return true;
        }
        if (et instanceof ETFunction) {
            ETFunction etf = (ETFunction)et;
            if (etf.getName().getRawName().equals("current")) {
                return false;
            }
            if (etf.getName().getRawName().equals("key")) {
                return this.isExpressionContextSensitive(etf.arguments[1]);
            }
            return true;
        }
        return true;
    }
}

