/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xsl.xpath;

import com.sap.engine.lib.xml.parser.handlers.NamespaceHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xsl.xpath.ETDocumentRoot;
import com.sap.engine.lib.xsl.xpath.ETFunction;
import com.sap.engine.lib.xsl.xpath.ETItem;
import com.sap.engine.lib.xsl.xpath.ETLocationStep;
import com.sap.engine.lib.xsl.xpath.ETObject;
import com.sap.engine.lib.xsl.xpath.ETPredicate;
import com.sap.engine.lib.xsl.xpath.ETSlash;
import com.sap.engine.lib.xsl.xpath.ETVariableReference;
import com.sap.engine.lib.xsl.xpath.IntStack;
import com.sap.engine.lib.xsl.xpath.IntVector;
import com.sap.engine.lib.xsl.xpath.LibraryManager;
import com.sap.engine.lib.xsl.xpath.StaticDouble;
import com.sap.engine.lib.xsl.xpath.Symbols;
import com.sap.engine.lib.xsl.xpath.XPathAbbreviationExpander;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.XPathTokenizer;
import com.sap.engine.lib.xsl.xpath.xobjects.XObjectFactory;
import com.sap.engine.lib.xsl.xpath.xobjects.XString;
import com.sap.engine.lib.xsl.xslt.NamespaceManager;
import com.sap.engine.lib.xsl.xslt.QName;
import java.util.EmptyStackException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public final class ETBuilder {
    private StaticDouble staticDouble = new StaticDouble();
    private XObjectFactory xobjectsPool = new XObjectFactory(500);
    private NamespaceManager nsmanager = null;
    private NamespaceHandler namespaceHandler = null;
    private XPathTokenizer tokenizerx = new XPathTokenizer();
    private XPathAbbreviationExpander expanderx = new XPathAbbreviationExpander();
    private Vector vsx = new Vector();
    private IntVector vtx = new IntVector();
    private IntVector posx = new IntVector();
    private Vector vs;
    private IntVector vt;
    private int vIndex;
    private Stack stackOpS = new Stack();
    private IntStack stackOpT = new IntStack();
    private Stack stackVal = new Stack();
    private static final Hashtable binaryPrecedence = new Hashtable();
    private static final HashSet binaryFromRightToLeft;
    private static final HashSet unary;
    private static final HashSet specialNodeTests;

    private void perform() throws XPathException {
        String os = (String)this.stackOpS.pop();
        QName qname = this.getQName(os);
        int t = this.stackOpT.pop();
        switch (t) {
            case 10: {
                ETItem operand1 = (ETItem)this.stackVal.pop();
                this.stackVal.push(new ETFunction(qname, operand1));
                break;
            }
            case 11: {
                ETItem operand2 = (ETItem)this.stackVal.pop();
                ETItem operand1 = (ETItem)this.stackVal.pop();
                this.stackVal.push(new ETFunction(qname, operand1, operand2));
                break;
            }
            case 26: {
                ETItem operand2 = (ETItem)this.stackVal.pop();
                ETItem operand1 = (ETItem)this.stackVal.pop();
                this.stackVal.push(new ETSlash(operand1, operand2));
                break;
            }
            case 25: {
                ETItem operand1 = (ETItem)this.stackVal.pop();
                this.stackVal.push(new ETSlash(operand1));
                break;
            }
            case 13: {
                throw new XPathException("Attempt to perform() a T.OPENING_BRACKET.");
            }
            case 15: {
                throw new XPathException("Attempt to perform() a T.OPENING_SQUARE_BRACKET.");
            }
            case 17: {
                throw new XPathException("Attempt to perform() a T.COMMA.");
            }
            case 12: {
                throw new XPathException("Attempt to perform() a T.FUNCTION.");
            }
            default: {
                throw new XPathException("Illegal type of token in stackOp.");
            }
        }
    }

    private String readSpecialNodeTest() throws XPathException {
        String nt = (String)this.vs.elementAt(this.vIndex);
        if (!specialNodeTests.contains(nt)) {
            throw new XPathException("Unrecongnized special node-test, '" + nt + "'.");
        }
        String s2 = (String)this.vs.elementAt(this.vIndex + 2);
        if (nt.equals("processing-instruction") && !")".equals(s2)) {
            if (!")".equals(this.vs.elementAt(this.vIndex + 3))) {
                throw new XPathException("')' expected after special node-test '" + nt + "'.");
            }
            char ch = s2.charAt(0);
            if (ch != '\'' && ch != '\"') {
                throw new XPathException("Parameter of special node-test 'processing-instruction' must be a literal.");
            }
            this.vIndex += 3;
            return nt + "(" + s2 + ")";
        }
        if (!")".equals(s2)) {
            throw new XPathException("')' expected after special node-test '" + nt + "'");
        }
        this.vIndex += 2;
        return nt + "()";
    }

    public ETObject process(CharArray query) throws XPathException {
        return this.process(query.getString());
    }

    public ETObject process(String query) throws XPathException {
        try {
            if (query == null || query.length() == 0) {
                return new ETObject("", null);
            }
            this.vsx.clear();
            this.vtx.clear();
            this.posx.clear();
            this.tokenizerx.process(query, this.vsx, this.vtx, this.posx);
            XPathAbbreviationExpander.process(this.vsx, this.vtx, this.posx);
            return new ETObject(query, this.process(this.vsx, this.vtx, this.posx));
        }
        catch (XPathException _) {
            throw _;
        }
        catch (Exception e) {
            throw new XPathException("Could not process query '" + query + "'", e);
        }
    }

    private ETItem process(Vector vs, IntVector vt, IntVector pos) throws XPathException {
        return this.process(vs, vt, pos, null);
    }

    private ETItem process(Vector vs, IntVector vt, IntVector pos, LibraryManager library) throws XPathException {
        return this.process(vs, vt, library);
    }

    private ETItem process(Vector vs0, IntVector vt0, LibraryManager library0) throws XPathException {
        this.vs = vs0;
        this.vt = vt0;
        this.vs.add(0, "(");
        this.vt.add(0, 13);
        int lastButOne = this.vs.size() - 1;
        this.vs.add(lastButOne, ")");
        this.vt.add(lastButOne, 14);
        boolean oe = false;
        this.stackOpS.clear();
        this.stackOpT.clear();
        this.stackVal.clear();
        try {
            int end = this.vs.size() - 1;
            this.vIndex = 0;
            while (this.vIndex < end) {
                block87: {
                    int type = this.vt.elementAt(this.vIndex);
                    int typeNext = this.vt.elementAt(this.vIndex + 1);
                    String token = (String)this.vs.elementAt(this.vIndex);
                    String tokenNext = (String)this.vs.elementAt(this.vIndex + 1);
                    if (type == 13) {
                        if (oe) {
                            throw new XPathException("Unexpected '('.");
                        }
                        if (typeNext == 14) {
                            throw new XPathException("Useless '()' or empty query string.");
                        }
                        this.stackOpS.push("(");
                        this.stackOpT.push(13);
                    } else {
                        if (type == 14) {
                            block34: while (true) {
                                switch (this.stackOpT.peek()) {
                                    case 13: {
                                        this.stackOpS.pop();
                                        this.stackOpT.pop();
                                        break block87;
                                    }
                                    case 15: {
                                        throw new XPathException("Attempt to close '[' with ')'.");
                                    }
                                    case 10: 
                                    case 25: {
                                        this.perform();
                                        continue block34;
                                    }
                                    case 11: 
                                    case 26: {
                                        this.perform();
                                        continue block34;
                                    }
                                    case 17: {
                                        Vector arguments = new Vector();
                                        arguments.addElement(this.stackVal.pop());
                                        block35: while (true) {
                                            switch (this.stackOpT.peek()) {
                                                case 12: {
                                                    QName qname = this.getQName((String)this.stackOpS.peek());
                                                    this.stackVal.push(new ETFunction(qname, arguments));
                                                    this.stackOpS.pop();
                                                    this.stackOpT.pop();
                                                    break block87;
                                                }
                                                case 17: {
                                                    arguments.insertElementAt(this.stackVal.pop(), 0);
                                                    this.stackOpS.pop();
                                                    this.stackOpT.pop();
                                                    continue block35;
                                                }
                                                default: {
                                                    throw new XPathException("Invalid usage of ','.");
                                                }
                                            }
                                            break;
                                        }
                                    }
                                    case 12: {
                                        Vector argument = new Vector();
                                        argument.addElement(this.stackVal.pop());
                                        String fname = (String)this.stackOpS.peek();
                                        if (fname.equals("function-available") && argument.get(0) instanceof XString) {
                                            CharArray value = ((XString)argument.get(0)).getValue();
                                            argument.set(0, this.xobjectsPool.getXJavaObject(this.getQName(value)));
                                        }
                                        this.stackVal.push(new ETFunction(this.getQName((String)this.stackOpS.peek()), argument));
                                        this.stackOpS.pop();
                                        this.stackOpT.pop();
                                        break block87;
                                    }
                                    default: {
                                        throw new XPathException("Illegal type in stackOp.");
                                    }
                                }
                                break;
                            }
                        }
                        if (type == 15) {
                            if (!oe) {
                                throw new XPathException("Unexpected '['.");
                            }
                            this.stackOpS.push("[");
                            this.stackOpT.push(15);
                            oe = false;
                        } else {
                            if (type == 16) {
                                block36: while (true) {
                                    switch (this.stackOpT.peek()) {
                                        case 15: {
                                            this.stackOpS.pop();
                                            this.stackOpT.pop();
                                            ETItem a2 = (ETItem)this.stackVal.pop();
                                            ETItem a1 = (ETItem)this.stackVal.pop();
                                            this.stackVal.push(new ETPredicate(a1, a2));
                                            break block87;
                                        }
                                        case 13: {
                                            throw new XPathException("Attempt to close '(' with ']'.");
                                        }
                                        case 10: 
                                        case 11: 
                                        case 25: 
                                        case 26: {
                                            this.perform();
                                            continue block36;
                                        }
                                        case 12: 
                                        case 17: {
                                            throw new XPathException("Attempt to close a function's argument list with ']'.");
                                        }
                                        default: {
                                            throw new XPathException("Illegal type in stackOp.");
                                        }
                                    }
                                    break;
                                }
                            }
                            if (type == 17) {
                                if (!oe) {
                                    throw new XPathException("Unexpected ','.");
                                }
                                block37: while (true) {
                                    switch (this.stackOpT.peek()) {
                                        case 12: 
                                        case 13: 
                                        case 17: {
                                            break block37;
                                        }
                                        case 15: {
                                            throw new XPathException("Invalid usage of ','.");
                                        }
                                        case 10: 
                                        case 11: 
                                        case 25: 
                                        case 26: {
                                            this.perform();
                                            continue block37;
                                        }
                                        default: {
                                            throw new XPathException("Illegal type in stackOp.");
                                        }
                                    }
                                    break;
                                }
                                this.stackOpS.push(",");
                                this.stackOpT.push(17);
                                oe = false;
                            } else if (type == 19) {
                                if (oe) {
                                    throw new XPathException("Operator or ')' expected.");
                                }
                                if (typeNext != 5) {
                                    throw new XPathException("A variable name must match the QName production.");
                                }
                                this.stackVal.push(new ETVariableReference(tokenNext));
                                ++this.vIndex;
                                oe = true;
                            } else if (type == 1) {
                                if (oe) {
                                    throw new XPathException("Operator or ')' expected.");
                                }
                                this.stackVal.push(this.xobjectsPool.getXNumber(this.staticDouble.stringToDouble(token)).setClosed(true));
                                oe = true;
                            } else if (type == 6) {
                                if (oe) {
                                    throw new XPathException("Operator or ')' expected.");
                                }
                                this.stackVal.push(this.xobjectsPool.getXString(token.substring(1, token.length() - 1)).setClosed(true));
                                oe = true;
                            } else if (type == 5 && typeNext == 13 && !oe) {
                                if (specialNodeTests.contains(token)) {
                                    String test = this.readSpecialNodeTest();
                                    QName qname = this.getQName(test);
                                    this.stackVal.push(new ETLocationStep("child", qname));
                                    oe = true;
                                } else if (this.vt.elementAt(this.vIndex + 2) == 14) {
                                    this.stackVal.push(new ETFunction(this.getQName(token), new Vector()));
                                    this.vIndex += 2;
                                    oe = !oe;
                                } else {
                                    this.stackOpS.push(token);
                                    this.stackOpT.push(12);
                                    ++this.vIndex;
                                }
                            } else if (oe && binaryPrecedence.containsKey(token)) {
                                int p = (Integer)binaryPrecedence.get(token);
                                block38: while (true) {
                                    switch (this.stackOpT.peek()) {
                                        case 13: 
                                        case 15: {
                                            break block38;
                                        }
                                        case 10: 
                                        case 25: 
                                        case 26: {
                                            this.perform();
                                            continue block38;
                                        }
                                        case 11: {
                                            int q = (Integer)binaryPrecedence.get(this.stackOpS.peek());
                                            if (p > q || p == q && binaryFromRightToLeft.contains(this.stackOpS.peek())) break block38;
                                            this.perform();
                                            continue block38;
                                        }
                                        case 17: {
                                            break block38;
                                        }
                                        case 12: {
                                            break block38;
                                        }
                                        default: {
                                            throw new XPathException("Illegal type in stackOp.");
                                        }
                                    }
                                    break;
                                }
                                this.stackOpS.push(token);
                                this.stackOpT.push(11);
                                oe = false;
                            } else if (oe && type == 24) {
                                while (this.stackOpT.peek() == 26 || this.stackOpT.peek() == 25) {
                                    this.perform();
                                }
                                this.stackOpS.push(token);
                                this.stackOpT.push(26);
                                oe = false;
                            } else if (!oe && unary.contains(token)) {
                                this.stackOpS.push(token);
                                this.stackOpT.push(10);
                            } else if (!oe && type == 24) {
                                if (binaryPrecedence.containsKey(tokenNext) && !tokenNext.equals("*") || typeNext == 17 || typeNext == 14 || typeNext == 16) {
                                    this.stackVal.push(new ETDocumentRoot());
                                    oe = true;
                                } else {
                                    while (this.stackOpT.peek() == 26 || this.stackOpT.peek() == 25) {
                                        this.perform();
                                    }
                                    this.stackOpS.push(token);
                                    this.stackOpT.push(25);
                                }
                            } else if ("*".equals(token) || type == 5) {
                                if (oe) {
                                    throw new XPathException("Operator or ')' expected.");
                                }
                                String axis = "child";
                                String test = token;
                                if ("::".equals(tokenNext) && !"*".equals(token)) {
                                    axis = token;
                                    this.vIndex += 2;
                                    test = (String)this.vs.elementAt(this.vIndex);
                                    if (!"*".equals(test) && !Symbols.isInitialCharForQName(test.charAt(0))) {
                                        throw new XPathException("Node test expected after axis '" + token + "'.");
                                    }
                                    if (this.vt.elementAt(this.vIndex + 1) == 13) {
                                        test = this.readSpecialNodeTest();
                                    }
                                }
                                QName qname = this.getQName(test);
                                this.stackVal.push(new ETLocationStep(axis, qname));
                                oe = true;
                            } else {
                                throw new XPathException("Unexpected token or token not recognized, '" + token + "'.");
                            }
                        }
                    }
                }
                ++this.vIndex;
            }
        }
        catch (EmptyStackException e) {
            throw new XPathException("Error parsing query.", e);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new XPathException("Error parsing query.", e);
        }
        if (!this.stackOpS.isEmpty() || this.stackVal.size() != 1) {
            throw new XPathException("Unexpected end of query.");
        }
        return (ETItem)this.stackVal.pop();
    }

    public void setNamespaceStuff(NamespaceManager nsmanager, NamespaceHandler nshandler) {
        this.nsmanager = nsmanager;
        this.namespaceHandler = nshandler;
    }

    private QName getQName(CharArray s) throws XPathException {
        QName qname = new QName().reuse(s);
        return this.getQName_int(qname);
    }

    private QName getQName(String s) throws XPathException {
        QName qname = new QName().reuse(s);
        return this.getQName_int(qname);
    }

    private QName getQName_int(QName qname) throws XPathException {
        CharArray uri = CharArray.EMPTY;
        if (qname.prefix.length() > 0) {
            try {
                uri = this.namespaceHandler.isMapped(qname.prefix);
            }
            catch (Exception e) {
                throw new XPathException("Prefix not mapped: " + qname.prefix, e);
            }
        }
        qname.setURI(uri, this.nsmanager);
        return qname;
    }

    static {
        binaryPrecedence.put("|", new Integer(1));
        binaryPrecedence.put("or", new Integer(2));
        binaryPrecedence.put("and", new Integer(3));
        binaryPrecedence.put("=", new Integer(4));
        binaryPrecedence.put("!=", new Integer(4));
        binaryPrecedence.put("<", new Integer(5));
        binaryPrecedence.put("<=", new Integer(5));
        binaryPrecedence.put(">", new Integer(5));
        binaryPrecedence.put(">=", new Integer(5));
        binaryPrecedence.put("+", new Integer(6));
        binaryPrecedence.put("-", new Integer(6));
        binaryPrecedence.put("*", new Integer(7));
        binaryPrecedence.put("div", new Integer(7));
        binaryPrecedence.put("mod", new Integer(7));
        binaryFromRightToLeft = new HashSet();
        unary = new HashSet();
        unary.add("-");
        unary.add("+");
        specialNodeTests = new HashSet();
        specialNodeTests.add("processing-instruction");
        specialNodeTests.add("node");
        specialNodeTests.add("text");
        specialNodeTests.add("comment");
    }
}

