/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Hashtable;

public final class StringUtils {
    public static final String[] CH_TO_ENT = new String[256];
    public static final Hashtable ENT_TO_CH = new Hashtable();
    private static final char[] HEX;

    private StringUtils() {
    }

    public static String[] split(String s0) {
        char[] s = s0.toCharArray();
        int ls = s.length;
        int nTokens = 0;
        boolean wsPrev = true;
        for (int i = 0; i < ls; ++i) {
            boolean ws = StringUtils.isWhitespace(s[i]);
            if (wsPrev && !ws) {
                ++nTokens;
            }
            wsPrev = ws;
        }
        String[] tokens = new String[nTokens];
        nTokens = 0;
        wsPrev = true;
        int start = 0;
        for (int i = 0; i < ls; ++i) {
            boolean ws = StringUtils.isWhitespace(s[i]);
            if (wsPrev && !ws) {
                start = i;
            } else if (!wsPrev && ws) {
                tokens[nTokens++] = s0.substring(start, i);
            }
            wsPrev = ws;
        }
        if (!wsPrev) {
            tokens[nTokens++] = s0.substring(start);
        }
        return tokens;
    }

    public static boolean isWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    public static boolean isWhitespace(String s) {
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            if (StringUtils.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String escapeXML(String s) {
        StringBuffer b = new StringBuffer();
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            char ch = s.charAt(i);
            if (ch < '\u0100') {
                String ent = CH_TO_ENT[ch];
                if (ent == null) {
                    b.append(ch);
                    continue;
                }
                b.append('&').append(ent).append(';');
                continue;
            }
            b.append("&#").append((int)ch).append(';');
        }
        return b.toString();
    }

    public static String unescapeXML(String s) {
        StringBuffer b = new StringBuffer();
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            char ch = s.charAt(i);
            try {
                int indexOfColon;
                if (ch == '&' && (indexOfColon = s.indexOf(59, i + 2)) != -1) {
                    String ent = s.substring(i + 1, indexOfColon);
                    if (ent.charAt(0) == '#') {
                        if (ent.charAt(1) == 'x') {
                            i = indexOfColon + 1;
                            ch = (char)Integer.parseInt(ent.substring(2), 16);
                        } else {
                            i = indexOfColon + 1;
                            ch = (char)Integer.parseInt(ent.substring(1));
                        }
                    } else {
                        String v = (String)ENT_TO_CH.get(ent);
                        if (v != null) {
                            ch = v.charAt(0);
                            i = indexOfColon + 1;
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            b.append(ch);
        }
        return b.toString();
    }

    public static String escapeURL(String s) {
        return URLEncoder.encode(s);
    }

    public static String unescapeURL(String s) {
        return URLDecoder.decode(s);
    }

    public static String escapeJava(String s) {
        StringBuffer b = new StringBuffer();
        int ls = s.length();
        block9: for (int i = 0; i < ls; ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\'': {
                    b.append("\\'");
                    continue block9;
                }
                case '\"': {
                    b.append("\\\"");
                    continue block9;
                }
                case '\t': {
                    b.append("\\t");
                    continue block9;
                }
                case '\n': {
                    b.append("\\n");
                    continue block9;
                }
                case '\r': {
                    b.append("\\r");
                    continue block9;
                }
                case '\f': {
                    b.append("\\f");
                    continue block9;
                }
                case '\b': {
                    b.append("\\b");
                    continue block9;
                }
                default: {
                    if (ch > '\u0100') {
                        b.append("\\u" + HEX[ch >>> 12 & 0xF] + HEX[ch >>> 8 & 0xF] + HEX[ch >>> 4 & 0xF] + HEX[ch & 0xF]);
                        continue block9;
                    }
                    b.append(ch);
                }
            }
        }
        return b.toString();
    }

    static {
        StringUtils.CH_TO_ENT[38] = "amp";
        StringUtils.CH_TO_ENT[39] = "apos";
        StringUtils.CH_TO_ENT[34] = "quot";
        StringUtils.CH_TO_ENT[60] = "lt";
        StringUtils.CH_TO_ENT[62] = "gt";
        char[] temp = new char[1];
        for (int i = 0; i < CH_TO_ENT.length; ++i) {
            if (CH_TO_ENT[i] == null) continue;
            temp[0] = (char)i;
            ENT_TO_CH.put(CH_TO_ENT[i], new String(temp));
        }
        HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

