/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.util;

import com.sap.engine.lib.jaxp.TransformerImpl;
import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.lib.xml.SystemProperties;
import com.sap.engine.lib.xml.parser.NestedSAXParseException;
import com.sap.engine.lib.xml.util.AttributeSorter;
import com.sap.engine.lib.xsl.xslt.XSLOutputNode;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class SAXToOutputStreamHandler
implements ContentHandler,
DTDHandler,
ErrorHandler,
DeclHandler,
LexicalHandler {
    public boolean sortAttributes = true;
    public boolean useNamespaces = true;
    public boolean printIgnorableWhitespace = false;
    public boolean disableOutputEscaping = false;
    public String wrapperElementName = "root";
    private Writer writer = null;
    Properties outputProperties = new Properties(TransformerImpl.DEFAULT_OUTPUT_PROPERTIES);
    private static final String lineSeparator = SystemProperties.getProperty("line.separator");
    private NamespaceSupport namespaceSupport = new NamespaceSupport();
    private HashSet cDataSectionElements = new HashSet();
    private boolean indent = true;
    private int method = 1;
    private static final int METHOD_XML = 1;
    private static final int METHOD_HTML = 2;
    private static final int METHOD_TEXT = 3;
    private static final int INDENT_STEP = 4;
    private int currentIndent;
    private int cDataLevel = 0;
    private boolean isInCDATASection = false;
    private AttributeSorter attributeSorter = new AttributeSorter(30);
    private boolean bOwnWriter = false;

    public SAXToOutputStreamHandler() {
    }

    public SAXToOutputStreamHandler(Writer writer, Properties outputProperties) {
        this.setOutputProperties(outputProperties);
        this.setWriter(writer);
        this.bOwnWriter = false;
    }

    public SAXToOutputStreamHandler(OutputStream outputStream, Properties outputProperties) {
        this.setOutputProperties(outputProperties);
        this.setOutputStream(outputStream);
        this.bOwnWriter = false;
    }

    public SAXToOutputStreamHandler(String file) throws IOException {
        this.writer = new BufferedWriter(new FileWriter(file));
        this.bOwnWriter = true;
    }

    public SAXToOutputStreamHandler(Writer writer) {
        this.setWriter(writer);
        this.bOwnWriter = false;
    }

    public SAXToOutputStreamHandler(OutputStream outputStream) {
        this.setOutputStream(outputStream);
        this.bOwnWriter = false;
    }

    public void setOutputStream(OutputStream x) {
        this.writer = new OutputStreamWriter(x);
        this.bOwnWriter = false;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public void setOutputProperties(Properties x) {
        this.outputProperties = (Properties)x.clone();
        this.parseCDataSectionElements(this.outputProperties.getProperty("cdata-section-elements"));
        this.indent = this.isYes(this.outputProperties.getProperty("indent"));
        String s = this.outputProperties.getProperty("method").trim();
        this.method = s.equalsIgnoreCase("html") ? 2 : (s.equalsIgnoreCase("text") ? 3 : 1);
    }

    public void setOutputProperties(XSLOutputNode o) {
        if (o == null) {
            return;
        }
        Properties x = new Properties(TransformerImpl.DEFAULT_OUTPUT_PROPERTIES);
        x.setProperty("cdata-section-elements", o.getCdataSectionElements());
        x.setProperty("doctype-public", o.getDoctypePublic());
        x.setProperty("doctype-system", o.getDoctypeSystem());
        x.setProperty("encoding", o.getEncoding());
        x.setProperty("indent", o.getIndent());
        x.setProperty("media-type", o.getMediaType());
        x.setProperty("method", o.getMethod());
        x.setProperty("omit-xml-declaration", o.getOmitXmlDeclaration());
        x.setProperty("standalone", "");
        x.setProperty("version", o.getVersion());
        this.setOutputProperties(x);
    }

    private void parseCDataSectionElements(String s) {
        this.cDataSectionElements.clear();
        int i = 0;
        int j = 0;
        int l = s.length();
        while (i < l) {
            while (i < l && Symbols.isWhitespace(s.charAt(i))) {
                ++i;
            }
            if (i >= l) break;
            for (j = i; j < l && !Symbols.isWhitespace(s.charAt(j)); ++j) {
            }
            if (i <= j) {
                this.cDataSectionElements.add(s.substring(i, j));
            }
            i = j;
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        this.out("<!NOTATION ");
        if (systemId != null) {
            this.outEscaped(systemId);
        }
        if (publicId != null) {
            this.out("PUBLIC ");
            this.outEscaped(publicId);
        }
        this.out(">");
        this.outln();
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startDocument() throws SAXException {
        if (!this.isYes(this.outputProperties.getProperty("omit-xml-declaration"))) {
            String version = this.outputProperties.getProperty("version").trim();
            String standalone = this.outputProperties.getProperty("standalone");
            String encoding = this.outputProperties.getProperty("encoding").trim();
            if (!version.equals("") && !version.equals("1.0")) {
                throw new SAXException("XML version attributes, other than '1.0' are not supported.");
            }
            this.out("<?xml version=\"1.0\"");
            if (encoding != null && !encoding.equals("")) {
                this.out(" encoding=\"");
                this.outEscaped(encoding);
                this.out("\"");
            }
            if (this.isYes(standalone)) {
                this.out(" standalone=\"yes\"");
            } else if (this.isNo(standalone)) {
                this.out(" standalone=\"no\"");
            }
            this.out("?>");
            this.outln();
            this.outln();
        }
        this.currentIndent = 0;
        if (this.wrapperElementName != null) {
            this.out("<");
            this.out(this.wrapperElementName);
            this.out(">");
            this.outln();
            this.currentIndent = 4;
        }
        this.namespaceSupport.reset();
        this.isInCDATASection = false;
        this.cDataLevel = 0;
    }

    public void endDocument() throws SAXException {
        if (this.wrapperElementName != null) {
            this.outln();
            this.out("</");
            this.out(this.wrapperElementName);
            this.out(">");
            this.outln();
        }
        try {
            if (this.bOwnWriter) {
                this.writer.close();
            }
        }
        catch (IOException e) {
            throw new NestedSAXParseException(e);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.namespaceSupport.pushContext();
        this.namespaceSupport.declarePrefix(prefix, uri);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.namespaceSupport.popContext();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.printIndent();
        this.out("<");
        this.outWithPrefix(uri, localName, qName);
        int attributesLength = attributes.getLength();
        if (this.sortAttributes) {
            this.attributeSorter.process(attributes, this.useNamespaces);
            for (int i = 0; i < attributesLength; ++i) {
                this.out(' ');
                this.outWithPrefix(this.attributeSorter.getURI(i), this.attributeSorter.getLocalName(i), this.attributeSorter.getQName(i));
                this.out("='");
                this.outEscaped(this.attributeSorter.getValue(i));
                this.out("'");
            }
        } else {
            for (int i = 0; i < attributesLength; ++i) {
                this.out(' ');
                this.outWithPrefix(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i));
                this.out("='");
                this.outEscaped(attributes.getValue(i));
                this.out("'");
            }
        }
        this.out(">");
        this.outln();
        this.currentIndent += 4;
        if (this.cDataSectionElements.contains(qName)) {
            ++this.cDataLevel;
        }
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.currentIndent -= 4;
        this.printIndent();
        this.out("</");
        this.outWithPrefix(uri, localName, qName);
        this.out(">");
        if (this.cDataSectionElements.contains(qName)) {
            --this.cDataLevel;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.indent) {
            while (length > 0 && Symbols.isWhitespace(ch[start])) {
                ++start;
                --length;
            }
            while (length > 0 && Symbols.isWhitespace(ch[start + length - 1])) {
                --length;
            }
            this.printIndent();
        }
        if (!this.printIgnorableWhitespace) {
            boolean isWS = true;
            int end = start + length;
            for (int i = start; i < end; ++i) {
                if (Symbols.isWhitespace(ch[i])) continue;
                isWS = false;
                break;
            }
            if (isWS) {
                return;
            }
        }
        if (this.cDataLevel > 0) {
            if (length > 1) {
                this.out("<![CDATA[");
                this.out(ch[start]);
                this.out(ch[start + 1]);
                int end = start + length;
                for (int i = start + 2; i < end; ++i) {
                    if (ch[i - 2] == ']' && ch[i - 1] == ']' && ch[i] == '>') {
                        this.out("]]><![CDATA[");
                    }
                    this.out(ch[i]);
                }
                this.out("]]>");
            } else {
                this.out("<![CDATA[");
                this.out(ch[start]);
                this.out("]]>");
            }
        } else {
            this.outEscaped(ch, start, start + length);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.printIgnorableWhitespace) {
            this.characters(ch, start, start + length);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.printIndent();
        this.out("<?");
        this.out(target);
        this.out(' ');
        this.outEscaped(data);
        this.out("?>");
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        this.printIndent();
        this.out("<!ENTITY ");
        this.out(name);
        if (publicId != null && systemId != null) {
            this.out(" PUBLIC ");
            this.out(publicId);
            this.out(" ");
            this.out(systemId);
        } else if (publicId != null) {
            this.out(" PUBLIC ");
            this.out(publicId);
        } else if (systemId != null) {
            this.out(" SYSTEM ");
            this.out(systemId);
        }
        this.out(">");
        this.outln();
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        this.printIndent();
        this.out("<!ENTITY ");
        this.out(name);
        this.out(' ');
        this.out(value);
        this.out(">");
        this.outln();
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        this.printIndent();
        this.out("<!ATTLIST ");
        this.out(eName);
        this.out(' ');
        this.out(aName);
        this.out(' ');
        this.out(type);
        this.out(' ');
        this.out(valueDefault);
        if (value != null) {
            this.out(' ');
            this.outEscaped(value);
        }
        this.out(">");
        this.outln();
    }

    public void elementDecl(String name, String model) throws SAXException {
        this.printIndent();
        this.out("<!ELEMENT ");
        this.out(name);
        this.out(' ');
        this.out(model);
        this.out(">");
        this.outln();
    }

    public void comment(char[] a, int start, int length) throws SAXException {
        this.out("<!--");
        this.out(a, start, start + length);
        this.out("-->");
        this.outln();
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.out("<!DOCTYPE ");
        this.out(name);
        if (publicId != null) {
            this.out(" PUBLIC ");
            this.out(publicId);
            if (systemId != null) {
                this.out(' ');
                this.out(systemId);
            }
        } else if (systemId != null) {
            this.out(" SYSTEM ");
            this.out(systemId);
        }
        this.out(" [");
        this.outln();
        this.currentIndent += 4;
    }

    public void endDTD() throws SAXException {
        this.currentIndent -= 4;
        this.out("]>");
        this.outln();
        this.outln();
    }

    public void startCDATA() throws SAXException {
        this.out("<![CDATA[");
        this.isInCDATASection = true;
    }

    public void endCDATA() throws SAXException {
        this.out("]]>");
        this.isInCDATASection = false;
    }

    public void startEntity(String name) {
    }

    public void endEntity(String name) {
    }

    public void warning(SAXParseException e) throws SAXException {
    }

    public void error(SAXParseException e) throws SAXException {
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw e;
    }

    private void printIndent() throws SAXException {
        if (this.indent) {
            this.outln();
            for (int i = 0; i < this.currentIndent; ++i) {
                this.out(' ');
            }
        }
    }

    private void outWithPrefix(String uri, String localName, String qName) throws SAXException {
        this.out(qName);
    }

    private boolean isYes(String s) {
        return s != null && s.trim().equalsIgnoreCase("yes");
    }

    private boolean isNo(String s) {
        return s != null && s.trim().equalsIgnoreCase("no");
    }

    private void out(String s) throws SAXException {
        try {
            this.writer.write(s);
        }
        catch (IOException e) {
            this.processIOException(e);
        }
    }

    private void out(char ch) throws SAXException {
        try {
            this.writer.write(ch);
        }
        catch (IOException e) {
            this.processIOException(e);
        }
    }

    private void out(char[] a, int fromIndex, int toIndex) throws SAXException {
        try {
            for (int i = fromIndex; i < toIndex; ++i) {
                this.writer.write(a[i]);
            }
        }
        catch (IOException e) {
            this.processIOException(e);
        }
    }

    private void outEscaped(String s) throws SAXException {
        if (this.disableOutputEscaping || this.isInCDATASection) {
            this.out(s);
            return;
        }
        int ls = s.length();
        for (int i = 0; i < ls; ++i) {
            this.outEscaped(s.charAt(i));
        }
    }

    private void outEscaped(char[] a, int fromIndex, int toIndex) throws SAXException {
        if (this.disableOutputEscaping || this.isInCDATASection) {
            this.out(a, fromIndex, toIndex);
            return;
        }
        for (int i = fromIndex; i < toIndex; ++i) {
            this.outEscaped(a[i]);
        }
    }

    private void outEscaped(char ch) throws SAXException {
        try {
            if (this.disableOutputEscaping || this.isInCDATASection) {
                this.writer.write(ch);
            } else {
                switch (ch) {
                    case '\'': {
                        this.writer.write("&apos;");
                        break;
                    }
                    case '\"': {
                        this.writer.write("&quot;");
                        break;
                    }
                    case '&': {
                        this.writer.write("&amp;");
                        break;
                    }
                    case '<': {
                        this.writer.write("&gt;");
                        break;
                    }
                    case '>': {
                        this.writer.write("&lt;");
                        break;
                    }
                    default: {
                        this.writer.write(ch);
                    }
                }
            }
        }
        catch (IOException e) {
            this.processIOException(e);
        }
    }

    private void outln() throws SAXException {
        if (this.indent) {
            try {
                this.writer.write(lineSeparator);
            }
            catch (IOException e) {
                this.processIOException(e);
            }
        }
    }

    private void processIOException(IOException e) throws SAXException {
        throw new NestedSAXParseException(e);
    }
}

