/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.util;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SAXSplitterHandler
extends DefaultHandler
implements ContentHandler,
DTDHandler,
ErrorHandler,
DeclHandler,
LexicalHandler {
    private static final int INITIAL_SIZE = 10;
    private static final int RESIZE_STEP = 10;
    ContentHandler[] contentHandlers = new ContentHandler[10];
    int nContentHandlers = 0;
    DTDHandler[] dtdHandlers = new DTDHandler[10];
    int nDTDHandlers = 0;
    ErrorHandler[] errorHandlers = new ErrorHandler[10];
    int nErrorHandlers = 0;
    DeclHandler[] declHandlers = new DeclHandler[10];
    int nDeclHandlers = 0;
    LexicalHandler[] lexicalHandlers = new LexicalHandler[10];
    int nLexicalHandlers = 0;

    public SAXSplitterHandler() {
    }

    public SAXSplitterHandler(Object h0) {
        this.addHandler(h0);
    }

    public SAXSplitterHandler(Object h0, Object h1) {
        this.addHandler(h0);
        this.addHandler(h1);
    }

    public SAXSplitterHandler(Object h0, Object h1, Object h2) {
        this.addHandler(h0);
        this.addHandler(h1);
        this.addHandler(h2);
    }

    public void addHandler(Object h) {
        if (h instanceof ContentHandler) {
            this.addContentHandler((ContentHandler)h);
        } else if (h instanceof DTDHandler) {
            this.addDTDHandler((DTDHandler)h);
        } else if (h instanceof ErrorHandler) {
            this.addErrorHandler((ErrorHandler)h);
        } else if (h instanceof DeclHandler) {
            this.addDeclHandler((DeclHandler)h);
        } else if (h instanceof LexicalHandler) {
            this.addLexicalHandler((LexicalHandler)h);
        }
    }

    public void addContentHandler(ContentHandler h) {
        if (this.nContentHandlers == this.contentHandlers.length) {
            ContentHandler[] old = this.contentHandlers;
            this.contentHandlers = new ContentHandler[this.nContentHandlers + 10];
            System.arraycopy(old, 0, this.contentHandlers, 0, this.nContentHandlers);
        }
        this.contentHandlers[this.nContentHandlers] = h;
        ++this.nContentHandlers;
    }

    public void addDTDHandler(DTDHandler h) {
        if (this.nDTDHandlers == this.dtdHandlers.length) {
            DTDHandler[] old = this.dtdHandlers;
            this.dtdHandlers = new DTDHandler[this.nDTDHandlers + 10];
            System.arraycopy(old, 0, this.dtdHandlers, 0, this.nDTDHandlers);
        }
        this.dtdHandlers[this.nDTDHandlers] = h;
        ++this.nDTDHandlers;
    }

    public void addErrorHandler(ErrorHandler h) {
        if (this.nErrorHandlers == this.errorHandlers.length) {
            ErrorHandler[] old = this.errorHandlers;
            this.errorHandlers = new ErrorHandler[this.nErrorHandlers + 10];
            System.arraycopy(old, 0, this.errorHandlers, 0, this.nErrorHandlers);
        }
        this.errorHandlers[this.nErrorHandlers] = h;
        ++this.nErrorHandlers;
    }

    public void addDeclHandler(DeclHandler h) {
        if (this.nDeclHandlers == this.declHandlers.length) {
            DeclHandler[] old = this.declHandlers;
            this.declHandlers = new DeclHandler[this.nDeclHandlers + 10];
            System.arraycopy(old, 0, this.declHandlers, 0, this.nDeclHandlers);
        }
        this.declHandlers[this.nDeclHandlers] = h;
        ++this.nDeclHandlers;
    }

    public void addLexicalHandler(LexicalHandler h) {
        if (this.nLexicalHandlers == this.lexicalHandlers.length) {
            LexicalHandler[] old = this.lexicalHandlers;
            this.lexicalHandlers = new LexicalHandler[this.nLexicalHandlers + 10];
            System.arraycopy(old, 0, this.lexicalHandlers, 0, this.nLexicalHandlers);
        }
        this.lexicalHandlers[this.nLexicalHandlers] = h;
        ++this.nLexicalHandlers;
    }

    public void clearHandlers() {
        this.nContentHandlers = 0;
        this.nDTDHandlers = 0;
        this.nErrorHandlers = 0;
        this.nDeclHandlers = 0;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        for (int i = 0; i < this.nContentHandlers; ++i) {
            this.contentHandlers[i].characters(ch, start, length);
        }
    }

    public void endDocument() throws SAXException {
        for (int i = 0; i < this.nContentHandlers; ++i) {
            this.contentHandlers[i].endDocument();
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        for (int i = 0; i < this.nContentHandlers; ++i) {
            this.contentHandlers[i].endElement(namespaceURI, localName, qName);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        for (int i = 0; i < this.nContentHandlers; ++i) {
            this.contentHandlers[i].endPrefixMapping(prefix);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        for (int i = 0; i < this.nContentHandlers; ++i) {
            this.contentHandlers[i].ignorableWhitespace(ch, start, length);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        for (int i = 0; i < this.nContentHandlers; ++i) {
            this.contentHandlers[i].processingInstruction(target, data);
        }
    }

    public void setDocumentLocator(Locator locator) {
        for (int i = 0; i < this.nContentHandlers; ++i) {
            this.contentHandlers[i].setDocumentLocator(locator);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        for (int i = 0; i < this.nContentHandlers; ++i) {
            this.contentHandlers[i].skippedEntity(name);
        }
    }

    public void startDocument() throws SAXException {
        for (int i = 0; i < this.nContentHandlers; ++i) {
            this.contentHandlers[i].startDocument();
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        for (int i = 0; i < this.nContentHandlers; ++i) {
            this.contentHandlers[i].startElement(uri, localName, qName, atts);
        }
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        for (int i = 0; i < this.nContentHandlers; ++i) {
            this.contentHandlers[i].startPrefixMapping(prefix, uri);
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        for (int i = 0; i < this.nDTDHandlers; ++i) {
            this.dtdHandlers[i].notationDecl(name, publicId, systemId);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        for (int i = 0; i < this.nDTDHandlers; ++i) {
            this.dtdHandlers[i].unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
        for (int i = 0; i < this.nErrorHandlers; ++i) {
            this.errorHandlers[i].warning(exception);
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        for (int i = 0; i < this.nErrorHandlers; ++i) {
            this.errorHandlers[i].error(exception);
        }
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        for (int i = 0; i < this.nErrorHandlers; ++i) {
            this.errorHandlers[i].fatalError(exception);
        }
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
        for (int i = 0; i < this.nDeclHandlers; ++i) {
            this.declHandlers[i].attributeDecl(eName, aName, type, valueDefault, value);
        }
    }

    public void elementDecl(String name, String model) throws SAXException {
        for (int i = 0; i < this.nDeclHandlers; ++i) {
            this.declHandlers[i].elementDecl(name, model);
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
        for (int i = 0; i < this.nDeclHandlers; ++i) {
            this.declHandlers[i].externalEntityDecl(name, publicId, systemId);
        }
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        for (int i = 0; i < this.nDeclHandlers; ++i) {
            this.declHandlers[i].internalEntityDecl(name, value);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        for (int i = 0; i < this.nLexicalHandlers; ++i) {
            this.lexicalHandlers[i].comment(ch, start, length);
        }
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        for (int i = 0; i < this.nLexicalHandlers; ++i) {
            this.lexicalHandlers[i].startDTD(name, publicId, systemId);
        }
    }

    public void endDTD() throws SAXException {
        for (int i = 0; i < this.nLexicalHandlers; ++i) {
            this.lexicalHandlers[i].endDTD();
        }
    }

    public void startCDATA() throws SAXException {
        for (int i = 0; i < this.nLexicalHandlers; ++i) {
            this.lexicalHandlers[i].startCDATA();
        }
    }

    public void endCDATA() throws SAXException {
        for (int i = 0; i < this.nLexicalHandlers; ++i) {
            this.lexicalHandlers[i].endCDATA();
        }
    }

    public void startEntity(String name) throws SAXException {
        for (int i = 0; i < this.nLexicalHandlers; ++i) {
            this.lexicalHandlers[i].startEntity(name);
        }
    }

    public void endEntity(String name) throws SAXException {
        for (int i = 0; i < this.nLexicalHandlers; ++i) {
            this.lexicalHandlers[i].endEntity(name);
        }
    }
}

