/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public class ReaderInputStream
extends InputStream {
    private Reader reader;
    private char[] buf = new char[8192];
    private int bufpos = 0;
    private int buflen = 0;

    public ReaderInputStream(Reader reader) {
        this.reader = reader;
    }

    public int read() throws IOException {
        if (this.buflen == -1) {
            return -1;
        }
        if (this.bufpos == this.buflen) {
            this.buflen = this.reader.read(this.buf);
            this.bufpos = 0;
            if (this.buflen <= 0) {
                return -1;
            }
        }
        char ch = this.buf[this.bufpos++];
        System.out.println("ReaderInputStream.read(): " + (char)ch + "=" + Integer.toHexString(ch));
        return ch;
    }

    public long skip(long n) throws IOException {
        throw new IOException("Not Supported");
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public synchronized void mark(int readlimit) {
    }

    public synchronized void reset() throws IOException {
        throw new IOException("Not Supported");
    }

    public boolean markSupported() {
        return false;
    }

    public int read(char[] dest, int off, int len) throws IOException {
        int cl = Math.min(this.buflen - this.bufpos, len - off);
        System.arraycopy(this.buf, this.bufpos, dest, off, cl);
        this.bufpos += cl;
        if (cl < len - off) {
            this.buflen = this.reader.read(this.buf);
            this.bufpos = 0;
            if (this.buflen == -1) {
                return -1;
            }
        }
        int cl2 = Math.min(this.buflen - this.bufpos, len - (off += cl));
        System.arraycopy(this.buf, this.bufpos, dest, off, cl2);
        this.bufpos += cl2;
        return cl + cl2;
    }
}

