/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.util;

import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarFilter {
    private final int FILTER_COUNT = 5;
    private JarFile jarFile;
    private Manifest manifest;
    private String[] filter;
    private int count;
    private int depth;
    private int first;
    private int second;
    private boolean isActive;

    public JarFilter(String jarName) throws IOException {
        if (jarName == null) {
            throw new IOException("Jar name is null");
        }
        this.jarFile = new JarFile(jarName);
        try {
            this.manifest = this.jarFile.getManifest();
        }
        catch (Exception e) {
            this.manifest = null;
        }
        this.isActive = true;
        this.filter = new String[5];
        this.count = 0;
        Enumeration<JarEntry> entries = this.jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".class")) continue;
            this.addEntry(entry);
        }
    }

    public void print() {
        for (int i = 0; i < 5; ++i) {
            System.out.println(i + " " + this.filter[i]);
        }
    }

    public boolean accept(String name) {
        if (!this.isActive) {
            return true;
        }
        for (int i = 0; i < this.count; ++i) {
            if (!name.startsWith(this.filter[i])) continue;
            return true;
        }
        return false;
    }

    public JarFile getJar() {
        return this.jarFile;
    }

    public Manifest getManifest() {
        return this.manifest;
    }

    public void open(String jarName) throws IOException {
        if (jarName == null) {
            throw new IOException("Jar name is null");
        }
        this.jarFile = new JarFile(jarName);
        try {
            this.manifest = this.jarFile.getManifest();
        }
        catch (Exception e) {
            this.manifest = null;
        }
    }

    private void addEntry(JarEntry entry) {
        if (!this.isActive) {
            return;
        }
        if (this.count < 5) {
            this.filter[this.count++] = entry.getName();
            int maxDepth = -1;
            int pos = -1;
            for (int i = 0; i < this.count - 1; ++i) {
                int m = this.getEqualLength(this.filter[i], this.filter[this.count - 1]);
                if (m == -1) {
                    if (this.filter[i].length() > this.filter[this.count - 1].length()) {
                        this.filter[i] = this.filter[this.count - 1];
                        this.filter[--this.count] = null;
                        this.recheck(i);
                    } else {
                        this.filter[--this.count] = null;
                    }
                    return;
                }
                if (m <= maxDepth) continue;
                maxDepth = m;
                pos = i;
            }
            if (maxDepth > this.depth) {
                this.depth = maxDepth;
                this.first = pos;
                this.second = this.count - 1;
            }
        } else {
            String name = entry.getName();
            int maxDepth = -1;
            int pos = -1;
            for (int i = 0; i < 5; ++i) {
                int m = this.getEqualLength(this.filter[i], name);
                if (m == -1) {
                    if (this.filter[i].length() > name.length()) {
                        this.filter[i] = name;
                        this.recheck(i);
                    }
                    return;
                }
                if (m <= maxDepth) continue;
                maxDepth = m;
                pos = i;
            }
            if (maxDepth > this.depth) {
                this.filter[pos] = name.substring(0, maxDepth);
                this.recheck(pos);
            } else {
                this.merge();
                if (this.isActive) {
                    this.filter[this.second] = name;
                    this.recheck(this.first);
                    this.calculate();
                }
            }
        }
    }

    private int getEqualLength(String a, String b) {
        if (a.length() > b.length()) {
            String c = b;
            b = a;
            a = c;
        }
        for (int i = 0; i < a.length(); ++i) {
            if (a.charAt(i) == b.charAt(i)) continue;
            return i;
        }
        return -1;
    }

    private void merge() {
        if (this.filter[this.first].length() > this.filter[this.second].length()) {
            String c = this.filter[this.first];
            this.filter[this.first] = this.filter[this.second];
            this.filter[this.second] = c;
        }
        if (this.filter[this.first].length() > this.depth) {
            this.filter[this.first] = this.filter[this.first].substring(0, this.depth);
        }
        if (this.depth == 0) {
            this.isActive = false;
            this.filter = null;
        }
    }

    private void calculate() {
        this.depth = -1;
        for (int i = 0; i < this.count; ++i) {
            for (int j = i + 1; j < this.count; ++j) {
                int m = this.getEqualLength(this.filter[i], this.filter[j]);
                if (m == -1 || m <= this.depth) continue;
                this.depth = m;
                this.first = i;
                this.second = j;
            }
        }
    }

    private void recheck(int pos) {
        for (int i = 0; i < this.count; ++i) {
            if (i == pos || !this.filter[i].startsWith(this.filter[pos])) continue;
            if (i < pos) {
                this.filter[i] = this.filter[pos];
                this.filter[pos] = this.filter[--this.count];
                pos = i;
                this.filter[this.count] = null;
                continue;
            }
            this.filter[i] = this.filter[--this.count];
            this.filter[this.count] = null;
            --i;
        }
    }
}

