/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.util;

import com.sap.engine.lib.xml.util.JarFilter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class FileClassLoader
extends ClassLoader {
    protected byte pattern;
    protected final byte EMPTY = 0;
    protected final byte JARS = 1;
    protected final byte DIRS = (byte)2;
    protected final byte MIXED = (byte)3;
    private final int BUFFER_SIZE = 8192;
    protected String name;
    protected String[] jars;
    protected JarFilter[] jarFilters;
    protected String[] dirs;
    protected File[] dirFiles;
    protected int findIndex;
    protected boolean isFindInJar;
    protected ProtectionDomain domain;
    protected Set inloadable = new HashSet();
    protected Set inloadableLocal = new HashSet();
    protected static Set inloadableContainer = new HashSet();
    protected static int hits;

    public FileClassLoader(ClassLoader parent, String name) {
        this(parent, name, null);
    }

    public FileClassLoader(ClassLoader parent, String name, ProtectionDomain domain) {
        super(parent);
        inloadableContainer.add(this.inloadableLocal);
        inloadableContainer.add(this.inloadable);
        this.setName(name);
        this.domain = domain;
        this.pattern = 0;
    }

    public FileClassLoader(ClassLoader parent, String name, String fileName, boolean isJar, ProtectionDomain domain) {
        super(parent);
        this.setName(name);
        this.domain = domain;
        if (isJar) {
            this.pattern = 1;
            this.jars = new String[1];
            this.jars[0] = fileName;
            this.jarFilters = new JarFilter[1];
            this.jarFilters[0] = null;
        } else {
            this.pattern = (byte)2;
            this.dirs = new String[1];
            this.dirs[0] = fileName;
            this.dirFiles = new File[1];
            this.dirFiles[0] = null;
        }
    }

    public FileClassLoader(ClassLoader parent, String name, String[] fileNames, boolean areJars, ProtectionDomain domain) {
        super(parent);
        this.setName(name);
        this.domain = domain;
        if (areJars) {
            this.pattern = 1;
            this.jars = fileNames;
            this.jarFilters = new JarFilter[this.jars.length];
            for (int i = 0; i < this.jarFilters.length; ++i) {
                this.jarFilters[i] = null;
            }
        } else {
            this.pattern = (byte)2;
            this.dirs = fileNames;
            this.dirFiles = new File[this.dirs.length];
            for (int i = 0; i < this.dirFiles.length; ++i) {
                this.dirFiles[i] = null;
            }
        }
    }

    public FileClassLoader(ClassLoader parent, String name, String[] jarNames, String[] dirNames, ProtectionDomain domain) {
        super(parent);
        int i;
        this.setName(name);
        this.domain = domain;
        this.pattern = (byte)3;
        this.jars = jarNames;
        this.dirs = dirNames;
        this.jarFilters = new JarFilter[this.jars.length];
        for (i = 0; i < this.jarFilters.length; ++i) {
            this.jarFilters[i] = null;
        }
        this.dirFiles = new File[this.dirs.length];
        for (i = 0; i < this.dirFiles.length; ++i) {
            this.dirFiles[i] = null;
        }
    }

    public FileClassLoader(ClassLoader parent, String name, File[] dirFiles, ProtectionDomain domain) {
        super(parent);
        this.setName(name);
        this.domain = domain;
        this.dirFiles = dirFiles;
        this.pattern = (byte)2;
        this.dirs = new String[dirFiles.length];
        for (int i = 0; i < this.dirs.length; ++i) {
            this.dirs[i] = dirFiles[i].getAbsolutePath();
        }
    }

    public FileClassLoader(ClassLoader parent, String name, File[] files, boolean areJars, ProtectionDomain domain) {
        super(parent);
        if (!areJars) {
            this.setName(name);
            this.domain = domain;
            this.dirFiles = this.dirFiles;
            this.pattern = (byte)2;
            this.dirs = new String[files.length];
            for (int i = 0; i < this.dirs.length; ++i) {
                this.dirs[i] = files[i].getAbsolutePath();
            }
        } else {
            this.setName(name);
            this.domain = domain;
            this.dirFiles = this.dirFiles;
            this.pattern = 1;
            this.jars = new String[files.length];
            this.jarFilters = new JarFilter[this.jars.length];
            for (int i = 0; i < this.jarFilters.length; ++i) {
                this.jars[i] = files[i].getAbsolutePath();
                this.jarFilters[i] = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getResource(String name) {
        boolean isFindInJarLocal;
        InputStream in;
        URL result;
        ClassLoader parent = this.getParent();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        if ((result = parent.getResource(name)) != null) {
            return result;
        }
        String string = this.name;
        synchronized (string) {
            in = this.getResourceAsStream(name);
            isFindInJarLocal = this.isFindInJar;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
            try {
                if (isFindInJarLocal) {
                    return new URL("jar:file:" + this.jars[this.findIndex] + "!/" + name);
                }
                return new URL("file:" + this.dirs[this.findIndex] + name);
            }
            catch (MalformedURLException murlException) {
                murlException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getResourceAsStream(String name) {
        InputStream in;
        Set set = this.inloadable;
        synchronized (set) {
            if (this.inloadable.contains(name)) {
                return null;
            }
        }
        ClassLoader parent = this.getParent();
        if (parent == null) {
            parent = ClassLoader.getSystemClassLoader();
        }
        if ((in = parent.getResourceAsStream(name)) != null) {
            return in;
        }
        byte[] buffer = this.readResourceData(name, false);
        if (buffer != null) {
            return new ByteArrayInputStream(buffer);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJar(String jar) {
        String string = this.name;
        synchronized (string) {
            if (jar == null) {
                return;
            }
            String[] jars = new String[]{jar};
            this.addJars(jars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJars(String[] names) {
        String string = this.name;
        synchronized (string) {
            if (names == null) {
                return;
            }
            FileClassLoader.clearInloadableContainer();
            switch (this.pattern) {
                case 0: 
                case 2: {
                    this.pattern = (byte)(this.pattern + 1);
                    this.jars = names;
                    this.jarFilters = new JarFilter[this.jars.length];
                    for (int i = 0; i < this.jarFilters.length; ++i) {
                        this.jarFilters[i] = null;
                    }
                    break;
                }
                case 1: 
                case 3: {
                    String[] newJars = new String[this.jars.length + names.length];
                    System.arraycopy(this.jars, 0, newJars, 0, this.jars.length);
                    System.arraycopy(names, 0, newJars, this.jars.length, names.length);
                    this.jars = newJars;
                    JarFilter[] newJarFilters = new JarFilter[this.jars.length];
                    System.arraycopy(this.jarFilters, 0, newJarFilters, 0, this.jarFilters.length);
                    for (int i = this.jarFilters.length; i < newJarFilters.length; ++i) {
                        newJarFilters[i] = null;
                    }
                    this.jarFilters = newJarFilters;
                    break;
                }
            }
        }
    }

    public String[] getJars() {
        return this.jars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDir(String dir) {
        String string = this.name;
        synchronized (string) {
            if (dir == null) {
                return;
            }
            String[] dirs = new String[]{dir};
            this.addDirs(dirs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDirs(String[] names) {
        String string = this.name;
        synchronized (string) {
            if (names == null) {
                return;
            }
            FileClassLoader.clearInloadableContainer();
            switch (this.pattern) {
                case 0: 
                case 1: {
                    this.pattern = (byte)(this.pattern + 2);
                    this.dirs = names;
                    this.dirFiles = new File[this.dirs.length];
                    for (int i = 0; i < this.dirFiles.length; ++i) {
                        this.dirFiles[i] = null;
                    }
                    break;
                }
                case 2: 
                case 3: {
                    String[] newDirs = new String[this.dirs.length + names.length];
                    System.arraycopy(this.dirs, 0, newDirs, 0, this.dirs.length);
                    System.arraycopy(names, 0, newDirs, this.dirs.length, names.length);
                    this.dirs = newDirs;
                    File[] newDirFiles = new File[this.dirs.length];
                    System.arraycopy(this.dirFiles, 0, newDirFiles, 0, this.dirFiles.length);
                    for (int i = this.dirFiles.length; i < newDirFiles.length; ++i) {
                        newDirFiles[i] = null;
                    }
                    this.dirFiles = newDirFiles;
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMixed(File[] files) {
        String string = this.name;
        synchronized (string) {
            int i;
            if (files == null) {
                return;
            }
            Vector<String> jarsTmp = new Vector<String>();
            Vector<String> dirsTmp = new Vector<String>();
            for (int i2 = 0; i2 < files.length; ++i2) {
                String token = files[i2].getPath();
                if (token.endsWith(".jar") || token.endsWith(".zip")) {
                    jarsTmp.add(token);
                    continue;
                }
                dirsTmp.add(token);
            }
            String[] jarsTemp = new String[jarsTmp.size()];
            String[] dirsTemp = new String[dirsTmp.size()];
            for (i = 0; i < jarsTmp.size(); ++i) {
                jarsTemp[i] = (String)jarsTmp.elementAt(i);
            }
            for (i = 0; i < dirsTmp.size(); ++i) {
                dirsTemp[i] = (String)dirsTmp.elementAt(i);
            }
            this.addJars(jarsTemp);
            this.addDirs(dirsTemp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearInloadableContainer() {
        if (inloadableContainer != null) {
            Set set = inloadableContainer;
            synchronized (set) {
                if (inloadableContainer.size() > 0) {
                    int count = 0;
                    Iterator iterator = inloadableContainer.iterator();
                    while (iterator.hasNext()) {
                        Set currentSet = (Set)iterator.next();
                        count += currentSet.size();
                        Set set2 = currentSet;
                        synchronized (set2) {
                            currentSet.clear();
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateJar(String jar, String newFile) throws IOException {
        String string = this.name;
        synchronized (string) {
            if (jar == null) {
                return;
            }
            FileClassLoader.clearInloadableContainer();
            int offset = -1;
            for (int i = 0; i < this.jars.length; ++i) {
                if (!jar.equals(this.jars[i])) continue;
                offset = i;
            }
            if (offset == -1) {
                return;
            }
            File dest = new File(jar);
            File source = new File(newFile);
            if (dest.exists() && source.exists()) {
                RandomAccessFile destFile = new RandomAccessFile(dest, "rw");
                RandomAccessFile sourceFile = new RandomAccessFile(source, "r");
                destFile.seek(0L);
                sourceFile.seek(0L);
                byte[] buffer = new byte[16384];
                int read = sourceFile.read(buffer, 0, buffer.length);
                while (read > 0) {
                    destFile.write(buffer, 0, read);
                    read = sourceFile.read(buffer, 0, buffer.length);
                }
                destFile.setLength(sourceFile.length());
                destFile.close();
                sourceFile.close();
            }
            this.jarFilters[offset] = null;
        }
    }

    protected synchronized Class findClass(String name) throws ClassNotFoundException {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        byte[] buffer = this.readClassData(name);
        this.loadPackageForClass(name);
        c = this.defineClass(name, buffer, 0, buffer.length, this.getProtectionDomain());
        return c;
    }

    protected void loadPackageForClass(String className) {
        String pkgName;
        int index = className.lastIndexOf(46);
        if (index != -1 && this.getPackage(pkgName = className.substring(0, index)) == null) {
            if (this.isFindInJar) {
                Manifest manifest = this.jarFilters[this.findIndex].getManifest();
                this.definePackage(pkgName, manifest);
            } else {
                this.definePackage(pkgName, null, null, null, null, null, null, null);
            }
        }
    }

    protected Package definePackage(String pkgName, Manifest manifest) {
        if (manifest == null) {
            return this.definePackage(pkgName, null, null, null, null, null, null, null);
        }
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        String sealed = null;
        Attributes attributes = manifest.getAttributes(pkgName.replace('.', '/'));
        if (attributes != null) {
            specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            sealed = attributes.getValue(Attributes.Name.SEALED);
        }
        if ((attributes = manifest.getMainAttributes()) != null) {
            if (specTitle == null) {
                specTitle = attributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if (specVersion == null) {
                specVersion = attributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if (specVendor == null) {
                specVendor = attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if (implTitle == null) {
                implTitle = attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if (implVersion == null) {
                implVersion = attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if (implVendor == null) {
                implVendor = attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
            if (sealed == null) {
                sealed = attributes.getValue(Attributes.Name.SEALED);
            }
        }
        return this.definePackage(pkgName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readClassData(String name) throws ClassNotFoundException {
        Set set = this.inloadableLocal;
        synchronized (set) {
            if (this.inloadableLocal.contains(name)) {
                throw new ClassNotFoundException(name);
            }
        }
        if (this.isContainClass(name)) {
            String findName = name.replace('.', '/') + ".class";
            byte[] result = this.readResourceData(findName, true);
            if (result != null) {
                return result;
            }
            Set set2 = this.inloadableLocal;
            synchronized (set2) {
                this.inloadableLocal.add(name);
            }
        }
        throw new ClassNotFoundException(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] readResourceData(String name, boolean filterFlag) {
        String string = this.name;
        synchronized (string) {
            switch (this.pattern) {
                case 0: {
                    return null;
                }
                case 1: {
                    for (int i = 0; i < this.jarFilters.length; ++i) {
                        if (filterFlag && this.jarFilters[i] != null && !this.jarFilters[i].accept(name) || !this.openJar(i)) continue;
                        byte[] result = this.readResourceFromJar(name, this.jarFilters[i].getJar());
                        this.closeJar(i);
                        if (result == null) continue;
                        this.isFindInJar = true;
                        this.findIndex = i;
                        return result;
                    }
                    return null;
                }
                case 2: {
                    for (int i = 0; i < this.dirFiles.length; ++i) {
                        if (!this.isExist(i)) continue;
                        byte[] result = this.readResourceFromDir(name, this.dirFiles[i]);
                        this.releaseDir(i);
                        if (result == null) continue;
                        this.isFindInJar = false;
                        this.findIndex = i;
                        return result;
                    }
                    return null;
                }
                case 3: {
                    byte[] result;
                    int i;
                    for (i = 0; i < this.jarFilters.length; ++i) {
                        if (filterFlag && this.jarFilters[i] != null && !this.jarFilters[i].accept(name) || !this.openJar(i)) continue;
                        result = this.readResourceFromJar(name, this.jarFilters[i].getJar());
                        this.closeJar(i);
                        if (result == null) continue;
                        this.isFindInJar = true;
                        this.findIndex = i;
                        return result;
                    }
                    for (i = 0; i < this.dirFiles.length; ++i) {
                        if (!this.isExist(i)) continue;
                        result = this.readResourceFromDir(name, this.dirFiles[i]);
                        this.releaseDir(i);
                        if (result == null) continue;
                        this.isFindInJar = false;
                        this.findIndex = i;
                        return result;
                    }
                    return null;
                }
            }
            return null;
        }
    }

    protected boolean isContainClass(String name) {
        return true;
    }

    protected ProtectionDomain getProtectionDomain() {
        return this.domain;
    }

    private byte[] readResourceFromJar(String name, JarFile jar) {
        JarEntry entry = jar.getJarEntry(name);
        if (entry == null) {
            return null;
        }
        byte[] byteBuffer = new byte[8192];
        ByteArrayOutputStream buffer = null;
        int offset = 0;
        try {
            InputStream in = jar.getInputStream(entry);
            int read = 0;
            while (read != -1 & offset < 8192) {
                read = in.read(byteBuffer, offset, 8192 - offset);
                if (read == -1) continue;
                offset += read;
            }
            while (read != -1) {
                if (buffer == null) {
                    buffer = new ByteArrayOutputStream(16384);
                }
                buffer.write(byteBuffer, 0, 8192);
                offset = 0;
                while (read != -1 & offset < 8192) {
                    read = in.read(byteBuffer, offset, 8192 - offset);
                    if (read == -1) continue;
                    offset += read;
                }
            }
            if (buffer != null) {
                buffer.write(byteBuffer, 0, offset);
            }
            in.close();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            return null;
        }
        if (buffer != null) {
            try {
                byteBuffer = buffer.toByteArray();
                buffer.close();
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        } else {
            byte[] tempBuffer = new byte[offset];
            System.arraycopy(byteBuffer, 0, tempBuffer, 0, offset);
            byteBuffer = tempBuffer;
        }
        return byteBuffer;
    }

    private byte[] readResourceFromDir(String name, File dir) {
        File f = new File(dir, name);
        if (f.exists()) {
            try {
                RandomAccessFile raf = new RandomAccessFile(f, "r");
                byte[] result = new byte[(int)raf.length()];
                raf.seek(0L);
                raf.read(result, 0, result.length);
                raf.close();
                return result;
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        }
        return null;
    }

    private boolean openJar(int i) {
        if (this.jarFilters[i] == null) {
            try {
                this.jarFilters[i] = new JarFilter(this.jars[i]);
            }
            catch (IOException ioException) {
                return false;
            }
        }
        try {
            this.jarFilters[i].open(this.jars[i]);
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
            return false;
        }
        return true;
    }

    private void closeJar(int i) {
        try {
            this.jarFilters[i].getJar().close();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
        catch (NullPointerException npException) {
            npException.printStackTrace();
        }
    }

    private boolean isExist(int i) {
        if (this.dirFiles[i] == null) {
            this.dirFiles[i] = new File(this.dirs[i]);
        }
        return this.dirFiles[i].exists();
    }

    private void releaseDir(int i) {
        this.dirFiles[i] = null;
    }

    private void setName(String name) {
        this.name = name == null ? "NULL" : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean filterCheck(String className) {
        Object object = this.inloadableLocal;
        synchronized (object) {
            if (this.inloadableLocal.contains(className)) {
                return false;
            }
        }
        if (className.startsWith("[")) {
            return true;
        }
        object = this.name;
        synchronized (object) {
            if (this.pattern == 1) {
                String findName = className.replace('.', '/') + ".class";
                for (int i = 0; i < this.jarFilters.length; ++i) {
                    if (this.jarFilters[i] == null) {
                        try {
                            this.jarFilters[i] = new JarFilter(this.jars[i]);
                        }
                        catch (IOException ioException) {
                            continue;
                        }
                    }
                    if (!this.jarFilters[i].accept(findName)) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
    }
}

