/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.util;

import com.sap.engine.lib.xml.SystemProperties;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DOMDumper {
    private static final String INDENT_STRING = "    ";
    private static final int DISPLAYED_CHARACTER_DATA_LENGTH_LIMIT = 20;
    private static final String LINE_SEPARATOR = SystemProperties.getProperty("line.separator");
    private static final String SUBSTITUTE = "#";

    public void process(Node node) {
        this.process(node, 0);
    }

    private void displayCharacters(CharacterData x) {
        int j;
        int l = x.getLength();
        System.out.print("getData()=\"");
        String s = l <= 20 ? x.getData() : x.substringData(0, 20) + "...";
        int i = 0;
        while ((j = s.indexOf(LINE_SEPARATOR, i)) != -1) {
            System.out.print(SUBSTITUTE);
            System.out.print(s.substring(i, j));
            i = j + LINE_SEPARATOR.length();
        }
        System.out.print(s.substring(i));
        System.out.print("\", getLength()=");
        System.out.print(l);
        System.out.println();
    }

    private void printIndent(int indent) {
        System.out.print("DUMP DOM    ");
        for (int i = 0; i < indent; ++i) {
            System.out.print(INDENT_STRING);
        }
    }

    private void process(Object x, int indent) {
        int i;
        int l;
        Object y;
        if (x == null) {
            this.printIndent(indent);
            System.out.println("null");
            return;
        }
        if (x instanceof Attr) {
            this.printIndent(indent);
            y = (Attr)x;
            System.out.println("Attr: getName()=\"" + y.getName() + "\", getValue()=\"" + y.getValue() + "\", getSpecified()=" + y.getSpecified());
        } else if (x instanceof CDATASection) {
            this.printIndent(indent);
            y = (CDATASection)x;
            System.out.print("CDATASection: ");
            this.displayCharacters((CharacterData)y);
        } else if (x instanceof Comment) {
            this.printIndent(indent);
            y = (Comment)x;
            System.out.print("Comment: ");
            this.displayCharacters((CharacterData)y);
        } else if (x instanceof Document) {
            this.printIndent(indent);
            y = (Document)x;
            System.out.println("Document: getDocumentElement()=[see below]");
            this.process(y.getDocumentElement(), indent + 1);
        } else if (x instanceof DocumentFragment) {
            this.printIndent(indent);
            System.out.println("DocumentFragment");
        } else if (x instanceof DocumentType) {
            this.printIndent(indent);
            System.out.println("DocumentType");
        } else if (x instanceof DOMImplementation) {
            this.printIndent(indent);
            System.out.println("DOMImplementation");
        } else if (x instanceof Element) {
            this.printIndent(indent);
            y = (Element)x;
            System.out.println("Element: getTagName()=\"" + y.getTagName() + "\", getAttributes()=[see below]");
            this.process(y.getAttributes(), indent + 1);
        } else if (x instanceof Entity) {
            this.printIndent(indent);
            System.out.println("Entity");
        } else if (x instanceof EntityReference) {
            this.printIndent(indent);
            System.out.println("EntityReference");
        } else if (x instanceof NamedNodeMap) {
            y = (NamedNodeMap)x;
            l = y.getLength();
            for (i = 0; i < l; ++i) {
                this.process(y.item(i), indent);
            }
        } else if (x instanceof NodeList) {
            y = (NodeList)x;
            l = y.getLength();
            for (i = 0; i < l; ++i) {
                this.process(y.item(i), indent);
            }
        } else if (x instanceof Notation) {
            this.printIndent(indent);
            System.out.println("Notation");
        } else if (x instanceof ProcessingInstruction) {
            this.printIndent(indent);
            y = (ProcessingInstruction)x;
            System.out.println("ProcessingInstruction: getTarget()=\"" + y.getTarget() + "\", getData()=\"" + y.getData() + "\"");
        } else if (x instanceof Text) {
            this.printIndent(indent);
            y = (Text)x;
            System.out.print("Text: ");
            this.displayCharacters((CharacterData)y);
        } else if (x instanceof CharacterData) {
            this.printIndent(indent);
            y = (CharacterData)x;
            System.out.print("CharacterData: ");
            this.displayCharacters((CharacterData)y);
        } else {
            this.printIndent(indent);
            System.out.println("??? - " + x.getClass().getName());
        }
        if (x instanceof Node) {
            for (Node c = ((Node)x).getFirstChild(); c != null; c = c.getNextSibling()) {
                this.process(c, indent + 1);
            }
        }
    }
}

