/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.transform.algorithms;

import com.sap.engine.lib.jaxp.DocHandlerResult;
import com.sap.engine.lib.xml.signature.Data;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xml.signature.transform.algorithms.Canonicalization;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.XPathMatcher;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XObjectFactory;
import com.sap.engine.lib.xsl.xslt.output.CanonicalDocHandlerSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XSLTTransformation
extends Transformation {
    private static XObjectFactory xfactProcess = new XObjectFactory(5000);

    public XSLTTransformation(Object[] args) {
        super(args);
    }

    public XSLTTransformation() {
        this(null);
    }

    public void transform(Data data) throws SignatureException {
        if (this.additionalArgs.length != 1 || !(this.additionalArgs[0] instanceof String) && !(this.additionalArgs[0] instanceof InputStream)) {
            throw new SignatureException("XSLTTransformation expects a one-elemnent array, containing a xslt stylesheet either as a stirng or as an input stream");
        }
        InputStream xslInput = null;
        if (this.additionalArgs[0] instanceof String) {
            String stylesheet = (String)this.additionalArgs[0];
            xslInput = new ByteArrayInputStream(((String)this.additionalArgs[0]).getBytes());
        } else {
            xslInput = (InputStream)this.additionalArgs[0];
        }
        InputStream is = data.getInputStream();
        data.setOctets(XSLTTransformation.transformXSLT(is, xslInput));
    }

    public static byte[] transformXSLT(InputStream xmlInput, InputStream xslInput) throws SignatureException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
            TransformerFactory factory = TransformerFactory.newInstance();
            Object transformer = null;
            Object template = null;
            StreamSource xmlSource = null;
            StreamSource xslSource = null;
            xmlSource = new StreamSource(xmlInput);
            xslSource = new StreamSource(xslInput);
            StreamResult result = new StreamResult(baos);
            factory.newTransformer(xslSource).transform(xmlSource, result);
            byte[] res = baos.toByteArray();
            return res;
        }
        catch (TransformerConfigurationException e) {
            throw new SignatureException(e);
        }
        catch (TransformerException e) {
            throw new SignatureException(e);
        }
    }

    public static byte[] filter(Node n, String query) throws SignatureException {
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
            Properties prop = new Properties();
            Canonicalization.fillMore(prop);
            CanonicalDocHandlerSerializer cdhs = new CanonicalDocHandlerSerializer(baos, prop);
            DOMSource source = new DOMSource(n);
            DocHandlerResult result = new DocHandlerResult(cdhs);
            tr.transform(source, result);
            return baos.toByteArray();
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    public static byte[] filter(byte[] input, String query) throws SignatureException {
        ByteArrayInputStream bais = new ByteArrayInputStream(input);
        return XSLTTransformation.filter(bais, query);
    }

    public static Node filter(String fileName, String query) throws SignatureException {
        try {
            XPathMatcher matcher = new XPathMatcher(fileName);
            XObject result = matcher.process(query);
            result.print(0);
            if (result instanceof XNodeSet) {
                ((XNodeSet)result).dtm.initializeDOM();
                return ((XNodeSet)result).dtm.domtree[0];
            }
            throw new SignatureException("Unexpected return type from XPathQuerry");
        }
        catch (FileNotFoundException e) {
            throw new SignatureException(e);
        }
        catch (XPathException e) {
            throw new SignatureException(e);
        }
    }

    public static byte[] filter(InputStream input, String query) throws SignatureException {
        try {
            XPathMatcher matcher = new XPathMatcher(input);
            XObject result = matcher.process(query);
            if (result instanceof XNodeSet) {
                ((XNodeSet)result).dtm.initializeDOM();
                Document doc = (Document)((XNodeSet)result).dtm.domtree[0];
                return Canonicalization.canonicalize(doc, true);
            }
            throw new SignatureException("Unexpected return type from XPathQuerry");
        }
        catch (FileNotFoundException e) {
            throw new SignatureException(e);
        }
        catch (XPathException e) {
            throw new SignatureException(e);
        }
    }

    public Transformation defineFrom(GenericElement el, HashMap dataHashmap) throws SignatureException {
        throw new SignatureException("defineFrom not implemented for standard transformation: XSLTTransformation!");
    }
}

