/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.transform.algorithms;

import com.sap.engine.lib.xml.parser.handlers.NamespaceHandler;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.signature.Data;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.DTMFactory;
import com.sap.engine.lib.xsl.xpath.ETBuilder;
import com.sap.engine.lib.xsl.xpath.ETObject;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.XPathMatcher;
import com.sap.engine.lib.xsl.xpath.XPathProcessor;
import com.sap.engine.lib.xsl.xpath.xobjects.XBoolean;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XObject;
import com.sap.engine.lib.xsl.xpath.xobjects.XObjectFactory;
import com.sap.engine.lib.xsl.xslt.NamespaceManager;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import org.w3c.dom.Node;

public class XPathTransformation
extends Transformation {
    private static XObjectFactory xfactProcess = new XObjectFactory(5000);
    private Hashtable mappings = new Hashtable();
    public boolean exclusive = false;

    public XPathTransformation(Object[] args) {
        super(args);
    }

    public XPathTransformation() {
        this(null);
    }

    public void addPrefixMapping(String prefix, String uri) {
        this.mappings.put(prefix, uri);
    }

    public void setPrefixMappings(Hashtable newMappings) {
        this.mappings = newMappings;
    }

    public void transform(Data data) throws SignatureException {
        if (this.additionalArgs.length != 2 || !(this.additionalArgs[0] instanceof String) || this.additionalArgs[1] != null && !(this.additionalArgs[1] instanceof Hashtable)) {
            throw new SignatureException("XPathTransformation expects a two-elemnent array, containing a xpath query and a hashtable of prefix mappings");
        }
        String query = (String)this.additionalArgs[0];
        Hashtable bindings = null;
        bindings = this.additionalArgs[1] != null ? (Hashtable)this.additionalArgs[1] : this.mappings;
        InputStream is = data.getInputStream();
        byte[] filtered = XPathTransformation.filterSetToData(is, query, bindings).getOctets();
        data.setOctets(filtered);
    }

    public static Data filterSetToData(InputStream input, String query, Hashtable prefixMappings) throws SignatureException {
        return XPathTransformation.filterSetSpecialToData(input, query, prefixMappings, false, null);
    }

    public static Data filterSetSpecialToData(InputStream input, String query, Hashtable prefixMappings, boolean exclusive, String[] specialPrefixes) throws SignatureException {
        try {
            int[] excludeList = new int[]{};
            NamespaceManager nm = new NamespaceManager();
            NamespaceHandler nh = new NamespaceHandler(null);
            Enumeration vars = prefixMappings.keys();
            while (vars.hasMoreElements()) {
                String nextVar = (String)vars.nextElement();
                String nextVal = (String)prefixMappings.get(nextVar);
                nh.add(new CharArray(nextVar), new CharArray(nextVal));
            }
            XNodeSet result = new XNodeSet();
            DTM dtm = new DTM();
            dtm.setFactories(xfactProcess, null);
            DTMFactory factory = new DTMFactory();
            factory.initialize(dtm, nm, input);
            XPathContext ctx = dtm.getInitialContext();
            XPathProcessor processor = new XPathProcessor(dtm);
            ETBuilder builder = new ETBuilder();
            builder.setNamespaceStuff(nm, nh);
            ETObject processed = builder.process(query);
            result.dtm = dtm;
            ctx.dtm = dtm;
            int length = dtm.nodeType.length;
            for (int i = 0; i < length; ++i) {
                ctx.node = i;
                XObject res = processor.process(processed, ctx);
                if (((XBoolean)(res = res.toXBoolean())).getValue()) continue;
                int[] excludeListTemp = new int[excludeList.length + 1];
                System.arraycopy(excludeList, 0, excludeListTemp, 0, excludeList.length);
                excludeListTemp[excludeListTemp.length - 1] = i;
                excludeList = excludeListTemp;
                result.remove(i);
            }
            if (!exclusive) {
                dtm.reinitializeDOM(excludeList, true);
            } else {
                dtm.reinitializeDOM(excludeList, false, specialPrefixes);
            }
            Node n = dtm.getFragment();
            StringBuffer leadingText = dtm.getLeadingText();
            Data data1 = new Data(leadingText.toString().getBytes());
            Data data2 = new Data(n);
            Data data3 = XPathTransformation.appendDatas(data1, data2);
            return data3;
        }
        catch (XPathException e) {
            throw new SignatureException(e);
        }
    }

    public static Data appendDatas(Data data1, Data data2) throws SignatureException {
        byte[] octets1 = data1.getOctets();
        byte[] octets2 = data2.getOctets();
        if (octets1 == null || octets1.length == 0) {
            return new Data(octets2);
        }
        if (octets2 == null || octets2.length == 0) {
            return new Data(octets1);
        }
        int length1 = octets1.length;
        int length2 = octets2.length;
        int length3 = length1 + length2;
        byte[] octets3 = new byte[length3];
        System.arraycopy(octets1, 0, octets3, 0, length1);
        System.arraycopy(octets2, 0, octets3, length1, length2);
        Data data3 = new Data(octets3);
        return data3;
    }

    public static Node filterSet(InputStream input, String query, Hashtable prefixMappings) throws SignatureException {
        return XPathTransformation.filterSetSpecial(input, query, prefixMappings, false, null);
    }

    public static Node filterSetSpecial(InputStream input, String query, Hashtable prefixMappings, boolean exclusive, String[] specialPrefixes) throws SignatureException {
        return XPathTransformation.filterSetSpecialToData(input, query, prefixMappings, exclusive, specialPrefixes).getNode();
    }

    public static byte[] filterSetToOctets(InputStream input, String query, Hashtable prefixMappings) throws SignatureException {
        return XPathTransformation.filterSetSpecialToOctets(input, query, prefixMappings, false, null);
    }

    public static byte[] filterSetSpecialToOctets(InputStream input, String query, Hashtable prefixMappings, boolean exclusive, String[] specialPrefixes) throws SignatureException {
        return XPathTransformation.filterSetSpecialToData(input, query, prefixMappings, exclusive, specialPrefixes).getOctets();
    }

    public static Node filter(String fileName, String query) throws SignatureException {
        try {
            XPathMatcher matcher = new XPathMatcher(fileName);
            XObject result = matcher.process(query);
            result.print(0);
            if (result instanceof XNodeSet) {
                ((XNodeSet)result).dtm.initializeDOM();
                return ((XNodeSet)result).dtm.domtree[0];
            }
            throw new SignatureException("Unexpected return type from XPathQuerry");
        }
        catch (FileNotFoundException e) {
            throw new SignatureException(e);
        }
        catch (XPathException e) {
            throw new SignatureException(e);
        }
    }

    public Transformation defineFrom(GenericElement el, HashMap dataHashmap) throws SignatureException {
        throw new SignatureException("defineFrom not implemented for standard transformation: XPathTransformation!");
    }
}

