/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.transform.algorithms;

import com.sap.engine.lib.xml.parser.handlers.NamespaceHandler;
import com.sap.engine.lib.xml.signature.Data;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xml.signature.transform.algorithms.Canonicalization;
import com.sap.engine.lib.xml.signature.transform.algorithms.XPathTransformation;
import com.sap.engine.lib.xsl.xpath.DTM;
import com.sap.engine.lib.xsl.xpath.DTMFactory;
import com.sap.engine.lib.xsl.xpath.ETBuilder;
import com.sap.engine.lib.xsl.xpath.XPathContext;
import com.sap.engine.lib.xsl.xpath.XPathException;
import com.sap.engine.lib.xsl.xpath.XPathProcessor;
import com.sap.engine.lib.xsl.xpath.xobjects.XNodeSet;
import com.sap.engine.lib.xsl.xpath.xobjects.XObjectFactory;
import com.sap.engine.lib.xsl.xslt.NamespaceManager;
import java.io.InputStream;
import java.util.HashMap;
import org.w3c.dom.Node;

public class ExclusiveCanonicalization
extends Transformation {
    private boolean commented = false;
    private static XObjectFactory xfactProcess = new XObjectFactory(5000);

    public ExclusiveCanonicalization(Object[] args, boolean commented) {
        super(args);
        this.commented = commented;
    }

    public ExclusiveCanonicalization(boolean commented) {
        this(null, commented);
    }

    public void transform(Data data) throws SignatureException {
        if (this.additionalArgs != null && this.additionalArgs.length != 0) {
            throw new SignatureException("ExclusiveCanonicalization expects no args.");
        }
        InputStream is = data.getInputStream();
        byte[] filtered = this.filterSetToData(is).getOctets();
        data.setOctets(filtered);
    }

    public Data filterSetToData(InputStream input) throws SignatureException {
        return this.filterSetSpecialToData(input, null);
    }

    public Data filterSetSpecialToData(InputStream input, String[] specialPrefixes) throws SignatureException {
        try {
            NamespaceManager nm = new NamespaceManager();
            NamespaceHandler nh = new NamespaceHandler(null);
            XNodeSet result = new XNodeSet();
            DTM dtm = new DTM();
            dtm.setFactories(xfactProcess, null);
            DTMFactory factory = new DTMFactory();
            factory.initialize(dtm, nm, input);
            XPathContext ctx = dtm.getInitialContext();
            XPathProcessor processor = new XPathProcessor(dtm);
            ETBuilder builder = new ETBuilder();
            builder.setNamespaceStuff(nm, nh);
            result.dtm = dtm;
            ctx.dtm = dtm;
            int length = dtm.nodeType.length;
            dtm.reinitializeDOM(new int[0], false, specialPrefixes, true);
            Node n = dtm.getFragment();
            StringBuffer leadingText = dtm.getLeadingText();
            Data data1 = new Data(leadingText.toString().getBytes());
            Data data2 = new Data(n);
            Data data3 = XPathTransformation.appendDatas(data1, data2);
            data3.setOctets(Canonicalization.canonicalize(data3.getOctets(), this.commented));
            return data3;
        }
        catch (XPathException e) {
            throw new SignatureException(e);
        }
    }

    public Transformation defineFrom(GenericElement el, HashMap dataHashmap) throws SignatureException {
        throw new SignatureException("defineFrom not implemented for standard transformation: ExclusiveCanonicailization!");
    }
}

