/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.transform.algorithms;

import com.sap.engine.lib.jaxp.DocHandlerResult;
import com.sap.engine.lib.xml.SystemProperties;
import com.sap.engine.lib.xml.parser.DocHandler;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.parser.XMLParser;
import com.sap.engine.lib.xml.signature.Data;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xml.util.NamespaceAppender;
import com.sap.engine.lib.xsl.xslt.output.CanonicalDocHandlerSerializer;
import com.sap.engine.lib.xsl.xslt.output.OutputException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Canonicalization
extends Transformation {
    private boolean commented = false;

    public Canonicalization(Object[] args, boolean commented) {
        super(args);
        this.commented = commented;
        this.uri = commented ? "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments" : "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    }

    public Canonicalization(boolean commented) {
        this(null, commented);
    }

    private Node canonicalize0(Node n) throws SignatureException {
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
            Properties prop = new Properties();
            Canonicalization.fillMore(prop);
            CanonicalDocHandlerSerializer cdhs = new CanonicalDocHandlerSerializer(baos, prop);
            cdhs.retainComments(this.commented);
            DOMSource source = new DOMSource(n);
            DocHandlerResult result = new DocHandlerResult(cdhs);
            tr.transform(source, result);
            byte[] resOctets = baos.toByteArray();
            SystemProperties.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource is = new InputSource(new ByteArrayInputStream(resOctets));
            Document document = builder.parse(is);
            return document;
        }
        catch (Exception e) {
            throw new SignatureException(e);
        }
    }

    private byte[] octeticalizeOmitting(Node n) throws SignatureException {
        return Canonicalization.canonicalize(n, false);
    }

    private byte[] octeticalizeIncluding(Node n) throws SignatureException {
        return Canonicalization.canonicalize(n, true);
    }

    public void retainComments(boolean commented) {
        this.commented = commented;
    }

    public static Node canonicalizeToNode(byte[] input, boolean retainComments) throws SignatureException {
        try {
            input = Canonicalization.canonicalize(input, retainComments);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            return builder.parse(new ByteArrayInputStream(input));
        }
        catch (ParserConfigurationException e) {
            throw new SignatureException(e);
        }
        catch (SAXException e) {
            throw new SignatureException(e);
        }
        catch (IOException e) {
            throw new SignatureException(e);
        }
    }

    public static byte[] canonicalize(Node n, boolean retainComments) throws SignatureException {
        try {
            Transformer tr = TransformerFactory.newInstance().newTransformer();
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
            Properties prop = new Properties();
            Canonicalization.fillMore(prop);
            CanonicalDocHandlerSerializer cdhs = new CanonicalDocHandlerSerializer(baos, prop);
            cdhs.retainComments(retainComments);
            DOMSource source = new DOMSource(n);
            DocHandlerResult result = new DocHandlerResult(cdhs);
            tr.transform(source, result);
            return baos.toByteArray();
        }
        catch (TransformerConfigurationException e) {
            throw new SignatureException(e);
        }
        catch (TransformerException e) {
            throw new SignatureException(e);
        }
        catch (OutputException e) {
            throw new SignatureException(e);
        }
    }

    public static byte[] canonicalize(byte[] input, boolean retainComments) throws SignatureException {
        ByteArrayInputStream bais = new ByteArrayInputStream(input);
        return Canonicalization.canonicalize(bais, retainComments);
    }

    public static byte[] canonicalize(InputStream input, boolean retainComments) throws SignatureException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(10000);
            Properties prop = new Properties();
            Canonicalization.fillMore(prop);
            CanonicalDocHandlerSerializer cdhs = new CanonicalDocHandlerSerializer(baos, prop);
            cdhs.retainComments(retainComments);
            NamespaceAppender na = new NamespaceAppender(cdhs);
            XMLParser parser = new XMLParser();
            try {
                parser.parse(input, (DocHandler)cdhs);
            }
            catch (Exception e) {
                throw new ParserException(e.toString(), -1, -1);
            }
            return baos.toByteArray();
        }
        catch (OutputException e) {
            throw new SignatureException(e);
        }
        catch (ParserException e) {
            throw new SignatureException(e);
        }
    }

    public byte[] transformToOctets(Node n) throws SignatureException {
        if (!this.commented) {
            return this.octeticalizeOmitting(n);
        }
        return this.octeticalizeIncluding(n);
    }

    public Node transform(Node n) throws SignatureException {
        return this.canonicalize0(n);
    }

    public void transform(Data d) throws SignatureException {
        d.setOctets(Canonicalization.canonicalize(d.getOctets(), this.commented));
    }

    public static void fillMore(Properties p) {
        p.setProperty("method", "xml");
        p.setProperty("encoding", "utf-8");
        p.setProperty("indent", "no");
        p.setProperty("omit-xml-declaration", "yes");
        p.setProperty("cdata-section-elements", "");
    }

    public Transformation defineFrom(GenericElement el, HashMap dataHashmap) throws SignatureException {
        throw new SignatureException("defineFrom not implemented for standard transformation: Canonicalization!");
    }
}

