/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.transform;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Element;

public class TransformationFactory {
    public HashMap dataHashmap = new HashMap();
    public Vector customTransforms = new Vector();

    public static TransformationFactory newInstance() {
        return new TransformationFactory();
    }

    protected TransformationFactory() {
    }

    public void registerTransformation(Transformation tr) {
        this.customTransforms.add(tr);
    }

    public Transformation getInstance(String uri, Object[] additionalArgs) throws SignatureException {
        int length = this.customTransforms.size();
        for (int i = 0; i < length; ++i) {
            Transformation next = (Transformation)this.customTransforms.get(i);
            if (!uri.equals(next.uri)) continue;
            Transformation cloned = next.defineFrom(additionalArgs, this.dataHashmap);
            return cloned;
        }
        return Transformation.getInstance(uri, additionalArgs);
    }

    public Transformation getInstance(GenericElement e) throws SignatureException {
        Transformation custom = this.getCustom(e);
        if (custom != null) {
            return custom;
        }
        String uri = e.getAttribute("Algorithm", null, null);
        if (uri == null) {
            throw new SignatureException("Attribute \"Algorithm \" not found on element " + ((Element)e.getDomRepresentation()).getLocalName());
        }
        Object[] additionalArgs = null;
        if (uri.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) {
            GenericElement xpath = e.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "XPath");
            String query = xpath.getNodeValue();
            Hashtable mappings = e.getNamespaceMappingsInScope();
            additionalArgs = new Object[]{query, mappings};
        }
        return this.getInstance(uri, additionalArgs);
    }

    public Transformation getCustom(GenericElement ge) throws SignatureException {
        int length = this.customTransforms.size();
        for (int i = 0; i < length; ++i) {
            Transformation next = (Transformation)this.customTransforms.get(i);
            Transformation cloned = next.defineFrom(ge, this.dataHashmap);
            if (cloned == null) continue;
            return cloned;
        }
        return null;
    }

    public void add(String key, Object value) {
        this.dataHashmap.put(key, value);
    }
}

