/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.generator;

import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.signature.Constants;
import com.sap.engine.lib.xml.signature.Data;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.elements.KeyInfo;
import com.sap.engine.lib.xml.signature.elements.Object;
import com.sap.engine.lib.xml.signature.elements.Reference;
import com.sap.engine.lib.xml.signature.elements.SignedInfo;
import com.sap.engine.lib.xml.signature.elements.XMLSignature;
import com.sap.engine.lib.xml.signature.generator.XMLSigner;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xml.signature.transform.TransformationFactory;
import com.sap.engine.lib.xml.signature.transform.algorithms.Canonicalization;
import com.sap.engine.lib.xml.signature.transform.algorithms.XPathTransformation;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignatureGenerator
implements XMLSigner {
    private boolean showKeyValue = true;
    private String keyName = null;
    private Certificate[] certs = null;
    private PublicKey publicKey = null;
    private PrivateKey privateKey = null;
    private OutputStream out = null;
    private String digestAlgorithmURI = "http://www.w3.org/2000/09/xmldsig#sha1";
    private String cAlgorithmURI = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private String signatureAlgorithmURI = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private String idNamespaceURI = null;
    private String idLocalName = "Id";
    public boolean skipConsistencyCheck = false;
    public boolean showKeyInfo = true;
    public static String defaultSignatureAlgorithm = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    private Node parent = null;
    private Vector references = new Vector();
    private Vector objects = new Vector();
    private Vector objectIDs = new Vector();

    public void addReference(String uri, Transformation[] transforms, String digestMethod) throws SignatureException {
        this.addReference(null, uri, transforms, digestMethod, null, null);
    }

    public void addReference(String uri, Transformation[] transforms, String digestMethod, String proxyHost, String proxyPort) throws SignatureException {
        this.addReference(null, uri, transforms, digestMethod, proxyHost, proxyPort);
    }

    public void addReference(String canonicalizationURI, String uri, Transformation[] transforms, String digestMethod) throws SignatureException {
        this.addReference(canonicalizationURI, uri, transforms, digestMethod, null, null);
    }

    public void addReference(String canonicalizationURI, String uri, Transformation[] transforms, String digestMethod, String proxyHost, String proxyPort) throws SignatureException {
        if (!this.skipConsistencyCheck) {
            this.checkConsistency(canonicalizationURI, uri, transforms, digestMethod);
        }
        Reference ref = new Reference();
        ref.setURI(uri);
        ref.setTransforms(transforms);
        ref.setDigestURI(digestMethod);
        ref.setProxy(proxyHost, proxyPort);
        this.references.add(ref);
    }

    public void addObject(Node object) {
        this.objects.add(object);
        this.objectIDs.add(null);
    }

    public void addObject(Node object, String id) {
        this.objects.add(object);
        this.objectIDs.add(id);
    }

    public void setIDAttribute(String localName, String uri) {
        this.idLocalName = localName;
        this.idNamespaceURI = uri;
    }

    public void setSignatureAlgorithmURI(String signatureAlgorithmURI) {
        this.signatureAlgorithmURI = signatureAlgorithmURI;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public void setCertificate(Certificate cert) {
        this.certs = new Certificate[]{cert};
    }

    public void setCertificates(Certificate[] certs) {
        this.certs = certs;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setDigestAlgorithm(String digestAlgorithmURI) {
        this.digestAlgorithmURI = digestAlgorithmURI;
    }

    public void setCanonicalizationAlgorithm(String cAlgorithmURI) {
        this.cAlgorithmURI = cAlgorithmURI;
    }

    public void showKeyValue(boolean showKeyValue) {
        this.showKeyValue = showKeyValue;
    }

    public static void signDocument(Element parent) throws SignatureException {
        SignatureGenerator.signDocument(parent, null, null, null);
    }

    public static void signDocument(Element parent, PrivateKey privateKey, Certificate cert) throws SignatureException {
        SignatureGenerator.signDocument(parent, privateKey, null, cert);
    }

    public static void signDocument(Element parent, PrivateKey privateKey, PublicKey publicKey) throws SignatureException {
        SignatureGenerator.signDocument(parent, privateKey, publicKey, null);
    }

    public static void signDocument(Element parent, PrivateKey privateKey, PublicKey publicKey, Certificate cert) throws SignatureException {
        if (publicKey == null && privateKey == null) {
            KeyPairGenerator gen;
            block6: {
                try {
                    if (defaultSignatureAlgorithm.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                        gen = KeyPairGenerator.getInstance("DSA", Constants.STANDARD_PROVIDER);
                        break block6;
                    }
                    if (defaultSignatureAlgorithm.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                        gen = KeyPairGenerator.getInstance("RSA", Constants.STANDARD_PROVIDER);
                        break block6;
                    }
                    throw new SignatureException("Unrecognized default signature algorithm: " + defaultSignatureAlgorithm);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new SignatureException(e);
                }
                catch (NoSuchProviderException e) {
                    throw new SignatureException(e);
                }
            }
            KeyPair pair = gen.genKeyPair();
            privateKey = pair.getPrivate();
            publicKey = pair.getPublic();
        }
        SignatureGenerator generator = new SignatureGenerator();
        Transformation tr1 = TransformationFactory.newInstance().getInstance("http://www.w3.org/2000/09/xmldsig#enveloped-signature", new Object[0]);
        generator.setPrivateKey(privateKey);
        generator.setCertificate(cert);
        generator.setPublicKey(publicKey);
        generator.addReference("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", "", new Transformation[]{tr1}, "http://www.w3.org/2000/09/xmldsig#sha1");
        generator.generate(parent);
    }

    public Node generateHere(Element dummy) throws SignatureException {
        Node parent = dummy.getParentNode();
        if (parent == null) {
            throw new SignatureException("Parent element is null!");
        }
        this.parent = parent;
        Document doc = parent.getOwnerDocument();
        XMLSignature sig = new XMLSignature(parent, dummy, true);
        this.generate(sig);
        return sig.getDomRepresentation();
    }

    public Node generate(Element parent) throws SignatureException {
        if (parent == null) {
            throw new SignatureException("Parent element is null!");
        }
        this.parent = parent;
        Document doc = parent.getOwnerDocument();
        XMLSignature sig = new XMLSignature(parent);
        this.generate(sig);
        return sig.getDomRepresentation();
    }

    public Node generateBefore(Element sibling) throws SignatureException {
        Node parent = sibling.getParentNode();
        if (parent == null) {
            throw new SignatureException("Parent element is null!");
        }
        this.parent = parent;
        Document doc = parent.getOwnerDocument();
        XMLSignature sig = new XMLSignature(parent, sibling, false);
        this.generate(sig);
        return sig.getDomRepresentation();
    }

    private void generate(XMLSignature sig) throws SignatureException {
        try {
            this.appendObjects(sig);
            SignedInfo sInfo = new SignedInfo("http://www.w3.org/2000/09/xmldsig#", "ds:SignedInfo", sig);
            GenericElement sValue = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:SignatureValue", sig);
            GenericElement canonURI = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:CanonicalizationMethod", sInfo);
            GenericElement algURI = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:SignatureMethod", sInfo);
            canonURI.setAttribute("Algorithm", this.cAlgorithmURI);
            algURI.setAttribute("Algorithm", this.signatureAlgorithmURI);
            for (int i = 0; i < this.references.size(); ++i) {
                Reference ref = (Reference)this.references.get(i);
                ref.setEnvelopingElement(this.parent);
                ref.setIDAttribute(this.idLocalName, this.idNamespaceURI);
                ref.digest(sInfo);
            }
            sValue.appendTextChild(new String(this.sign(sInfo, this.privateKey)));
            if (this.showKeyInfo) {
                KeyInfo kInfo = new KeyInfo("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo", sig);
                kInfo.setPrivateKey(this.privateKey);
                kInfo.setPublicKey(this.publicKey);
                if (this.keyName != null) {
                    kInfo.setKeyName(this.keyName);
                    kInfo.addKeyName();
                }
                if (this.certs != null) {
                    kInfo.setCertificates(this.certs);
                    kInfo.addCertificateInfo();
                }
                if (this.showKeyValue && (this.publicKey != null || this.certs != null && this.certs.length > 0)) {
                    kInfo.addKeyValue(this.privateKey.getAlgorithm());
                }
            }
        }
        catch (CertificateEncodingException e) {
            throw new SignatureException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private byte[] sign(SignedInfo sInfo, PrivateKey privateKey) throws NoSuchAlgorithmException, SignatureException {
        Data d = new Data(sInfo.getOwner());
        Hashtable<String, String> nsMappings = new Hashtable<String, String>();
        nsMappings.put("ds", "http://www.w3.org/2000/09/xmldsig#");
        String newSignatureLocator = "ancestor-or-self::ds:SignedInfo and count(ancestor::*/child::node()[name()='ds:SignatureValue'][string()!='']) = 0";
        boolean[] commExcl = SignatureGenerator.detCommExcl(this.cAlgorithmURI);
        boolean retainComments = commExcl[0];
        boolean exclusive = commExcl[1];
        Node toSign = !exclusive ? XPathTransformation.filterSet(d.getInputStream(), newSignatureLocator, nsMappings) : XPathTransformation.filterSetSpecial(d.getInputStream(), newSignatureLocator, nsMappings, true, new String[0]);
        byte[] canonInfo = Canonicalization.canonicalize(toSign, retainComments);
        try {
            void var12_13;
            byte[] xmlSpecific;
            if (this.signatureAlgorithmURI.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
                Signature sig = Signature.getInstance("SHA-1/DSA", Constants.STANDARD_PROVIDER);
                sig.initSign(privateKey);
                sig.update(canonInfo);
                xmlSpecific = SignatureGenerator.Asn1toXMLsignture(sig.sign());
            } else if (this.signatureAlgorithmURI.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
                Signature sig = Signature.getInstance("SHA-1/RSA", Constants.STANDARD_PROVIDER);
                sig.initSign(privateKey);
                sig.update(canonInfo);
                xmlSpecific = sig.sign();
            } else {
                throw new NoSuchAlgorithmException("Unrecognized digest algorithm namespace: " + this.digestAlgorithmURI);
            }
            return BASE64Encoder.encode((byte[])var12_13);
        }
        catch (InvalidKeyException e) {
            throw new SignatureException(e);
        }
        catch (NoSuchProviderException e) {
            throw new SignatureException(e);
        }
        catch (java.security.SignatureException e) {
            throw new SignatureException(e);
        }
    }

    private void appendObjects(XMLSignature sig) throws SignatureException {
        for (int i = 0; i < this.objects.size(); ++i) {
            Object o = new Object(sig);
            o.getDomRepresentation().appendChild(((Node)this.objects.get(i)).cloneNode(true));
            String id = (String)this.objectIDs.get(i);
            if (id == null) continue;
            if (this.idNamespaceURI == null) {
                ((Element)o.getDomRepresentation()).setAttribute("Id", (String)this.objectIDs.get(i));
                continue;
            }
            java.lang.Object idPrefix = null;
            Hashtable nsMappings = DOM.getNamespaceMappingsInScopeSpecial((Node)((java.lang.Object)o));
            Enumeration keys = nsMappings.keys();
            while (keys.hasMoreElements()) {
                String nextPrefix = (String)keys.nextElement();
                String nextUri = (String)nsMappings.get(nextPrefix);
                if (!nextUri.equals(this.idNamespaceURI)) continue;
                ((Element)o.getDomRepresentation()).setAttributeNS(nextUri, nextPrefix + ":" + nextUri, (String)this.objectIDs.get(i));
            }
        }
    }

    public static boolean[] detCommExcl(String canonURI) throws SignatureException {
        String url;
        boolean[] commExcl = new boolean[2];
        int sharpIndex = canonURI.indexOf(35);
        if (sharpIndex >= 0) {
            commExcl[0] = canonURI.substring(sharpIndex).equals("WithComments");
            url = canonURI.substring(0, sharpIndex);
        } else {
            commExcl[0] = false;
            url = canonURI;
        }
        if (url.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
            commExcl[1] = true;
            return commExcl;
        }
        if (url.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315")) {
            commExcl[1] = false;
            return commExcl;
        }
        if (canonURI.equals("http://www.w3.org/2000/09/xmldsig#excludeC14N")) {
            commExcl[0] = true;
            commExcl[1] = true;
            return commExcl;
        }
        if (canonURI.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) {
            commExcl[0] = false;
            commExcl[1] = true;
            return commExcl;
        }
        throw new SignatureException("Unrecognized canonicalization method uri : " + canonURI);
    }

    private void checkConsistency(String canonicalizationURI, String uri, Transformation[] transforms, String digestMethod) throws SignatureException {
        if (!uri.equals("")) {
            for (int i = 0; i < transforms.length; ++i) {
                if (!transforms[i].uri.equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature")) continue;
                throw new SignatureException("Enveloped signatures can be done only on same-document references.");
            }
        }
        if (uri.equals("") && transforms.length < 1) {
            throw new SignatureException("An empty uri (same document) reference without a transformation would surely be invalid!");
        }
    }

    private static byte[] Asn1toXMLsignture(byte[] asn1Octets) throws SignatureException {
        int sLength;
        int j;
        int rLength;
        int i;
        for (i = rLength = asn1Octets[3]; i > 0 && asn1Octets[4 + rLength - i] == 0; --i) {
        }
        for (j = sLength = asn1Octets[5 + rLength]; j > 0 && asn1Octets[6 + rLength + sLength - j] == 0; --j) {
        }
        if (asn1Octets[0] != 48 || asn1Octets[1] != asn1Octets.length - 2 || asn1Octets[2] != 2 || i > 20 || asn1Octets[4 + rLength] != 2 || j > 20) {
            throw new SignatureException("Invalid format for DSA");
        }
        byte[] signatureOctets = new byte[40];
        System.arraycopy(asn1Octets, 4 + rLength - i, signatureOctets, 20 - i, i);
        System.arraycopy(asn1Octets, 6 + rLength + sLength - j, signatureOctets, 40 - j, j);
        return signatureOctets;
    }
}

