/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.generator;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.elements.KeyInfo;
import com.sap.engine.lib.xml.signature.elements.RetrievalMethod;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.Certificate;
import org.w3c.dom.Node;

public class KeyInfoGenerator {
    private KeyInfo ki = null;
    private GenericElement refList = null;

    public void init(Node parent) throws SignatureException {
        if (parent != null) {
            this.ki = new KeyInfo(parent);
        } else {
            this.ki = new KeyInfo();
            this.ki.initDOM();
        }
    }

    public void setKeyName(String keyName) throws SignatureException {
        GenericElement name = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:KeyName", this.ki);
        name.appendTextChild(keyName);
    }

    public void setCertificate(Certificate cert) throws SignatureException {
        this.setCertificates(new Certificate[]{cert});
    }

    public void setCertificates(Certificate[] certs) throws SignatureException {
        try {
            this.ki.setCertificates(certs);
            this.ki.addCertificateInfo();
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException(e);
        }
    }

    public void addKeyValue(Key key) throws SignatureException {
        if (key instanceof PublicKey) {
            this.ki.setPublicKey((PublicKey)key);
            this.ki.addKeyValue(key.getAlgorithm());
        }
    }

    public void setRetrievalMethod(String uri, String type, Transformation[] tr) throws SignatureException {
        RetrievalMethod meth = new RetrievalMethod(uri);
        meth.setTransforms(tr);
        meth.construct(this.ki);
        if (type != null) {
            meth.setAttribute("type", type);
        }
    }

    public KeyInfo getKeyInfo() throws SignatureException {
        return this.ki;
    }
}

