/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption.keytrans.algorithms;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.encryption.RandomNumberGenerator;
import com.sap.engine.lib.xml.signature.encryption.keytrans.KeyTransporter;
import java.security.Key;
import java.security.interfaces.RSAKey;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;

public class RSA_1_5_Transporter
extends KeyTransporter {
    public byte[] encrypt(Key wrapping, Key wrapped) throws SignatureException {
        this.mode = 1;
        this.cryptMode = "ECB";
        this.key = wrapping;
        this.createCipher("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        try {
            byte[] bytes = wrapped.getEncoded();
            int inlen = bytes.length;
            int modlen = ((RSAKey)((Object)wrapping)).getModulus().toByteArray().length;
            byte[] block = new byte[modlen - 1];
            block[0] = 2;
            for (int i = 1; i < modlen - inlen - 2; ++i) {
                while (block[i] == 0) {
                    block[i] = (byte)RandomNumberGenerator.nextInt();
                }
            }
            block[modlen - inlen - 2] = 0;
            System.arraycopy(bytes, 0, block, modlen - inlen - 1, inlen);
            return this.cipher.doFinal(block, 0, block.length);
        }
        catch (BadPaddingException e) {
            throw new SignatureException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SignatureException(e);
        }
    }

    public byte[] decrypt(Key wrapping, byte[] wrapped) throws SignatureException {
        try {
            this.mode = 2;
            this.cryptMode = "ECB";
            this.key = wrapping;
            this.createCipher("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
            byte[] block = this.cipher.doFinal(wrapped, 0, wrapped.length);
            if (block[0] != 2) {
                throw new SignatureException("Invalid encrypted key!");
            }
            int start = 1;
            while (block[start++] != 0) {
            }
            byte[] result = new byte[block.length - start];
            System.arraycopy(block, start, result, 0, result.length);
            return result;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new SignatureException(e);
        }
        catch (BadPaddingException e) {
            throw new SignatureException(e);
        }
        catch (IllegalBlockSizeException e) {
            throw new SignatureException(e);
        }
    }
}

