/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.encryption.CipherData;
import com.sap.engine.lib.xml.signature.encryption.CipherReference;
import com.sap.engine.lib.xml.signature.encryption.EncReference;
import com.sap.engine.lib.xml.signature.encryption.EncryptedData;
import com.sap.engine.lib.xml.signature.encryption.EncryptedKey;
import com.sap.engine.lib.xml.signature.encryption.EncryptionMethod;
import com.sap.engine.lib.xml.signature.encryption.XMLCryptor;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLEncryptor
extends XMLCryptor {
    public XMLEncryptor() {
        this.mode = 1;
    }

    public static Node createEncryptedKey(String recipient, String carriedKeyName, Transformation[] transforms, String uri, boolean dataReference) throws SignatureException {
        EncryptedKey ek = new EncryptedKey();
        if (recipient != null) {
            ek.setAttribute("Recipient", recipient);
        }
        if (carriedKeyName != null) {
            GenericElement ckn = new GenericElement("http://www.w3.org/2001/04/xmlenc#", "xenc:CarriedKeyName", ek);
            ckn.appendTextChild(carriedKeyName);
        }
        if (transforms != null) {
            GenericElement refList = new GenericElement("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList", ek);
            EncReference cr = new EncReference(uri, true);
            cr.setTransforms(transforms);
            cr.construct(refList);
        }
        return ek.getOwner();
    }

    public Node encrypt(Element el, String algorithmURI, boolean contentOnly) throws SignatureException {
        return this.replaceWithEncryptedData(el, el, algorithmURI, contentOnly);
    }

    public void encryptIndirectly(Element whereToPutData, Element parent, Element el, String algorithmURI, boolean contentOnly, String uri, Transformation[] transforms) throws SignatureException {
        try {
            String base64Encrypted = this.getBase64EncryptedData(el, algorithmURI, contentOnly);
            String type = contentOnly ? "http://www.w3.org/2001/04/xmlenc#Content" : "http://www.w3.org/2001/04/xmlenc#Element";
            XMLEncryptor.deleteContent(whereToPutData);
            Document doc = whereToPutData.getOwnerDocument();
            whereToPutData.appendChild(doc.createTextNode(base64Encrypted));
            EncryptedData encData = new EncryptedData(parent);
            encData.setType(type);
            encData.construct();
            EncryptionMethod m = new EncryptionMethod(encData);
            m.setAlgorithmURI(algorithmURI);
            m.construct();
            CipherData cd = new CipherData(encData);
            CipherReference cr = new CipherReference(uri);
            cr.setTransforms(transforms);
            cr.construct(cd);
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException(e);
        }
    }

    private Node replaceWithEncryptedData(Element toReplace, Element el, String algorithmURI, boolean contentOnly) throws SignatureException {
        try {
            String base64Encrypted = this.getBase64EncryptedData(el, algorithmURI, contentOnly);
            String type = contentOnly ? "http://www.w3.org/2001/04/xmlenc#Content" : "http://www.w3.org/2001/04/xmlenc#Element";
            Node parent = null;
            int index = 0;
            if (contentOnly) {
                parent = toReplace;
                NodeList childList = parent.getChildNodes();
                for (int i = childList.getLength(); i > 0; --i) {
                    parent.removeChild(childList.item(i - 1));
                }
            } else {
                parent = toReplace.getParentNode();
                index = XMLEncryptor.getChildIndex(toReplace);
                parent.removeChild(toReplace);
            }
            EncryptedData encData = new EncryptedData(parent, index);
            encData.setType(type);
            encData.construct();
            EncryptionMethod eM = new EncryptionMethod(algorithmURI, null, (GenericElement)encData);
            eM.construct();
            CipherData cD = new CipherData(encData);
            cD.setCipherValue(base64Encrypted);
            cD.construct();
            return encData.getDomRepresentation();
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException(e);
        }
    }

    public Node getEncrypted(Element el, String algorithmURI, boolean contentOnly) throws SignatureException {
        try {
            String base64Encrypted = this.getBase64EncryptedData(el, algorithmURI, contentOnly);
            String type = contentOnly ? "http://www.w3.org/2001/04/xmlenc#Content" : "http://www.w3.org/2001/04/xmlenc#Element";
            EncryptedData encData = new EncryptedData(el);
            encData.setType(type);
            encData.construct();
            EncryptionMethod eM = new EncryptionMethod(algorithmURI, null, (GenericElement)encData);
            eM.construct();
            CipherData cD = new CipherData(encData);
            cD.setCipherValue(base64Encrypted);
            cD.construct();
            Node eData = encData.getDomRepresentation();
            el.removeChild(eData);
            return encData.getDomRepresentation();
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException(e);
        }
    }

    public byte[] encryptRaw(byte[] input, String algorithmURI) throws SignatureException {
        try {
            this.createCipher(algorithmURI);
            byte[] encryptedData = this.encrypt0(input);
            this.updateParameters();
            return encryptedData;
        }
        catch (IOException e) {
            throw new SignatureException(e);
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException(e);
        }
    }

    private String getBase64EncryptedData(Element el, String algorithmURI, boolean contentOnly) throws SignatureException, GeneralSecurityException {
        try {
            this.createCipher(algorithmURI);
            byte[] encryptedData = this.encrypt0(el, contentOnly);
            this.updateParameters();
            String base64Encrypted = new String(BASE64Encoder.encode(encryptedData));
            return base64Encrypted;
        }
        catch (IOException e) {
            throw new SignatureException(e);
        }
    }

    private static int getChildIndex(Element el) {
        Node parent = el.getParentNode();
        if (parent == null) {
            return -1;
        }
        int index = 0;
        Node previous = el;
        while ((previous = previous.getPreviousSibling()) != null) {
            ++index;
        }
        return index;
    }
}

