/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption;

import com.sap.engine.lib.xml.signature.Data;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.encryption.CipherReference;
import com.sap.engine.lib.xml.signature.encryption.EncryptedData;
import com.sap.engine.lib.xml.signature.encryption.XMLCryptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLDecryptor
extends XMLCryptor {
    private EncryptedData encryptedData = null;

    public XMLDecryptor() {
        this.mode = 2;
    }

    private static String deduceAlgorithm(EncryptedData encData) throws SignatureException {
        GenericElement encMethod = encData.getEncryptionMethod();
        if (encMethod == null || encMethod.getAttribute("Algorithm", null, null) == null) {
            return null;
        }
        return encMethod.getAttribute("Algorithm", null, null);
    }

    public String decryptEncData(Element el) throws SignatureException {
        return this.decryptEncData(el, null);
    }

    public String decryptEncData(Node n, String algorithmURI) throws SignatureException {
        if (n instanceof Element) {
            return this.decryptEncData((Element)n, algorithmURI);
        }
        if (n instanceof Document) {
            return this.decryptEncData(((Document)n).getDocumentElement(), algorithmURI);
        }
        throw new SignatureException("Can decrypt Document or Element only!");
    }

    public String decryptEncData(Element el, String algorithmURI) throws SignatureException {
        EncryptedData encData = new EncryptedData(el, true);
        encData.initializeDescendants();
        if (algorithmURI == null) {
            algorithmURI = XMLDecryptor.deduceAlgorithm(encData);
        }
        if (algorithmURI == null) {
            throw new SignatureException("Unable to determine algorithm.");
        }
        this.algorithmURI = algorithmURI;
        GenericElement cipherData = encData.getCipherData();
        GenericElement cipherValue = cipherData.getDescendant("http://www.w3.org/2001/04/xmlenc#", "CipherValue");
        this.encryptedData = encData;
        if (cipherValue != null) {
            return this.decryptLiteral(cipherValue, algorithmURI);
        }
        CipherReference cipherReference = (CipherReference)cipherData.getDescendant("http://www.w3.org/2001/04/xmlenc#", "CipherReference");
        cipherReference.setTransformationFactory(this.trFact);
        return this.decryptReference(cipherReference, algorithmURI);
    }

    private String decryptLiteral(GenericElement cipherValue, String algorithmURI) throws SignatureException {
        return this.decrypt((Element)cipherValue.getDomRepresentation(), algorithmURI);
    }

    private String decryptReference(CipherReference cipherReference, String algorithmURI) throws SignatureException {
        try {
            Data data = cipherReference.getReferenced();
            this.cipher = this.generateCipherInstance(algorithmURI);
            return this.decrypt0(new String(data.getOctets()));
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException(e);
        }
        catch (IOException e) {
            throw new SignatureException(e);
        }
    }

    public String decrypt(Element parent, String algorithmURI) throws SignatureException {
        Document doc = parent.getOwnerDocument();
        try {
            this.cipher = this.generateCipherInstance(algorithmURI);
            this.algorithmURI = algorithmURI;
            return this.decrypt0(XMLDecryptor.gatherText(parent));
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException(e);
        }
        catch (IOException e) {
            throw new SignatureException(e);
        }
    }

    public void restoreOriginalContent(Element encData, String algorithmURI) throws SignatureException {
        Node parent = encData.getParentNode();
        String decrypted = this.decryptEncData(encData, algorithmURI);
        String type = encData.getAttribute("Type");
        Node toAdd = null;
        if (type == null || type.equals("http://www.w3.org/2001/04/xmlenc#Content")) {
            StringBuffer xml = new StringBuffer();
            xml.append("<a>");
            xml.append(decrypted);
            xml.append("</a>");
            Node d = XMLDecryptor.readStreamAsDOM(new ByteArrayInputStream(xml.toString().getBytes()));
            Document doc = encData.getOwnerDocument();
            DocumentFragment fr = doc.createDocumentFragment();
            NodeList nl = d.getChildNodes();
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                fr.appendChild(doc.importNode(nl.item(i).cloneNode(true), true));
            }
            toAdd = fr;
        } else if (type.equals("http://www.w3.org/2001/04/xmlenc#Element")) {
            toAdd = XMLDecryptor.readStreamAsDOM(new ByteArrayInputStream(decrypted.getBytes()));
        }
        toAdd = parent instanceof Document ? ((Document)parent).importNode(toAdd, true) : parent.getOwnerDocument().importNode(toAdd, true);
        Element oldNode = XMLDecryptor.getChildElementByName(parent, "EncryptedData", "http://www.w3.org/2001/04/xmlenc#");
        Node sibling = oldNode.getNextSibling();
        parent.removeChild(oldNode);
        if (sibling != null) {
            parent.insertBefore(toAdd, sibling);
        } else {
            parent.appendChild(toAdd);
        }
    }

    public void restoreOriginalContent(Element encData) throws SignatureException {
        this.restoreOriginalContent(encData, null);
    }

    public static Node readStreamAsDOM(InputStream in) throws SignatureException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            return document.getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            throw new SignatureException(e);
        }
        catch (SAXException e) {
            throw new SignatureException(e);
        }
        catch (IOException e) {
            throw new SignatureException(e);
        }
    }

    public static Element getChildElementByName(Node n, String localName, String uri) {
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node temp = nl.item(i);
            if (temp.getNodeType() != 1 || !temp.getLocalName().equals(localName) || !temp.getNamespaceURI().equals(uri)) continue;
            return (Element)temp;
        }
        return null;
    }
}

