/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.encryption.Constants;
import com.sap.engine.lib.xml.signature.transform.TransformationFactory;
import com.sap.engine.lib.xml.signature.transform.algorithms.Canonicalization;
import com.sap.engine.lib.xml.util.BASE64Decoder;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class XMLCryptor {
    public TransformationFactory trFact = TransformationFactory.newInstance();
    protected boolean padManually = true;
    protected boolean ivIncluded = true;
    protected String cryptMode = "CBC";
    protected String cryptPadding = "NoPadding";
    protected int mode = -1;
    protected Cipher cipher = null;
    protected Key key = null;
    protected String algorithmURI = null;
    protected byte[] IV = null;
    protected AlgorithmParameters algParams = null;
    protected String primaryEncodingFormat = "ASN.1";
    protected String prngIdentifier = "SHA1PRNG";
    protected byte[] randomSeed = null;
    protected int ivLength = -1;

    public void overrideDefaultPadding(String cryptPadding) {
        this.padManually = false;
        this.cryptPadding = cryptPadding;
    }

    public void setCryptMode(String cryptMode) {
        this.cryptMode = cryptMode;
    }

    public AlgorithmParameters getAlgorithmParameters() {
        return this.algParams;
    }

    public void specifyRandomness(String identifier, byte[] seed) {
        this.prngIdentifier = identifier;
        this.randomSeed = seed;
    }

    public void setAlgorithmParameters(AlgorithmParameters algParams) {
        this.algParams = algParams;
    }

    public byte[] getIV() {
        return this.IV;
    }

    public void setIV(byte[] IV) {
        this.IV = IV;
    }

    public byte[] encryptData(byte[] data) {
        return this.cipher.update(data);
    }

    public void createCipher(String algorithmURI) throws SignatureException {
        try {
            this.algorithmURI = algorithmURI;
            this.cipher = this.generateCipherInstance(algorithmURI);
            this.cipher.init(this.mode, this.key);
        }
        catch (GeneralSecurityException e) {
            throw new SignatureException(e);
        }
    }

    public void createCipher() throws SignatureException {
        this.createCipher(this.algorithmURI);
    }

    public void setKey(Key key) {
        this.key = key;
        this.algorithmURI = (String)Constants.cipherAlgMappings.get(key.getAlgorithm());
    }

    public void setIVLength(int ivLength) {
        this.ivLength = ivLength;
    }

    protected String decrypt0(String content) throws IOException, GeneralSecurityException, SignatureException {
        byte[] encryptedWithIV = BASE64Decoder.decode(content.getBytes());
        byte[] encryptedContent = this.getEncryptedNoIV(encryptedWithIV);
        this.initCipher(this.key, this.algParams, this.IV, 2);
        byte[] decryptedContent = this.cipher.doFinal(encryptedContent);
        if (this.padManually) {
            decryptedContent = this.dePad(decryptedContent);
        }
        return new String(decryptedContent);
    }

    protected byte[] encrypt0(byte[] toEncrypt) throws GeneralSecurityException, SignatureException {
        byte[] cipherValue = null;
        if (this.padManually) {
            toEncrypt = this.pad(toEncrypt);
        }
        cipherValue = this.cipher.doFinal(toEncrypt);
        byte[] total = XMLCryptor.append(this.cipher.getIV(), cipherValue);
        return total;
    }

    protected byte[] encrypt0(Element el, boolean contentOnly) throws GeneralSecurityException, SignatureException {
        byte[] toEncrypt;
        if (contentOnly) {
            DocumentFragment df = el.getOwnerDocument().createDocumentFragment();
            NodeList children = el.getChildNodes();
            int ln = children.getLength();
            for (int i = 0; i < ln; ++i) {
                df.appendChild(children.item(i).cloneNode(true));
            }
            toEncrypt = Canonicalization.canonicalize(df, true);
        } else {
            toEncrypt = Canonicalization.canonicalize(el, true);
        }
        return this.encrypt0(toEncrypt);
    }

    protected byte[] pad(byte[] toEncrypt) {
        int blockSize = this.cipher.getBlockSize();
        int length = toEncrypt.length;
        int diff = blockSize - length % blockSize;
        int size = length + diff;
        byte[] padded = new byte[length + diff];
        System.arraycopy(toEncrypt, 0, padded, 0, length);
        padded[size - 1] = (byte)diff;
        return padded;
    }

    protected byte[] dePad(byte[] padded) {
        int length = padded.length;
        byte toRemove = padded[length - 1];
        int originalSize = length - toRemove;
        byte[] dePadded = new byte[originalSize];
        System.arraycopy(padded, 0, dePadded, 0, originalSize);
        return dePadded;
    }

    protected static byte[] append(byte[] arg1, byte[] arg2) {
        int resLength = arg1.length + arg2.length;
        byte[] result = new byte[resLength];
        System.arraycopy(arg1, 0, result, 0, arg1.length);
        System.arraycopy(arg2, 0, result, arg1.length, arg2.length);
        return result;
    }

    protected byte[] getEncryptedNoIV(byte[] encryptedWithIV) throws SignatureException {
        int wholeLength = encryptedWithIV.length;
        int ivLength = this.getLength();
        byte[] IV = new byte[ivLength];
        System.arraycopy(encryptedWithIV, 0, IV, 0, ivLength);
        this.IV = IV;
        byte[] pureContent = new byte[wholeLength - ivLength];
        System.arraycopy(encryptedWithIV, ivLength, pureContent, 0, pureContent.length);
        return pureContent;
    }

    protected int getLength() throws SignatureException {
        if (this.ivLength > 0) {
            return this.ivLength;
        }
        Integer length = (Integer)Constants.ivLengths.get(this.algorithmURI);
        if (length == null) {
            throw new SignatureException("No mapping for algorihtm: " + this.algorithmURI);
        }
        return length;
    }

    protected static String gatherText(Node n) {
        StringBuffer temp = new StringBuffer(1000);
        NodeList nl = n.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node next = nl.item(i);
            if (next.getNodeType() != 3) continue;
            temp.append(next.getNodeValue());
        }
        return temp.toString();
    }

    protected static void deleteContent(Element e) {
        NodeList nl = e.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node next = nl.item(i);
            if (next.getNodeType() != 3) continue;
            e.removeChild(next);
        }
    }

    protected void initCipher(Key key, AlgorithmParameters params, byte[] IV, int opMode) throws IOException, GeneralSecurityException, SignatureException {
        if (IV == null) {
            int ivLength = this.getLength();
            IV = new byte[ivLength];
            this.randomize(IV);
        }
        IvParameterSpec pSpec = new IvParameterSpec(IV);
        if (params == null) {
            this.cipher.init(opMode, key, pSpec);
        } else {
            this.cipher.init(opMode, key, params);
        }
        this.updateParameters();
    }

    protected String getAlgorithmUriFromCipher() throws SignatureException {
        String alg = this.cipher.getAlgorithm();
        String map = (String)Constants.cipherAlgMappings.get(alg);
        if (map == null) {
            throw new SignatureException("Unsupported algorithm: " + alg + ".");
        }
        return map;
    }

    protected String getAlgOnly(String algWithModePad) {
        return algWithModePad.substring(0, algWithModePad.indexOf("/"));
    }

    protected void randomize(byte[] input) throws GeneralSecurityException {
        SecureRandom rand = SecureRandom.getInstance(this.prngIdentifier);
        if (this.randomSeed != null) {
            rand.setSeed(this.randomSeed);
        }
        rand.nextBytes(input);
    }

    protected void updateParameters() throws IOException {
        this.IV = this.cipher.getIV();
        this.algParams = this.cipher.getParameters();
    }

    protected static String constructCipherRequest(String algorithmURI, String cryptMode, String cryptPadding) throws SignatureException {
        if (algorithmURI.equals("http://www.w3.org/2001/04/xmlenc#tripledes-cbc")) {
            return "3DES/" + cryptMode + "/" + cryptPadding;
        }
        if (algorithmURI.equals("http://www.w3.org/2001/04/xmlenc#aes128-cbc")) {
            return "Rijndael/" + cryptMode + "/" + cryptPadding;
        }
        if (algorithmURI.equals("http://www.w3.org/2001/04/xmlenc#aes256-cbc")) {
            return "Rijndael-256/" + cryptMode + "/" + cryptPadding;
        }
        if (algorithmURI.equals("http://www.w3.org/2001/04/xmlenc#rsa-1_5") || algorithmURI.equals("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p")) {
            return "RSA/" + cryptMode + "/" + cryptPadding;
        }
        throw new SignatureException("Unknown algorithm URI: " + algorithmURI + ".");
    }

    protected static Cipher generateCipherInstance(String algorithmURI, String cryptMode, String cryptPadding) throws SignatureException, GeneralSecurityException {
        return Cipher.getInstance(XMLCryptor.constructCipherRequest(algorithmURI, cryptMode, cryptPadding), Constants.STANDARD_PROVIDER);
    }

    protected String constructCipherRequest(String algorithmURI) throws SignatureException {
        return XMLCryptor.constructCipherRequest(algorithmURI, this.cryptMode, this.cryptPadding);
    }

    protected Cipher generateCipherInstance(String algorithmURI) throws SignatureException, GeneralSecurityException {
        return XMLCryptor.generateCipherInstance(algorithmURI, this.cryptMode, this.cryptPadding);
    }
}

