/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class RandomNumberGenerator {
    public static byte[] randomSeed = "the quick brown dog jumps over the lazy fox".getBytes();
    public static String prngIdentifier = "SHA1PRNG";
    public static SecureRandom r = null;

    public static void init() throws GeneralSecurityException {
        RandomNumberGenerator.init(SecureRandom.getInstance(prngIdentifier));
    }

    public static void init(SecureRandom rand) {
        r = rand;
    }

    public static int nextInt() {
        return r.nextInt();
    }

    public static void setSeed(byte[] seed) {
        r.setSeed(seed);
    }

    public static void setSeed(long l) {
        r.setSeed(l);
    }

    public static void specifyRandomness(String identifier, byte[] seed) {
        prngIdentifier = identifier;
        randomSeed = seed;
    }

    public static void randomize(byte[] input) throws GeneralSecurityException {
        SecureRandom rand = SecureRandom.getInstance(prngIdentifier);
        if (randomSeed != null) {
            rand.setSeed(randomSeed);
        }
        rand.nextBytes(input);
    }

    public static byte[] getRandom(int length) throws NoSuchAlgorithmException {
        SecureRandom rand = SecureRandom.getInstance(prngIdentifier);
        byte[] next = new byte[length];
        rand.nextBytes(next);
        return next;
    }

    public static byte[] getRandomNoZero(int length) throws NoSuchAlgorithmException {
        SecureRandom rand = SecureRandom.getInstance(prngIdentifier);
        byte[] next = new byte[length];
        rand.nextBytes(next);
        for (int i = 0; i < next.length; ++i) {
            if (next[i] != 0) continue;
            next[i] = 1;
        }
        return next;
    }

    static {
        try {
            r = SecureRandom.getInstance(prngIdentifier);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
    }
}

