/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption;

import com.sap.engine.lib.xml.dom.DocumentImpl;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.elements.KeyInfo;
import com.sap.engine.lib.xml.signature.encryption.CipherData;
import com.sap.engine.lib.xml.signature.encryption.EncryptionMethod;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class EncryptedType
extends GenericElement {
    protected String type = "http://www.w3.org/2001/04/xmlenc#Element";
    private Integer id = null;
    private String mimeType = null;
    private String encoding = null;
    private EncryptionMethod encMethod = null;
    private KeyInfo kInfo = null;
    private Vector encProps = null;
    private CipherData cipherData = null;
    private int childIndex = -1;

    public EncryptedType(String namespaceUri, String qualifiedName, GenericElement parent) throws SignatureException {
        super(parent.getOwner(), namespaceUri, qualifiedName, parent);
    }

    public EncryptedType(Node parent, String localName, int childIndex) throws SignatureException {
        super(EncryptedType.getOwner(parent), "http://www.w3.org/2001/04/xmlenc#", "xenc:" + localName, null);
        if (parent != null) {
            EncryptedType.insertAtPosition(parent, this.domRepresentation, childIndex);
        } else {
            EncryptedType.insertAtPosition(this.getOwner(), this.domRepresentation, childIndex);
        }
        this.childIndex = childIndex;
    }

    private static Document getOwner(Node parent) {
        return parent != null ? (Document)(parent instanceof Document ? parent : parent.getOwnerDocument()) : new DocumentImpl();
    }

    public EncryptedType(Node parent, String localName) throws SignatureException {
        this(parent, localName, -1);
    }

    public EncryptedType(Element n, boolean unused) throws SignatureException {
        super(n, null);
    }

    public GenericElement getCipherData() throws SignatureException {
        return this.getDescendant("http://www.w3.org/2001/04/xmlenc#", "CipherData");
    }

    public GenericElement getEncryptionMethod() throws SignatureException {
        return this.getDescendant("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod");
    }

    public void setType(String type) {
        this.type = type;
    }

    public void construct() {
        if (this.type != null) {
            this.setAttribute("Type", this.type);
        }
    }

    public void construct(int childIndex) {
        this.setAttribute("Type", this.type);
        this.childIndex = childIndex;
    }

    protected static void insertAtPosition(Node parent, Node child, int position) throws SignatureException {
        NodeList childNodes = parent.getChildNodes();
        if (position > childNodes.getLength()) {
            throw new SignatureException("Cannot insert child on position" + position + " when old childs are only " + childNodes.getLength() + ".");
        }
        if (position < 0 || position == childNodes.getLength()) {
            parent.appendChild(child);
            return;
        }
        if (position == 0) {
            if (childNodes.getLength() <= 0) {
                parent.appendChild(child);
            } else {
                parent.insertBefore(child, childNodes.item(0));
            }
            return;
        }
        Node next = parent.getFirstChild();
        for (int i = 0; i < position; ++i) {
            next = next.getNextSibling();
        }
        parent.insertBefore(child, next);
    }
}

