/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.encryption;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.elements.KeyInfo;
import com.sap.engine.lib.xml.signature.encryption.CipherData;
import com.sap.engine.lib.xml.signature.encryption.Constants;
import com.sap.engine.lib.xml.signature.encryption.EncReference;
import com.sap.engine.lib.xml.signature.encryption.EncryptedKey;
import com.sap.engine.lib.xml.signature.encryption.XMLCryptor;
import com.sap.engine.lib.xml.signature.encryption.keytrans.KeyTransporter;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xml.util.BASE64Decoder;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.SecretKeySpec;
import org.w3c.dom.Node;

public class EncryptedKeyGenerator
extends XMLCryptor {
    private EncryptedKey ek = null;
    private GenericElement refList = null;
    private boolean showKeyInfo = false;

    public EncryptedKeyGenerator() {
        this.mode = 1;
    }

    public void init(Node parent) throws SignatureException {
        this.ek = parent != null ? new EncryptedKey(parent) : new EncryptedKey();
    }

    public void setRecipient(String recipient) throws SignatureException {
        this.ek.setRecipient(recipient);
    }

    public void setCarriedKeyName(String carriedKeyName) throws SignatureException {
        this.ek.setCarriedKeyName(carriedKeyName);
    }

    public void startNewReferenceList() throws SignatureException {
        this.refList = new GenericElement("http://www.w3.org/2001/04/xmlenc#", "xenc:ReferenceList", this.ek);
    }

    public void setType(String type) {
        this.ek.setType(type);
    }

    public void addReference(Transformation[] transforms, String uri, boolean dataReference) throws SignatureException {
        if (transforms != null) {
            EncReference cr = new EncReference(uri, dataReference);
            cr.setTransforms(transforms);
            cr.construct(this.refList);
        }
    }

    public EncryptedKey getEncryptedKey(String algorithmURI, Key wrappingKey, Key wrappedKey) throws SignatureException {
        this.key = wrappingKey;
        String encrypted = this.encryptKey(algorithmURI, wrappedKey);
        GenericElement first = this.ek.getFirstChild();
        GenericElement encMeth = new GenericElement("http://www.w3.org/2001/04/xmlenc#", "xenc:EncryptionMethod", this.ek);
        encMeth.setAttribute("Algorithm", algorithmURI);
        if (first != null && first.getDomRepresentation() != encMeth.getDomRepresentation()) {
            this.ek.insertBefore(encMeth, first);
        }
        CipherData cd = new CipherData(this.ek);
        cd.setCipherValue(encrypted);
        cd.construct();
        if (this.showKeyInfo) {
            KeyInfo kInfo = new KeyInfo("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo", this.ek);
            kInfo.setPublicKey((PublicKey)this.key);
            if (this.key != null) {
                kInfo.addKeyValue(this.key.getAlgorithm());
            }
        }
        this.ek.construct();
        return this.ek;
    }

    public Key extractKey(EncryptedKey k, Key wrapping, String secretAlgorithm) throws SignatureException {
        this.key = wrapping;
        try {
            k.initializeDescendants();
            String cipherdata = k.getCipherData().getFirstChild().getNodeValue();
            this.algorithmURI = k.getDirectChild("http://www.w3.org/2001/04/xmlenc#", "EncryptionMethod").getAttribute("Algorithm", null, null);
            byte[] decoded = this.decryptKey(this.algorithmURI, cipherdata.getBytes());
            SecretKeySpec skc = new SecretKeySpec(decoded, secretAlgorithm);
            SecretKeyFactory f = SecretKeyFactory.getInstance(secretAlgorithm, Constants.STANDARD_PROVIDER);
            return f.generateSecret(skc);
        }
        catch (NoSuchProviderException e) {
            throw new SignatureException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException(e);
        }
        catch (InvalidKeySpecException e) {
            throw new SignatureException(e);
        }
    }

    public boolean getShowKeyInfo() {
        return this.showKeyInfo;
    }

    public void setShowKeyInfo(boolean showKeyInfo) {
        this.showKeyInfo = showKeyInfo;
    }

    private String encryptKey(String algorithmURI, Key wrappedKey) throws SignatureException {
        KeyTransporter tr = KeyTransporter.getInstance(algorithmURI);
        return new String(BASE64Encoder.encode(tr.encrypt(this.key, wrappedKey)));
    }

    private byte[] decryptKey(String algorithmURI, byte[] wrappedKey) throws SignatureException {
        KeyTransporter tr = KeyTransporter.getInstance(algorithmURI);
        return tr.decrypt(this.key, BASE64Decoder.decode(wrappedKey));
    }
}

