/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.elements;

import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.signature.Constants;
import com.sap.engine.lib.xml.signature.Data;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.transform.Transformation;
import com.sap.engine.lib.xml.signature.transform.TransformationFactory;
import com.sap.engine.lib.xml.signature.transform.algorithms.Canonicalization;
import com.sap.engine.lib.xml.signature.transform.algorithms.XPathTransformation;
import com.sap.engine.lib.xml.util.BASE64Decoder;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Reference
extends GenericElement {
    public int state = -1;
    private String digestAlgorithmURI = null;
    private String digestValue = null;
    private String canonicalizationURI = null;
    protected TransformationFactory trFact = TransformationFactory.newInstance();
    protected Transformation[] transforms = new Transformation[0];
    private Node envelopingElement = null;
    protected String proxyHost = null;
    protected String proxyPort = null;
    protected String uri = null;
    private String idNamespaceURI = null;
    private String idLocalName = "Id";

    public void setProxy(String proxyHost, String proxyPort) {
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public void setIDAttribute(String localName, String uri) {
        this.idNamespaceURI = uri;
        this.idLocalName = localName;
    }

    public void setTransformationFactory(TransformationFactory trFact) {
        this.trFact = trFact;
    }

    public Reference() {
        super("http://www.w3.org/2000/09/xmldsig#", "ds:Reference");
    }

    public Reference(String namespaceURI, String qName) {
        super(namespaceURI, qName);
    }

    public Reference(String namespaceUri, String qualifiedName, GenericElement parent) throws SignatureException {
        super(namespaceUri, qualifiedName, parent);
    }

    public Reference(Element domRepr, GenericElement parent) throws SignatureException {
        super(domRepr, parent);
        this.envelopingElement = parent.getDomRepresentation();
    }

    private void init() throws SignatureException {
        this.initializeDescendants();
        this.uri = this.getAttribute("URI", null, null);
        this.digestAlgorithmURI = this.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "DigestMethod").getAttribute("Algorithm", null, null);
        this.digestValue = this.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "DigestValue").getNodeValue();
        GenericElement transformsElement = this.getDirectChild("http://www.w3.org/2000/09/xmldsig#", "Transforms");
        try {
            if (transformsElement != null) {
                Vector v = transformsElement.getDirectChildren("http://www.w3.org/2000/09/xmldsig#", "Transform");
                this.transforms = new Transformation[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    this.transforms[i] = this.trFact.getInstance((GenericElement)v.get(i));
                }
            }
        }
        catch (SignatureException e) {
            this.state = 3;
            throw e;
        }
    }

    public void setEnvelopingElement(Node envelopingElement) {
        this.envelopingElement = envelopingElement;
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public void setDigestURI(String digestAlgorithmURI) {
        this.digestAlgorithmURI = digestAlgorithmURI;
    }

    public String getDigestAlgorithmURI() {
        return this.digestAlgorithmURI;
    }

    public String getCanonicalizationURI() {
        return this.canonicalizationURI;
    }

    public String getURI() {
        return this.uri;
    }

    public Transformation[] getTransformations() {
        return this.transforms;
    }

    public void setTransforms(Transformation[] transforms) {
        this.transforms = transforms;
    }

    private void updateNamespaces() {
        for (int i = 0; i < this.transforms.length; ++i) {
            if (!this.transforms[i].uri.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) continue;
            ((XPathTransformation)this.transforms[i]).setPrefixMappings(DOM.getNamespaceMappingsInScopeSpecial(this.domRepresentation));
        }
    }

    private Element getElementByID(String idValue) {
        Document doc = this.envelopingElement.getOwnerDocument();
        Element el = DOM.getElementByAttribute(doc, this.idLocalName, this.idNamespaceURI, idValue);
        String defaultNS = DOM.prefixToURI("xmlns", el);
        Hashtable parentNamespaces = DOM.getNamespaceMappingsInScopeSpecial(el);
        Enumeration keys = parentNamespaces.keys();
        if (defaultNS == null) {
            defaultNS = "http://www.w3.org/2000/xmlns/";
        }
        while (keys.hasMoreElements()) {
            String nextPrefix = (String)keys.nextElement();
            String nextURI = (String)parentNamespaces.get(nextPrefix);
            el.setAttributeNS(defaultNS, "xmlns:" + nextPrefix, nextURI);
        }
        return el;
    }

    private Data dereference(String uri) throws SignatureException {
        if (uri == null || uri.equals("")) {
            Data result = new Data(Canonicalization.canonicalize(this.envelopingElement.getOwnerDocument(), true));
            return result;
        }
        if (uri.startsWith("#")) {
            String idReference = uri.substring(1);
            Element el = this.getElementByID(idReference);
            if (el == null) {
                return new Data(new byte[0]);
            }
            return new Data(Canonicalization.canonicalize(el, true));
        }
        try {
            Data result = new Data(uri, this.proxyHost, this.proxyPort);
            return result;
        }
        catch (MalformedURLException e) {
            this.state = 1;
            throw new SignatureException(e);
        }
        catch (IOException e) {
            this.state = 1;
            throw new SignatureException(e);
        }
    }

    public boolean validate() throws SignatureException {
        this.updateNamespaces();
        this.init();
        byte[] shouldBe = this.getDigestValue();
        byte[] is = BASE64Decoder.decode(this.digestValue.getBytes());
        boolean result = Arrays.equals(shouldBe, is);
        this.state = result ? 0 : 2;
        return result;
    }

    protected Data undergoTransformations() throws SignatureException {
        Data data = this.dereference(this.uri);
        if (this.transforms != null) {
            for (int i = 0; i < this.transforms.length; ++i) {
                this.transforms[i].transform(data);
            }
        }
        return data;
    }

    protected byte[] getDigestValue() throws SignatureException {
        Data data = this.undergoTransformations();
        try {
            String jceString = Constants.getDigestJCEFromURI(this.digestAlgorithmURI);
            if (jceString == null) {
                this.state = 4;
                throw new SignatureException("Unrecognized digest algorithm namespace: " + this.digestAlgorithmURI);
            }
            MessageDigest md = MessageDigest.getInstance(jceString, Constants.STANDARD_PROVIDER);
            byte[] digest = md.digest(data.getOctets());
            return digest;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SignatureException(e);
        }
        catch (NoSuchProviderException e) {
            throw new SignatureException(e);
        }
    }

    protected void construct(GenericElement parent, String transformsURI, String transformsQName) throws SignatureException {
        if (parent == null) {
            parent = this.parent;
        }
        this.initDOM(parent.getOwner());
        this.setAttribute("URI", this.uri);
        parent.appendChild(this);
        this.updateNamespaces();
        if (this.transforms.length > 0) {
            GenericElement elTransforms = new GenericElement(transformsURI, transformsQName, this);
            for (int i = 0; i < this.transforms.length; ++i) {
                GenericElement transform = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:Transform", elTransforms);
                String algURI = this.transforms[i].uri;
                transform.setAttribute("Algorithm", algURI);
                if (!algURI.equals("http://www.w3.org/TR/1999/REC-xpath-19991116")) continue;
                GenericElement xpathTrans = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:XPath", transform);
                String query = (String)this.transforms[i].additionalArgs[0];
                Hashtable prefixMappings = (Hashtable)this.transforms[i].additionalArgs[1];
                if (prefixMappings != null) {
                    Enumeration e = prefixMappings.keys();
                    while (e.hasMoreElements()) {
                        String next = (String)e.nextElement();
                        xpathTrans.setAttribute("xmlns:" + next, (String)prefixMappings.get(next));
                    }
                }
                xpathTrans.appendTextChild(query);
            }
        }
    }

    public void digest(GenericElement parent) throws SignatureException {
        this.construct(parent, "http://www.w3.org/2000/09/xmldsig#", "ds:Transforms");
        GenericElement dMethod = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:DigestMethod", this);
        GenericElement dValue = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:DigestValue", this);
        byte[] digest = this.getDigestValue();
        byte[] encodedDigest = BASE64Encoder.encode(digest);
        dMethod.setAttribute("Algorithm", this.digestAlgorithmURI);
        dValue.appendTextChild(new String(encodedDigest));
    }
}

