/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.elements;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.Certificate;

public abstract class KeyValue
extends GenericElement {
    public abstract Certificate getCerificate();

    public abstract void setCertificate(Certificate var1);

    public abstract void setPublicKey(PublicKey var1);

    public abstract void construct() throws SignatureException;

    public KeyValue(String namespaceUri, String qualifiedName, GenericElement parent) throws SignatureException {
        super(namespaceUri, qualifiedName, parent);
    }

    public static byte[] getBytes(BigInteger b) {
        int length = b.bitLength();
        if (length >> 3 << 3 == length) {
            byte[] signed = b.toByteArray();
            byte[] unsigned = new byte[signed.length - 1];
            System.arraycopy(signed, 1, unsigned, 0, signed.length - 1);
            return unsigned;
        }
        byte[] bytes = b.toByteArray();
        return bytes;
    }

    public static byte[] getBytes(BigInteger big, int bitlen) {
        if ((bitlen = bitlen + 7 - (bitlen + 7) % 8) < big.bitLength()) {
            throw new IllegalArgumentException("IllegalBitlength");
        }
        byte[] bigBytes = big.toByteArray();
        if (big.bitLength() % 8 != 0 && big.bitLength() / 8 + 1 == bitlen / 8) {
            return bigBytes;
        }
        int startSrc = 0;
        int bigLen = bigBytes.length;
        if (big.bitLength() % 8 == 0) {
            startSrc = 1;
            --bigLen;
        }
        int startDst = bitlen / 8 - bigLen;
        byte[] resizedBytes = new byte[bitlen / 8];
        System.arraycopy(bigBytes, startSrc, resizedBytes, startDst, bigLen);
        return resizedBytes;
    }
}

