/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.elements;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.DSAKeyValue;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.elements.KeyValue;
import com.sap.engine.lib.xml.signature.elements.RSAKeyValue;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Vector;
import org.w3c.dom.Node;

public class KeyInfo
extends GenericElement {
    private String keyName = null;
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;
    private Certificate[] certificates = null;
    private String[] certTypes = null;
    private String endcodedCert = null;

    public KeyInfo(Node parent) throws SignatureException {
        super(parent != null ? parent.getOwnerDocument() : null, "http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo", null);
        if (parent != null) {
            parent.appendChild(this.domRepresentation);
        } else {
            this.getOwner().appendChild(this.domRepresentation);
        }
    }

    public KeyInfo() {
        super("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
    }

    public KeyInfo(GenericElement parent) throws SignatureException {
        super("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo", parent);
    }

    public KeyInfo(String namespaceUri, String qualifiedName, GenericElement parent) throws SignatureException {
        super(namespaceUri, qualifiedName, parent);
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public Certificate[] getCerificates() {
        return this.certificates;
    }

    public void setCertificates(Certificate[] certificates) {
        this.certificates = certificates;
        this.certTypes = KeyInfo.getTypes(certificates);
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void addKeyName() throws SignatureException {
        GenericElement name = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:KeyName", this);
        name.appendTextChild(this.keyName);
    }

    public void addCertificateInfo() throws CertificateEncodingException, SignatureException {
        String[] uniques = KeyInfo.removeDuplicates(this.certTypes);
        for (int i = 0; i < uniques.length; ++i) {
            String whatData = uniques[i] + "Data";
            String whatCertificate = uniques[i] + "Certificate";
            GenericElement data = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:" + whatData, this);
            for (int j = 0; j < this.certTypes.length; ++j) {
                if (!this.certTypes[j].equals(uniques[i])) continue;
                String encCert = new String(BASE64Encoder.encode(this.certificates[j].getEncoded()));
                GenericElement certData = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:" + whatCertificate, data);
                certData.appendTextChild(encCert);
                this.appendChild(data);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addKeyValue(String keyType) throws SignatureException {
        void var2_2;
        KeyValue dKey;
        if (keyType.equalsIgnoreCase("dsa")) {
            dKey = new DSAKeyValue("http://www.w3.org/2000/09/xmldsig#", "ds:KeyValue", this);
        } else if (keyType.equalsIgnoreCase("rsa")) {
            dKey = new RSAKeyValue("http://www.w3.org/2000/09/xmldsig#", "ds:KeyValue", this);
        } else {
            throw new SignatureException("Unrecognized signature type: " + keyType);
        }
        if (this.certificates != null && this.certificates[0] != null) {
            var2_2.setCertificate(this.certificates[0]);
        }
        var2_2.setPublicKey(this.publicKey);
        var2_2.construct();
        this.appendChild((GenericElement)var2_2);
    }

    private static String[] removeDuplicates(String[] source) {
        Vector<String> v = new Vector<String>();
        block0: for (int i = 0; i < source.length; ++i) {
            for (int j = 0; j < v.size(); ++j) {
                if (v.get(j).equals(source[i])) continue block0;
            }
            v.add(source[i]);
        }
        String[] res = new String[v.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = (String)v.get(i);
        }
        return res;
    }

    private static String removeAllOccurrencesOf(char what, String where) {
        StringBuffer result = new StringBuffer(where.length());
        for (int i = 0; i < where.length(); ++i) {
            char temp = where.charAt(i);
            if (temp == what) continue;
            result.append(temp);
        }
        return result.toString();
    }

    private static String[] getTypes(Certificate[] certs) {
        String[] certTypes = new String[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            certTypes[i] = certs[i].getType();
            certTypes[i] = KeyInfo.removeAllOccurrencesOf('.', certTypes[i]);
        }
        return certTypes;
    }
}

