/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.elements;

import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.Reference;
import com.sap.engine.lib.xml.signature.encryption.CipherReference;
import com.sap.engine.lib.xml.signature.encryption.EncReference;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class GenericElement {
    protected Document owner = null;
    protected Element domRepresentation = null;
    protected GenericElement parent = null;
    protected String namespaceUri = null;
    protected String qualifiedName = null;
    protected Hashtable attribs = new Hashtable();
    protected Vector childElements = new Vector(0);
    protected boolean descendantsInitialized = false;

    public GenericElement(String namespaceUri, String qualifiedName) {
        this.namespaceUri = namespaceUri;
        this.qualifiedName = qualifiedName;
    }

    public GenericElement(String namespaceUri, String qualifiedName, GenericElement parent) throws SignatureException {
        this(parent.getOwner(), namespaceUri, qualifiedName, parent);
    }

    public GenericElement(Node n, String namespaceUri, String qualifiedName, GenericElement parent, boolean generateDom) throws SignatureException {
        if (generateDom) {
            if (!(n instanceof Document)) {
                throw new SignatureException("The owner is supposed to be a document.");
            }
            this.init((Document)n, namespaceUri, qualifiedName, parent);
        } else {
            if (!(n instanceof Element)) {
                throw new SignatureException("The owner is supposed to be a document.");
            }
            this.init((Element)n, parent);
        }
    }

    public GenericElement(Document owner, String namespaceUri, String qualifiedName, GenericElement parent) throws SignatureException {
        this.init(owner, namespaceUri, qualifiedName, parent);
    }

    public GenericElement(Element domRepresentation, GenericElement parent) throws SignatureException {
        this.init(domRepresentation, parent);
    }

    private void init(Document owner, String namespaceUri, String qualifiedName, GenericElement parent) throws SignatureException {
        if (owner == null && parent != null) {
            owner = parent instanceof Document ? (Document)((Object)parent) : parent.getOwner();
        }
        this.namespaceUri = namespaceUri;
        this.qualifiedName = qualifiedName;
        this.owner = owner;
        this.domRepresentation = owner.createElementNS(namespaceUri, qualifiedName);
        if (parent != null) {
            parent.appendChild(this);
        }
    }

    private void init(Element domRepresentation, GenericElement parent) throws SignatureException {
        this.owner = domRepresentation.getOwnerDocument();
        this.parent = parent;
        this.domRepresentation = domRepresentation;
        this.namespaceUri = domRepresentation.getNamespaceURI();
        this.qualifiedName = domRepresentation.getPrefix() == null ? domRepresentation.getLocalName() : domRepresentation.getPrefix() + ":" + domRepresentation.getLocalName();
        NamedNodeMap map = domRepresentation.getAttributes();
        for (int i = 0; i < map.getLength(); ++i) {
            Attr next = (Attr)map.item(i);
            this.attribs.put(next.getName(), next.getValue());
        }
    }

    public void initDOM(Document owner) {
        this.owner = owner;
        this.domRepresentation = owner.createElementNS(this.namespaceUri, this.qualifiedName);
    }

    public void initDOM() throws SignatureException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.initDOM(db.newDocument());
        }
        catch (ParserConfigurationException e) {
            throw new SignatureException(e);
        }
    }

    public Hashtable getNamespaceMappingsInScope() {
        return DOM.getNamespaceMappingsInScopeSpecial(this.domRepresentation);
    }

    public String getNodeValue() {
        return this.domRepresentation.getFirstChild().getNodeValue();
    }

    public void setDomRepresentation(Element domRepresentation) {
        this.domRepresentation = domRepresentation;
    }

    public Node getDomRepresentation() {
        return this.domRepresentation;
    }

    public void setOwner(Document owner) {
        this.owner = owner;
    }

    public void setParent(GenericElement parent) {
        this.parent = parent;
    }

    public Document getOwner() {
        return this.owner;
    }

    public String getNamespaceURI() {
        return this.namespaceUri == null ? "" : this.namespaceUri;
    }

    public String getQName() {
        return this.qualifiedName;
    }

    public String getLocalName() {
        return this.qualifiedName.substring(this.qualifiedName.indexOf(":") + 1);
    }

    public static String getLocalName(String qualifiedName) {
        return qualifiedName.substring(qualifiedName.indexOf(":") + 1);
    }

    public static String getPrefix(String qualifiedName) {
        return qualifiedName.substring(0, qualifiedName.indexOf(":"));
    }

    public String getAttribute(String localName, String prefix, String uri) {
        if (uri != null) {
            return this.domRepresentation.getAttributeNS(localName, uri);
        }
        return this.domRepresentation.getAttribute(localName);
    }

    public Hashtable getAttributes() {
        return this.attribs;
    }

    public GenericElement getParent() {
        return this.parent;
    }

    public void setAttribute(String name, String value) {
        this.domRepresentation.setAttributeNS(null, name, value);
        this.attribs.put(name, value);
    }

    public void appendTextChild(String text) {
        Text t = this.owner.createTextNode(text);
        this.domRepresentation.appendChild(t);
    }

    public void insertBefore(GenericElement newChild, GenericElement refChild) throws SignatureException {
        Node refC = refChild.getDomRepresentation();
        Node newC = newChild.getDomRepresentation();
        if (newC.getParentNode() == this.domRepresentation) {
            this.domRepresentation.removeChild(newC);
        }
        this.domRepresentation.insertBefore(newC, refC);
        newChild.setParent(this);
    }

    public void appendChild(GenericElement child) throws SignatureException {
        this.domRepresentation.appendChild(child.getDomRepresentation());
        child.setParent(this);
    }

    public GenericElement getFirstChild() throws SignatureException {
        if (this.childElements.size() > 0) {
            return (GenericElement)this.childElements.get(0);
        }
        return null;
    }

    public Vector getDirectChildren(String uri, String localName) throws SignatureException {
        Vector<GenericElement> v = new Vector<GenericElement>(10);
        for (int i = 0; i < this.childElements.size(); ++i) {
            GenericElement next = (GenericElement)this.childElements.get(i);
            if (!next.getNamespaceURI().equals(uri) || !next.getLocalName().equals(localName)) continue;
            v.add(next);
        }
        return v;
    }

    public GenericElement getDirectChild(String uri, String localName) throws SignatureException {
        for (int i = 0; i < this.childElements.size(); ++i) {
            GenericElement next = (GenericElement)this.childElements.get(i);
            if (!next.getNamespaceURI().equals(uri) || !next.getLocalName().equals(localName)) continue;
            return next;
        }
        return null;
    }

    public GenericElement getDirectChildIgnoreCase(String uri, String localName) throws SignatureException {
        for (int i = 0; i < this.childElements.size(); ++i) {
            GenericElement next = (GenericElement)this.childElements.get(i);
            if (!next.getNamespaceURI().equals(uri) || !next.getLocalName().equalsIgnoreCase(localName)) continue;
            return next;
        }
        return null;
    }

    public GenericElement getDescendant(String uri, String localName) throws SignatureException {
        GenericElement directChild = this.getDirectChild(uri, localName);
        if (directChild != null) {
            return directChild;
        }
        for (int i = 0; i < this.childElements.size(); ++i) {
            GenericElement grandson = ((GenericElement)this.childElements.get(i)).getDescendant(uri, localName);
            if (grandson == null) continue;
            return grandson;
        }
        return null;
    }

    public void removeChild(GenericElement child) {
        this.domRepresentation.removeChild(child.getDomRepresentation());
        child.setParent(null);
    }

    public void initializeDescendants() throws SignatureException {
        if (this.descendantsInitialized) {
            return;
        }
        NodeList children = this.domRepresentation.getChildNodes();
        if (children != null) {
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                Node next = children.item(i);
                if (!(next instanceof Element)) continue;
                GenericElement ge = null;
                String nextUri = next.getNamespaceURI();
                if (nextUri == null) {
                    nextUri = "";
                }
                ge = nextUri.equals("http://www.w3.org/2000/09/xmldsig#") && next.getLocalName().equals("Reference") ? new Reference((Element)next, this) : (nextUri.equals("http://www.w3.org/2001/04/xmlenc#") && next.getLocalName().equals("CipherReference") ? new CipherReference((Element)next, this) : (nextUri.equals("http://www.w3.org/2001/04/xmlenc#") && next.getLocalName().equals("DataReference") ? new EncReference((Element)next, this, true) : (nextUri.equals("http://www.w3.org/2001/04/xmlenc#") && next.getLocalName().equals("KeyReference") ? new EncReference((Element)next, this, false) : new GenericElement((Element)next, this))));
                this.childElements.add(ge);
            }
        }
        for (int i = 0; i < this.childElements.size(); ++i) {
            ((GenericElement)this.childElements.get(i)).initializeDescendants();
        }
        this.descendantsInitialized = true;
    }
}

