/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature.elements;

import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.elements.GenericElement;
import com.sap.engine.lib.xml.signature.elements.KeyValue;
import com.sap.engine.lib.xml.util.BASE64Encoder;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;

public class DSAKeyValue
extends KeyValue {
    private BigInteger p = null;
    private BigInteger q = null;
    private BigInteger g = null;
    private BigInteger y = null;
    private BigInteger j = null;
    private BigInteger seed = null;
    private BigInteger pgenCounter = null;
    private Certificate certificate = null;
    private DSAPublicKey publicKey = null;
    private DSAParams params = null;

    public DSAKeyValue(String namespaceUri, String qualifiedName, GenericElement parent) throws SignatureException {
        super(namespaceUri, qualifiedName, parent);
    }

    public Certificate getCerificate() {
        return this.certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = (DSAPublicKey)publicKey;
    }

    public void construct() throws SignatureException {
        if (this.publicKey == null && this.certificate != null) {
            try {
                this.publicKey = (DSAPublicKey)this.certificate.getPublicKey();
            }
            catch (ClassCastException e) {
                throw new SignatureException(e, "DSA key expected but " + this.certificate.getPublicKey().getAlgorithm() + " key received");
            }
        }
        this.y = this.publicKey.getY();
        this.params = this.publicKey.getParams();
        this.p = this.params.getP();
        this.q = this.params.getQ();
        this.g = this.params.getG();
        GenericElement keyValue = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:DSAKeyValue", this);
        GenericElement valueP = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:P", keyValue);
        valueP.appendTextChild(new String(BASE64Encoder.encode(DSAKeyValue.getBytes(this.p))));
        GenericElement valueQ = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:Q", keyValue);
        valueQ.appendTextChild(new String(BASE64Encoder.encode(DSAKeyValue.getBytes(this.q))));
        GenericElement valueG = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:G", keyValue);
        valueG.appendTextChild(new String(BASE64Encoder.encode(DSAKeyValue.getBytes(this.g))));
        GenericElement valueY = new GenericElement("http://www.w3.org/2000/09/xmldsig#", "ds:Y", keyValue);
        valueY.appendTextChild(new String(BASE64Encoder.encode(DSAKeyValue.getBytes(this.y))));
    }
}

