/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature;

import com.sap.engine.lib.xml.SystemProperties;
import com.sap.engine.lib.xml.parser.ParserException;
import com.sap.engine.lib.xml.signature.SignatureException;
import com.sap.engine.lib.xml.signature.transform.algorithms.Canonicalization;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.w3c.dom.Node;

public class Data {
    private ParserException xmlViolation = null;
    public static final String MIME_XML = "xml";
    public static final String MIME_HTML = "html";
    public static final String MIME_ANY = "";
    public String mimeType = "";
    public byte[] octets = null;
    public Node node = null;
    public InputStream in = null;

    public Data(String urlString, String proxyHost, String proxyPort) throws MalformedURLException, IOException {
        URL url;
        URLConnection con;
        String contentType;
        if (proxyHost != null && proxyPort != null) {
            SystemProperties.setProperty("http.proxyHost", proxyHost);
            SystemProperties.setProperty("http.proxyPort", proxyPort);
        }
        this.mimeType = (contentType = (con = (url = new URL(urlString)).openConnection()).getContentType()) == null ? MIME_ANY : (contentType.indexOf(MIME_XML) >= 0 || contentType.indexOf("xhtml") >= 0 ? MIME_XML : (contentType.indexOf(MIME_HTML) >= 0 ? MIME_HTML : MIME_HTML));
        this.in = con.getInputStream();
    }

    public Data(Node node) {
        this.mimeType = MIME_XML;
        this.node = node;
    }

    public Data(byte[] octets) {
        this.octets = octets;
    }

    public Data(InputStream in) {
        this.in = in;
    }

    public void setOctets(byte[] octets) {
        this.reuse();
        this.octets = octets;
    }

    public void setNode(Node node) {
        this.reuse();
        this.node = node;
    }

    public void setInputStream(InputStream in) {
        this.reuse();
        this.in = in;
    }

    public byte[] getOctets() throws SignatureException {
        this.synch();
        if (this.octets != null) {
            return this.octets;
        }
        return new byte[0];
    }

    public Node getNode() throws SignatureException {
        this.synch();
        if (this.node == null && this.xmlViolation != null) {
            throw new SignatureException("Not xml data! Reason: ", this.xmlViolation);
        }
        return this.node;
    }

    public InputStream getInputStream() throws SignatureException {
        this.synch();
        if (this.in != null) {
            return this.in;
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    public void reuse() {
        this.mimeType = MIME_ANY;
        this.octets = null;
        this.node = null;
        this.in = null;
    }

    public void synch() throws SignatureException {
        try {
            if (this.octets != null || this.node != null) {
                this.equalize(this.octets, this.node);
                this.equalize(this.octets, this.in);
                return;
            }
            this.equalize(this.octets, this.in);
            this.equalize(this.octets, this.node);
        }
        catch (IOException e) {
            throw new SignatureException(e);
        }
    }

    private void equalize(byte[] octets, Node n) throws SignatureException {
        if (n != null && octets != null) {
            return;
        }
        if (n == null && octets == null) {
            return;
        }
        if (n != null) {
            this.octets = Canonicalization.canonicalize(n, true);
            return;
        }
        if (octets != null) {
            try {
                this.node = Canonicalization.canonicalizeToNode(octets, true);
                this.mimeType = MIME_XML;
            }
            catch (SignatureException e) {
                if (e.getCause() instanceof ParserException) {
                    this.node = null;
                    this.xmlViolation = (ParserException)e.getCause();
                }
                throw e;
            }
            return;
        }
    }

    private void equalize(byte[] octets, InputStream in) throws IOException {
        if (in != null && octets != null) {
            return;
        }
        if (in == null && octets == null) {
            return;
        }
        if (octets != null) {
            this.in = new ByteArrayInputStream(octets);
        }
        if (in != null) {
            int read;
            BufferedInputStream bin = new BufferedInputStream(in);
            byte[] barr = new byte[]{};
            while ((read = bin.read()) != -1) {
                byte[] temp = new byte[barr.length + 1];
                System.arraycopy(barr, 0, temp, 0, barr.length);
                temp[temp.length - 1] = (byte)read;
                barr = temp;
            }
            this.octets = barr;
            this.in = new ByteArrayInputStream(barr);
        }
    }
}

