/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.signature;

import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.Hashtable;

public abstract class Constants {
    public static final String PROVIDER_SUN = "SUN";
    public static final String PROVIDER_IAIK = "IAIK";
    public static String STANDARD_PROVIDER = "SUN";
    public static final String STANDARD_PREFIX = "ds:";
    public static final String SIGNATURE_SPEC_NS = "http://www.w3.org/2000/09/xmldsig#";
    public static final String MORE_ALGORITHMS_SPEC_NS = "http://www.w3.org/2001/04/xmldsig-more#";
    public static final String TR_C14N_EXCL_OMIT_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#";
    public static final String TR_C14N_EXCL_WITH_COMMENTS = "http://www.w3.org/2001/10/xml-exc-c14n#WithComments";
    public static final String TR_C14N_OMIT_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    public static final String TR_C14N_WITH_COMMENTS = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments";
    public static final String TR_C14N_EXCL = "http://www.w3.org/2000/09/xmldsig#excludeC14N";
    public static final String TR_C14N_EXCL_WITHCOMMENTS = "http://www.w3.org/2000/09/xmldsig#excludeC14NwithComments";
    public static final String TR_XSLT = "http://www.w3.org/TR/1999/REC-xslt-19991116";
    public static final String TR_BASE64_DECODE = "http://www.w3.org/2000/09/xmldsig#base64";
    public static final String TR_XPATH = "http://www.w3.org/TR/1999/REC-xpath-19991116";
    public static final String TR_ENVELOPED_SIGNATURE = "http://www.w3.org/2000/09/xmldsig#enveloped-signature";
    public static final String TR_XPOINTER = "http://www.w3.org/TR/2001/WD-xptr-20010108";
    public static final String TR_XPATH_FILTER2 = "http://www.w3.org/2002/06/xmldsig-filter2";
    public static final String SIGN_DSA = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    public static final String SIGN_RSA = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    public static final int FILTER2_INVALID = 0;
    public static final int FILTER2_SUBTRACT = 1;
    public static final int FILTER2_INTERSECT = 2;
    public static final int FILTER2_UNION = 3;
    public static final int VERIFIER_INITIAL_STATE = -1;
    public static final int VERIFY_OK = 0;
    public static final int NO_KEY_INFO = 1;
    public static final int INVALID_SIGNATURE_VALUE = 2;
    public static final int CONTAINS_INVALID_REFERENCE = 3;
    public static final int UNKNOWN_SIGNATURE_ALGORITHM = 4;
    public static final int UNKNOWN_CANONICALIZATION_ALGORITHM = 5;
    public static final int REFERENCE_INITIAL_STATE = -1;
    public static final int REFERENCE_VERIFY_OK = 0;
    public static final int REFERENCE_UNREACHABLE = 1;
    public static final int INVALID_DIGEST_VALUE = 2;
    public static final int UNKNOWN_TRANSFORMATION_ALGORITHM = 3;
    public static final int UNKNOWN_DIGEST_ALGORITHM = 4;
    public static final String DIGEST_MD5 = "http://www.w3.org/2001/04/xmldsig-more#md5";
    public static final String DIGEST_SHA1 = "http://www.w3.org/2000/09/xmldsig#sha1";
    public static final Hashtable digestAlgMappings;
    public static final String REFERENCE_TYPE_SIG_PROPERTIES = "http://www.w3.org/2000/09/xmldsig#SignatureProperties";

    public static void setAlgorithmProvider(String providerName) {
        STANDARD_PROVIDER = providerName;
    }

    public static void setAlgorithmProvider(String providerName, Provider provider) {
        Security.addProvider(provider);
        STANDARD_PROVIDER = providerName;
    }

    public static final void addDigestAlgorithm(String jceIdentifier, String uri) {
        digestAlgMappings.put(jceIdentifier, uri);
    }

    public static final Hashtable getAllRegisteredDigestAlgorithms() {
        return digestAlgMappings;
    }

    public static final String getDigestJCEFromURI(String uri) {
        Enumeration en = digestAlgMappings.keys();
        while (en.hasMoreElements()) {
            String nextJCE = (String)en.nextElement();
            String nextURI = (String)digestAlgMappings.get(nextJCE);
            if (nextURI == null || !nextURI.equals(uri)) continue;
            return nextJCE;
        }
        return null;
    }

    public static final String getDigestURIFromJCE(String jceUri) {
        return (String)digestAlgMappings.get(jceUri);
    }

    static {
        boolean iaikPresent = false;
        try {
            Class<?> iaikClass = Class.forName("iaik.security.provider.IAIK");
            if (iaikClass != null) {
                Provider iaik = (Provider)iaikClass.newInstance();
                Security.addProvider(iaik);
                KeyFactory.getInstance("DSA", PROVIDER_IAIK);
                iaikPresent = true;
            }
        }
        catch (ClassNotFoundException e) {
            iaikPresent = false;
        }
        catch (InstantiationException e) {
            iaikPresent = false;
        }
        catch (IllegalAccessException e) {
            iaikPresent = false;
        }
        catch (NoSuchProviderException e) {
            iaikPresent = false;
        }
        catch (NoSuchAlgorithmException e) {
            iaikPresent = false;
        }
        STANDARD_PROVIDER = iaikPresent ? PROVIDER_IAIK : PROVIDER_SUN;
        digestAlgMappings = new Hashtable();
        digestAlgMappings.put("MD5", DIGEST_MD5);
        digestAlgMappings.put("SHA1", DIGEST_SHA1);
    }
}

