/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.tokenizer;

import com.sap.engine.lib.xml.dom.DOM;
import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.tokenizer.PHSet;
import com.sap.engine.lib.xml.parser.tokenizer.PrefixHolder;
import com.sap.engine.lib.xml.parser.tokenizer.StringStacker;
import com.sap.engine.lib.xml.parser.tokenizer.XMLTokenWriter;
import com.sap.engine.lib.xsl.xslt.output.Encoder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class XMLTokenWriterImpl
implements XMLTokenWriter {
    private String encoding;
    private String currentName;
    private String namespace;
    private HashMap currentPrefixes;
    private int generatedNSIndex;
    private StringStacker stack;
    private String[] attrNames;
    private String[] attrValues;
    private int attrCount;
    private ArrayList perm;
    private boolean indent;
    StringBuffer indentString;
    private int INDENTCOUNT = 2;
    private char[] indentPiece;
    private int indentLevel = 0;
    private boolean textContent;
    private Encoder enc;
    private PHSet allnamespaces;
    private static final String[] CH_TO_ENT = new String[256];
    private CharArray caCurrentName = new CharArray();
    private PrefixHolder[] cache = new PrefixHolder[128];
    private int ctop = 0;

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public XMLTokenWriterImpl() {
        this.indentPiece = new char[this.INDENTCOUNT];
        for (int i = 0; i < this.INDENTCOUNT; ++i) {
            this.indentPiece[i] = 32;
        }
        this.indent = false;
        this.allnamespaces = new PHSet();
        this.currentPrefixes = new HashMap();
        this.stack = new StringStacker();
        this.attrNames = new String[512];
        this.attrValues = new String[512];
        this.attrCount = 0;
        this.perm = new ArrayList();
        this.indentString = new StringBuffer();
        this.enc = new Encoder();
    }

    private String getPrefixInternal(String namespace) {
        for (int i = 0; i < this.allnamespaces.currentSize; ++i) {
            PrefixHolder ph = this.allnamespaces.get(i);
            if (!ph.namespace.equals(namespace)) continue;
            return ph.top();
        }
        return null;
    }

    private void updateNamespacesDown() {
        String prefix;
        int size = this.allnamespaces.size();
        PrefixHolder[] arr = this.allnamespaces.getContent();
        for (int i = 0; i < size; ++i) {
            PrefixHolder ph = arr[i];
            if (this.currentPrefixes.containsKey(ph.namespace)) {
                prefix = (String)this.currentPrefixes.get(ph.namespace);
                ph.enter(prefix);
                this.attrNames[this.attrCount] = prefix.length() != 0 ? "xmlns:" + prefix : "xmlns";
                this.attrValues[this.attrCount] = this.namespace;
                ++this.attrCount;
                this.currentPrefixes.remove(ph.namespace);
                continue;
            }
            ph.enter();
        }
        Iterator it = this.currentPrefixes.keySet().iterator();
        while (it.hasNext()) {
            String namespace = (String)it.next();
            prefix = (String)this.currentPrefixes.get(namespace);
            PrefixHolder ph = this.getPrefixHolder(namespace);
            this.allnamespaces.add(ph);
            ph.enter(prefix);
            this.attrNames[this.attrCount] = prefix.length() != 0 ? "xmlns:" + prefix : "xmlns";
            this.attrValues[this.attrCount] = namespace;
            ++this.attrCount;
        }
        this.currentPrefixes.clear();
    }

    private void updateNamespaceUp() {
        int size = this.allnamespaces.size();
        PrefixHolder[] arr = this.allnamespaces.getContent();
        int newSize = 0;
        for (int i = 0; i < size; ++i) {
            if (arr[i].leave()) {
                arr[i] = null;
                continue;
            }
            if (i != newSize) {
                arr[newSize] = arr[i];
                arr[i] = null;
            }
            ++newSize;
        }
        this.allnamespaces.setSize(newSize);
    }

    private String generateNSPrefix(String namespace) {
        String prefix = "ns" + String.valueOf(this.generatedNSIndex);
        ++this.generatedNSIndex;
        this.currentPrefixes.put(namespace, prefix);
        return prefix;
    }

    private void appendAttributes() throws IOException {
        for (int i = 0; i < this.attrCount; ++i) {
            if (this.attrValues[i] == null || this.attrNames[i] == null) continue;
            this.enc.out(' ');
            this.enc.out(this.attrNames[i]);
            this.enc.out("='");
            this.enc.outEscaped(this.attrValues[i]);
            this.enc.out('\'');
        }
        this.attrCount = 0;
    }

    private void enterIndent() {
        ++this.indentLevel;
        this.indentString.append(this.indentPiece);
    }

    private void leaveIndent() {
        --this.indentLevel;
        int perm = this.indentString.length();
        this.indentString.setLength(perm - this.INDENTCOUNT);
    }

    private void writeTagOpen() throws IOException {
        if (this.namespace != null && this.namespace.length() != 0) {
            String prefix = (String)this.currentPrefixes.get(this.namespace);
            if (prefix == null && ((prefix = this.getPrefixInternal(this.namespace)) == null || this.currentPrefixes.containsValue(prefix))) {
                prefix = this.generateNSPrefix(this.namespace);
            }
            this.caCurrentName.set(prefix);
            this.caCurrentName.append(':');
            this.caCurrentName.append(this.currentName);
            this.currentName = this.caCurrentName.toString();
        }
        this.updateNamespacesDown();
        if (this.indent) {
            this.enc.out('\n');
            this.enc.out(this.indentString.toString());
        }
        this.enc.out('<');
        this.enc.out(this.currentName);
        this.stack.push(this.currentName);
        this.appendAttributes();
        this.enc.out('>');
        this.currentName = null;
        this.namespace = null;
        if (this.indent) {
            this.enterIndent();
        }
    }

    private void writeTagClose() throws IOException {
        if (this.indent) {
            this.leaveIndent();
        }
        if (this.indent && !this.textContent) {
            this.enc.out('\n');
            this.enc.out(this.indentString.toString());
        }
        this.enc.out("</");
        this.enc.out(this.stack.pop());
        this.enc.out('>');
        this.textContent = false;
    }

    public void init(OutputStream output, Hashtable defaultPrefixes) {
        this.currentPrefixes.clear();
        this.attrCount = 0;
        this.generatedNSIndex = 1;
        this.indentLevel = 0;
        this.indent = false;
        this.enc.init(output);
        this.currentName = null;
        this.stack.clear();
        this.allnamespaces.clear();
        PrefixHolder ph = this.getPrefixHolder("http://www.w3.org/XML/1998/namespace");
        ph.enter("xml");
        this.allnamespaces.add(ph);
        Enumeration keys = defaultPrefixes.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)defaultPrefixes.get(key);
            ph = this.getPrefixHolder(key);
            ph.enter(value);
            this.allnamespaces.add(ph);
        }
    }

    public void init(OutputStream output) {
        this.currentPrefixes.clear();
        this.attrCount = 0;
        this.generatedNSIndex = 1;
        this.indentLevel = 0;
        this.indent = false;
        this.enc.init(output);
        this.currentName = null;
        this.stack.clear();
        this.allnamespaces.clear();
        PrefixHolder ph = this.getPrefixHolder("http://www.w3.org/XML/1998/namespace");
        ph.enter("xml");
        this.allnamespaces.add(ph);
    }

    public void init(OutputStream output, String encoding) {
        this.currentPrefixes.clear();
        this.attrCount = 0;
        this.generatedNSIndex = 1;
        this.indent = false;
        this.indentLevel = 0;
        this.enc.init(output, encoding);
        this.currentName = null;
        this.stack.clear();
        this.allnamespaces.clear();
        PrefixHolder ph = this.getPrefixHolder("http://www.w3.org/XML/1998/namespace");
        ph.enter("xml");
        this.allnamespaces.add(ph);
        this.encoding = encoding.toUpperCase();
    }

    public void init(OutputStream output, String encoding, Hashtable defaultPrefixes) {
        this.currentPrefixes.clear();
        this.attrCount = 0;
        this.generatedNSIndex = 1;
        this.indent = false;
        this.indentLevel = 0;
        this.enc.init(output, encoding);
        this.encoding = encoding.toUpperCase();
        this.currentName = null;
        this.stack.clear();
        this.allnamespaces.clear();
        PrefixHolder ph = this.getPrefixHolder("http://www.w3.org/XML/1998/namespace");
        ph.enter("xml");
        this.allnamespaces.add(ph);
        Enumeration keys = defaultPrefixes.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = (String)defaultPrefixes.get(key);
            ph = this.getPrefixHolder(key);
            ph.enter(value);
            this.allnamespaces.add(ph);
        }
    }

    public void writeInitial() throws IOException {
        this.enc.out("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>");
    }

    public void enter(String namespace, String localName) throws IOException {
        if (this.currentName != null) {
            this.textContent = false;
            this.writeTagOpen();
        }
        this.currentName = localName;
        this.namespace = namespace;
    }

    public void flush() throws IOException {
        try {
            this.enc.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(e.toString());
        }
    }

    public String getPrefixForNamespace(String namespace) throws IOException, IllegalStateException {
        if (this.currentName == null) {
            throw new IllegalStateException("Entering tag already output !");
        }
        if (this.currentPrefixes.get(namespace) != null) {
            return (String)this.currentPrefixes.get(namespace);
        }
        return this.getPrefixInternal(namespace);
    }

    public void leave() throws IOException {
        if (this.currentName != null) {
            this.writeTagOpen();
            this.textContent = false;
        }
        this.writeTagClose();
        this.updateNamespaceUp();
    }

    public void setPrefixForNamespace(String prefix, String namespace) throws IOException, IllegalStateException {
        this.currentPrefixes.put(namespace, prefix);
    }

    public void writeAttribute(String namespace, String name, String value) throws IOException, IllegalStateException {
        if (namespace != null && namespace.length() != 0) {
            String prefix = this.getPrefixInternal(namespace);
            if (prefix == null && (prefix = (String)this.currentPrefixes.get(namespace)) == null) {
                prefix = this.generateNSPrefix(namespace);
            }
            name = prefix + ":" + name;
        }
        this.attrNames[this.attrCount] = name;
        this.attrValues[this.attrCount] = value;
        ++this.attrCount;
    }

    public void writeComment(String comment) throws IOException {
        if (this.currentName != null) {
            this.writeTagOpen();
            if (this.indent) {
                this.textContent = false;
                this.enc.out('\n');
            }
        }
        this.enc.out("<!-- ");
        this.enc.out(comment);
        this.enc.out(" -->");
        if (this.indent) {
            this.enc.out('\n');
        }
    }

    public void writeContentCData(char[] content) throws IOException {
        if (this.currentName != null) {
            this.writeTagOpen();
            this.textContent = true;
        }
        this.writeXMLEscaped(content);
    }

    public void writeContentCData(char[] chars, int offset, int count) throws IOException {
        if (this.currentName != null) {
            this.writeTagOpen();
            this.textContent = true;
        }
        this.enc.outEscaped(chars, offset, count);
    }

    public void writeContentCDataDirect(char[] chars, int offset, int count) throws IOException {
        if (this.currentName != null) {
            this.writeTagOpen();
            this.textContent = true;
        }
        this.enc.outDirect(chars, offset, count);
    }

    public void writeContentCDataDirect(char[] chars) throws IOException {
        this.writeContentCDataDirect(chars, 0, chars.length);
    }

    public void writeContent(String content) throws IOException {
        if (this.currentName != null) {
            this.writeTagOpen();
            this.textContent = true;
        }
        this.enc.outEscaped(content);
    }

    public void writeXmlAttribute(String name, String value) throws IOException, IllegalStateException {
    }

    public void close() throws IOException {
        this.enc.close();
    }

    public void writeStatistics() {
    }

    private void writeXMLEscaped(char[] s) throws IOException {
        this.enc.outEscaped(s, 0, s.length);
    }

    private PrefixHolder getPrefixHolder(String namespace) {
        if (this.ctop == 0) {
            return new PrefixHolder(namespace);
        }
        --this.ctop;
        this.cache[this.ctop].namespace = namespace;
        return this.cache[this.ctop];
    }

    public static void outputDomToWriter(XMLTokenWriter writer, Node node) throws IOException {
        if (node == null) {
            return;
        }
        switch (node.getNodeType()) {
            case 3: 
            case 5: {
                writer.writeContent(node.getNodeValue());
                break;
            }
            case 8: {
                writer.writeContent(node.getNodeValue());
                break;
            }
            case 1: {
                Element element = (Element)node;
                String localName = element.getLocalName();
                String namespace = element.getNamespaceURI();
                writer.enter(namespace, localName);
                NamedNodeMap attributes = element.getAttributes();
                for (int i = 0; i < attributes.getLength(); ++i) {
                    Attr attribute = (Attr)attributes.item(i);
                    if (attribute.getName().startsWith("xmlns:")) {
                        String dnamespace;
                        String dprefix = DOM.qnameToLocalName(attribute.getName());
                        if (dprefix.equals(writer.getPrefixForNamespace(dnamespace = attribute.getValue()))) continue;
                        writer.setPrefixForNamespace(dprefix, dnamespace);
                        continue;
                    }
                    if ("xmlns".equals(attribute.getName())) continue;
                    writer.writeAttribute(attribute.getNamespaceURI(), attribute.getLocalName(), attribute.getValue());
                }
                for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                    XMLTokenWriterImpl.outputDomToWriter(writer, child);
                }
                writer.leave();
                break;
            }
        }
    }

    static {
        XMLTokenWriterImpl.CH_TO_ENT[38] = "&amp;";
        XMLTokenWriterImpl.CH_TO_ENT[39] = "&apos;";
        XMLTokenWriterImpl.CH_TO_ENT[34] = "&quot;";
        XMLTokenWriterImpl.CH_TO_ENT[60] = "&lt;";
        XMLTokenWriterImpl.CH_TO_ENT[62] = "&gt;";
    }
}

