/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.pool;

import com.sap.engine.lib.xml.parser.helpers.Reference;

public final class ReferenceHolderPool {
    private int initialSize;
    private int resizeStep = 100;
    private int pos;
    private Reference[][] arrayOfObjects;

    public int getPos() {
        return this.pos;
    }

    public void releasePool() {
        this.pos = this.arrayOfObjects.length - 1;
    }

    public ReferenceHolderPool(int initSize, int step) {
        if (step < 1 || initSize < 1) {
            throw new IllegalArgumentException("Wrong value of initialSize or resizeStep parameter");
        }
        this.initialSize = initSize;
        this.resizeStep = step;
        this.arrayOfObjects = new Reference[this.initialSize][];
        for (int i = 0; i < this.initialSize; ++i) {
            this.arrayOfObjects[i] = new Reference[1];
        }
        this.pos = this.initialSize - 1;
    }

    public Reference[] getObject() {
        if (this.pos < 0) {
            this.autoResize();
        }
        return this.arrayOfObjects[this.pos--];
    }

    public void releaseObject(Reference[] obj) {
        if (this.pos < this.arrayOfObjects.length - 1) {
            ++this.pos;
            this.arrayOfObjects[this.pos] = obj;
        }
    }

    public void setResizeStep(int step) {
        if (step < 1) {
            throw new IllegalArgumentException("Wrong value of resizeStep parameter");
        }
        this.resizeStep = step;
    }

    public int getResizeStep() {
        return this.resizeStep;
    }

    public void setInitialSize(int initSize) {
        if (initSize < 1) {
            throw new IllegalArgumentException("Wrong value of initSize parameter");
        }
        this.initialSize = initSize;
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void release() {
        for (int i = 0; i < this.pos; ++i) {
            this.arrayOfObjects[i] = null;
        }
    }

    private void autoResize() {
        int i;
        Reference[][] tempArr = new Reference[this.arrayOfObjects.length + this.resizeStep][];
        for (i = 0; i < this.resizeStep; ++i) {
            tempArr[i] = new Reference[1];
        }
        for (i = 0; i < this.arrayOfObjects.length; ++i) {
            tempArr[i + this.resizeStep] = this.arrayOfObjects[i];
        }
        this.arrayOfObjects = tempArr;
        this.pos = this.resizeStep - 1;
    }

    public void check() throws Exception {
        for (int i = 0; i < this.arrayOfObjects.length; ++i) {
            for (int j = i + 1; j < this.arrayOfObjects.length; ++j) {
                if (this.arrayOfObjects[i] != this.arrayOfObjects[j]) continue;
                throw new Exception("they are equal:" + i + "," + j + " " + this.arrayOfObjects[i] + ", " + this.arrayOfObjects[j]);
            }
        }
    }
}

