/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.lib.xml.parser.helpers;

import com.sap.engine.lib.xml.parser.helpers.CharArray;
import com.sap.engine.lib.xml.parser.helpers.Encoding;

public final class UTF8Encoding
extends Encoding {
    private int[] res = new int[2];
    private byte[] utf8buf = new byte[10];
    private byte utf8buflen = 0;
    private int utf8left = 0;
    private int x1;
    public static final CharArray NAME = new CharArray("utf-8");

    public int process(byte ch) {
        if (this.utf8left > 0) {
            byte by = this.utf8buflen;
            this.utf8buflen = (byte)(by + 1);
            this.utf8buf[by] = ch;
            --this.utf8left;
            if ((ch & 0x80) != 128) {
                return -1;
            }
            if (this.utf8left > 0) {
                return -2;
            }
        }
        if (this.utf8left == 0 && this.utf8buflen > 0) {
            this.x1 = this.parseUTF8toUCS4(this.utf8buf, 0, this.utf8buflen)[1];
            this.utf8buflen = 0;
            return this.x1;
        }
        this.x1 = ch;
        if (ch < 0 && this.utf8left == 0) {
            this.utf8left = this.getUTF8CharCount(ch);
            byte by = this.utf8buflen;
            this.utf8buflen = (byte)(by + 1);
            this.utf8buf[by] = ch;
            --this.utf8left;
            if (ch > 253) {
                return -1;
            }
            return -2;
        }
        return this.x1;
    }

    public int reverseEncode(byte[] converted, int character) {
        int length = -1;
        if (character < 128) {
            if (converted.length < 1) {
                return -1;
            }
            converted[0] = (byte)character;
            length = 1;
        } else if (character < 2048) {
            if (converted.length < 2) {
                return -1;
            }
            converted[0] = (byte)(0xC0 | character >> 6);
            converted[1] = (byte)(0x80 | character & 0x3F);
            length = 2;
        } else if (character < 65536) {
            if (converted.length < 3) {
                return -1;
            }
            converted[0] = (byte)(0xE0 | character >> 12);
            converted[1] = (byte)(0x80 | character >> 6 & 0x3F);
            converted[2] = (byte)(0x80 | character & 0x3F);
            length = 3;
        } else if (character < 0x200000) {
            if (converted.length < 4) {
                return -1;
            }
            converted[0] = (byte)(0xF0 | character >> 18);
            converted[1] = (byte)(0x80 | character >> 12 & 0x3F);
            converted[2] = (byte)(0x80 | character >> 6 & 0x3F);
            converted[3] = (byte)(0x80 | character & 0x3F);
            length = 4;
        } else if (character < 0x4000000) {
            if (converted.length < 5) {
                return -1;
            }
            converted[0] = (byte)(0xF8 | character >> 24);
            converted[1] = (byte)(0x80 | character >> 18 & 0x3F);
            converted[2] = (byte)(0x80 | character >> 12 & 0x3F);
            converted[3] = (byte)(0x80 | character >> 6 & 0x3F);
            converted[4] = (byte)(0x80 | character & 0x3F);
            length = 5;
        } else {
            if (converted.length < 6) {
                return -1;
            }
            converted[0] = (byte)(0xFC | character >> 30);
            converted[1] = (byte)(0x80 | character >> 24 & 0x3F);
            converted[2] = (byte)(0x80 | character >> 18 & 0x3F);
            converted[3] = (byte)(0x80 | character >> 12 & 0x3F);
            converted[4] = (byte)(0x80 | character >> 6 & 0x3F);
            converted[5] = (byte)(0x80 | character & 0x3F);
            length = 6;
        }
        return length;
    }

    protected int[] parseUTF8toUCS4(byte[] data, int off, int len) {
        this.res[0] = len;
        if (len == 6) {
            this.res[1] = (data[off] & 1) << 30;
            this.res[1] = this.res[1] | (data[off + 1] & 0x3F) << 24;
            this.res[1] = this.res[1] | (data[off + 2] & 0x3F) << 18;
            this.res[1] = this.res[1] | (data[off + 3] & 0x3F) << 12;
            this.res[1] = this.res[1] | (data[off + 4] & 0x3F) << 6;
            this.res[1] = this.res[1] | data[off + 5] & 0x3F;
        } else if (len == 5) {
            this.res[1] = (data[off] & 3) << 24;
            this.res[1] = this.res[1] | (data[off + 1] & 0x3F) << 18;
            this.res[1] = this.res[1] | (data[off + 2] & 0x3F) << 12;
            this.res[1] = this.res[1] | (data[off + 3] & 0x3F) << 6;
            this.res[1] = this.res[1] | data[off + 4] & 0x3F;
        } else if (len == 4) {
            this.res[1] = (data[off] & 7) << 18;
            this.res[1] = this.res[1] | (data[off + 1] & 0x3F) << 12;
            this.res[1] = this.res[1] | (data[off + 2] & 0x3F) << 6;
            this.res[1] = this.res[1] | data[off + 3] & 0x3F;
        } else if (len == 3) {
            this.res[1] = (data[off] & 0xF) << 12;
            this.res[1] = this.res[1] | (data[off + 1] & 0x3F) << 6;
            this.res[1] = this.res[1] | data[off + 2] & 0x3F;
        } else if (len == 2) {
            this.res[1] = (data[off] & 0x1F) << 6;
            this.res[1] = this.res[1] | data[off + 1] & 0x3F;
        } else if (len == 1) {
            this.res[1] = data[off];
        }
        return this.res;
    }

    protected int getUTF8CharCount(byte ch) {
        if ((ch & 0xFE) == 254) {
            return -1;
        }
        if ((ch & 0xFC) == 252) {
            return 6;
        }
        if ((ch & 0xF8) == 248) {
            return 5;
        }
        if ((ch & 0xF0) == 240) {
            return 4;
        }
        if ((ch & 0xE0) == 224) {
            return 3;
        }
        if ((ch & 0xC0) == 192) {
            return 2;
        }
        return 1;
    }

    public CharArray getName() {
        return NAME;
    }
}

